﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Text;
//using DinkToPdf;
//using DinkToPdf.Contracts;
using Microsoft.Extensions.Logging;

using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using ServiceApp.Enums;
using ServiceApp.Extensions;
using ServiceApp.Models;
using ServiceApp.Services;

namespace ServiceApp.Services
{
    public interface IReportService
    {
        ServiceResult SaveReport(ReportModel model);
    }

    public class ReportService : IReportService
    {
        // private IConverter _converter { get; set; }
        private ILogger<ProjectionService> _logger { get; set; }

        public ReportService(ILogger<ProjectionService> logger)
        {
            //_converter = converter;
            _logger = logger;
        }

        public ServiceResult SaveReport(ReportModel model)
        {
            var base64 = model.Data;
            if (base64.StartsWith("data:application/pdf;base64,"))
                base64 = base64.Remove(0, "data:application/pdf;base64,".Length);
            byte[] bytes = Convert.FromBase64String(base64);
            try
            {
                File.WriteAllBytes(model.FilePath, bytes);
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, $"SaveReport(): Exception writing settings file.");
                return new ServiceResult(Result.Error);
            }

            return new ServiceResult(Result.Success);
        }

        private string GenerateHTML(ProjectionModel model)
        {
            var sb = new StringBuilder();
            sb.Append(File.ReadAllText(@".\Reports\ProjectionReport.html"));
            return sb.ToString();
        }
    }
}
