﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Text;

using Microsoft.Extensions.Logging;

using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using ServiceApp.Enums;
using ServiceApp.Extensions;
using ServiceApp.Models;
using ServiceApp.Services;

namespace ServiceApp.Services
{
    public interface IProjectionService
    {
        ServiceResult LoadProjection(string filePath);
        ServiceResult SaveProjection(string filePath, ProjectionModel projection);        
    }

    public class ProjectionService : IProjectionService
    {
        private IComputationService _compService { get; set; }
        private ILogger<ProjectionService> _logger { get; set; }
        
        public ProjectionService(IComputationService compService, ILogger<ProjectionService> logger)
        {
            _compService = compService;
            _logger = logger;            
        }

        public ServiceResult LoadProjection(string filePath)
        {
            ProjectionModel projection = null;
            try
            {   
                using (var sr = new StreamReader(filePath))
                {
                    var json = sr.ReadToEnd();             
                    projection = JsonConvert.DeserializeObject<ProjectionModel>(json);
                }
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, $"SaveProjection(): Exception while saving projection. Path=${filePath}");
                return new ServiceResult(Result.Error);
            }

            return new ServiceResult(Result.Success, projection);
        }

        public ServiceResult SaveProjection(string filePath, ProjectionModel projection)
        {
            try
            {  
                projection.AppVersion = Assembly.GetExecutingAssembly().GetName().Version.ToString();
                using (var sw = new StreamWriter(filePath))
                {
                    var data = JObject.FromObject(projection);
                    data.Remove("Membrans");
                    data.Remove("VPPM");
                    data.Remove("VCacO3");
                    data.Remove("VMilli");
                    var passes = (JArray)data["Pass"];
                    ((JObject)passes[0]).Remove("CalcData");
                    ((JObject)passes[1]).Remove("CalcData");

                    var json = data.ToString(Formatting.Indented, new JsonConverter[] { new StringEnumConverter() });
                    //var json = JsonConvert.SerializeObject(projection, Formatting.Indented, new JsonConverter[] { new StringEnumConverter() });
                    sw.Write(json);
                }
            }
            catch (Exception ex)
            {
                _logger.LogError(ex, $"SaveProjection(): Exception while saving projection. Path=${filePath}");
                return new ServiceResult(Result.Error);
            }

            return new ServiceResult(Result.Success);
        }       
    }
}
