﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

using NLog;
using NLog.Targets;
using NLog.Config;

using ServiceApp.Enums;
using ServiceApp.Models;
using System.Reflection;
using System.Collections;
using Newtonsoft.Json.Linq;

namespace ServiceApp.Services
{
    public interface ILogService
    {
        ServiceResult InitLogger(LogLevel logLevel);
        ServiceResult UpdateLogLevel(LogLevel logLevel);
        ServiceResult DeleteExpiredLogs();
        void LogValues(ProjectionModel model, string section, bool isNew = false);
    }

    public class LogService : ILogService
    {
        private const string _fileTargetName = "FileTarget1";
        private string _logPath { get; set; }
        private ILogger _logger { get; set; }

        public LogService()
        {
            _logPath = Environment.ExpandEnvironmentVariables("%userprofile%/AppData/Local/Microdyn-Nadir-ROAM/Logs/");
        }

        public ServiceResult InitLogger(LogLevel logLevel)
        {
            var config = new LoggingConfiguration();
            var fileTarget = new FileTarget(_fileTargetName)
            {
                FileName = _logPath + @"${shortdate}.log",
                Layout = "${processid}|${longdate}|${uppercase:${level}}|${logger}|${message} ${exception:format=tostring}"
            };
            config.AddTarget(fileTarget);
            LogManager.Configuration = config;

            var rule = new LoggingRule("*", logLevel, fileTarget);
            LogManager.Configuration.LoggingRules.Add(rule);

            _logger = LogManager.GetCurrentClassLogger();
            _logger.Info($"InitLogger(): Logger Configured. Path={fileTarget.FileName}");

            return new ServiceResult(Result.Success);
        }

        public ServiceResult UpdateLogLevel(LogLevel logLevel)
        {
            foreach (var rule in LogManager.Configuration.LoggingRules)
            {
                rule.SetLoggingLevels(LogLevel.Fatal, logLevel);
            }

            return new ServiceResult(Result.Success);
        }

        public ServiceResult DeleteExpiredLogs()
        {
            try
            {
                foreach (string logFile in Directory.GetFiles(_logPath, "*.log"))
                {
                    FileInfo fi = new FileInfo(logFile);
                    if (fi.LastAccessTime < DateTime.Now.AddDays(-5))
                        fi.Delete();
                }
            }
            catch (Exception ex)
            {
                _logger.Error(ex, $"DeleteExpiredLogs(): Exception deleting expired logs.");
                return new ServiceResult(Result.Error);
            }

            _logger.Info("DeleteExpiredLogs(): Success");
            return new ServiceResult(Result.Success);
        }

        public void LogValues(ProjectionModel model, string section, bool isNew = false)
        {
            return;
            //const string doubleFmt = "#######0.0000000000";

            //var props = GetLogProperties();
            //var headerString = "";
            //var vbDataString = "dataString = ";
            //var csDataString = "";
            //var nameIdx = 1;

            //foreach (var prop in props)
            //{
            //    var workingHeaderString = $"\"{prop.Name}\",";

            //    var pi = model.CalcData.GetType().GetProperty(prop.Name);
            //    object propValue = "";
            //    if (pi != null)
            //        propValue = pi.GetValue(model.CalcData, null);

            //    if (prop.Name.ToLower() == "section")
            //    {
            //        vbDataString += $"\"\"\"\" & {prop.Name} & \"\"\"\" & \",\" & ";
            //        csDataString += $"\"{section}\",";
            //    }
            //    else if (prop.Type == "string")
            //    {
            //        vbDataString += $"\"\"\"\" & {prop.Name} & \"\"\"\" & \",\" & ";
            //        csDataString += $"\"{propValue}\",";
            //    }
            //    else if (prop.Type == "double")
            //    {
            //        vbDataString += $"Format({prop.Name}, \"{doubleFmt}\") & \",\" & ";
            //        csDataString += $"{Convert.ToDouble(propValue).ToString(doubleFmt)},";
            //    }
            //    else if (prop.Type == "array-double")
            //    {
            //        workingHeaderString = "";
            //        var propList = GetProps(prop);
            //        foreach (var arrProp in propList["VB"])
            //        {
            //            workingHeaderString += $"\"{arrProp}\",";
            //            vbDataString += $"Format({arrProp.Replace('.', ',').Replace('[', '(').Replace(']', ')')}, \"{doubleFmt}\") & \",\" & ";
            //            vbDataString = AddVBContinuation(vbDataString, nameIdx);
            //            nameIdx++;
            //        }

            //        foreach (var arrProp in propValue as IEnumerable)
            //            csDataString += $"{Convert.ToDouble(arrProp).ToString(doubleFmt)},";

            //    }
            //    else if (prop.Type == "array-int")
            //    {
            //        workingHeaderString = "";
            //        var propList = GetProps(prop);
            //        foreach (var arrProp in propList["VB"])
            //        {
            //            workingHeaderString += $"\"{arrProp}\",";
            //            vbDataString += $"{arrProp.Replace('.', ',').Replace('[', '(').Replace(']', ')')} & \",\" & ";
            //            vbDataString = AddVBContinuation(vbDataString, nameIdx);
            //            nameIdx++;
            //        }


            //        foreach (var arrProp in propValue as IEnumerable)
            //            csDataString += $"{(int)arrProp},";
            //    }
            //    else if (prop.Type == "array-string")
            //    {
            //        workingHeaderString = "";
            //        var propList = GetProps(prop);
            //        foreach (var arrProp in propList["VB"])
            //        {
            //            workingHeaderString += $"\"{arrProp}\",";
            //            //vbDataString += $"\"{arrProp}\" & \",\" & ";
            //            vbDataString += $"\"\"\"\" & {arrProp} & \"\"\"\" & \",\" & ";
            //            vbDataString = AddVBContinuation(vbDataString, nameIdx);
            //            nameIdx++;
            //        }


            //        foreach (var arrProp in propValue as IEnumerable)
            //        {
            //            string value = (string)arrProp;
            //            if (value == null)
            //                value = "";
            //            csDataString += $"\"{value}\",";
            //        }
            //    }
            //    else
            //    {
            //        vbDataString += $"{prop.Name} & \",\" & ";
            //        csDataString += $"{propValue},";
            //    }

            //    headerString += workingHeaderString;
            //    vbDataString = AddVBContinuation(vbDataString, nameIdx);
            //    nameIdx++;
            //}
            //headerString = headerString.Substring(0, headerString.Length - 1);
            //vbDataString = vbDataString.Substring(0, vbDataString.Length - 9);
            //csDataString = csDataString.Substring(0, csDataString.Length - 1);

            //File.WriteAllText("c:/share/roam/log-values-vb-header.txt", headerString);
            //File.WriteAllText("c:/share/roam/log-values-vb-data.txt", vbDataString);

            //if (isNew)
            //    File.WriteAllText("c:/share/roam/log-values-cs.csv", $"{headerString}{Environment.NewLine}");
            //File.AppendAllText("c:/share/roam/log-values-cs.csv", $"{csDataString}{Environment.NewLine}");
        }

        private string AddVBContinuation(string vbString, int nameIdx)
        {
            if (nameIdx % 20 == 0)
            {
                vbString = vbString.Substring(0, vbString.Length - 9);
                vbString += $"{Environment.NewLine}dataString = dataString & \",\" & ";
            }
            return vbString;
        }

        private Dictionary<string, List<string>> GetProps(ParamType prop)
        {
            var dict = new Dictionary<string, List<string>>();
            dict.Add("VB", new List<string>());
            dict.Add("CS", new List<string>());

            switch (prop.DimCount)
            {
                case 1:
                    for (int i = 0; i < prop.Dim1Max; i++)
                        dict["VB"].Add($"{prop.Name}({i})");
                    break;
                case 2:
                    for (int i = 0; i < prop.Dim1Max; i++)
                        for (int j = 0; j < prop.Dim2Max; j++)
                            dict["VB"].Add($"{prop.Name}({i}.{j})");
                    break;
                case 3:
                    for (int i = 0; i < prop.Dim1Max; i++)
                        for (int j = 0; j < prop.Dim2Max; j++)
                            for (int k = 0; k < prop.Dim3Max; k++)
                                dict["VB"].Add($"{prop.Name}({i}.{j}.{k})");
                    break;
            }

            return dict;
        }


        private List<ParamType> GetLogProperties()
        {
            var list = new List<ParamType>() {
                new ParamType() { Name = "section", Type = "string" },
                new ParamType() { Name = "fc022", Type = "double" },
                new ParamType() { Name = "Feed_Ret", Type = "double" },
                new ParamType() { Name = "Con_Ret", Type = "double" },
                new ParamType() { Name = "cph", Type = "double" },
                new ParamType() { Name = "pph", Type = "double" },
                new ParamType() { Name = "dos", Type = "double" },
                new ParamType() { Name = "RetStatus", Type = "double" },
                new ParamType() { Name = "cph2", Type = "double" },
                new ParamType() { Name = "pph2", Type = "double" },
                new ParamType() { Name = "age", Type = "double" },
                new ParamType() { Name = "bfact", Type = "double" },
                new ParamType() { Name = "ftemp", Type = "double" },
                new ParamType() { Name = "TCor", Type = "double" },
                new ParamType() { Name = "PProd", Type = "double" },
                new ParamType() { Name = "sp_fact", Type = "double" },
                new ParamType() { Name = "fee", Type = "double" },
                new ParamType() { Name = "con", Type = "double" },
                new ParamType() { Name = "fco3", Type = "double" },
                new ParamType() { Name = "fco2", Type = "double" },
                new ParamType() { Name = "fhco3", Type = "double" },
                new ParamType() { Name = "acids", Type = "double" },
                new ParamType() { Name = "acidc", Type = "double" },
                new ParamType() { Name = "caustic", Type = "double" },
                new ParamType() { Name = "fcl", Type = "double" },
                new ParamType() { Name = "fso4", Type = "double" },
                new ParamType() { Name = "fna", Type = "double" },
                new ParamType() { Name = "prod_toti", Type = "double" },
                new ParamType() { Name = "prod_totp", Type = "double" },
                new ParamType() { Name = "deltapav", Type = "double" },
                new ParamType() { Name = "osm_c", Type = "double" },
                new ParamType() { Name = "feedav", Type = "double" },
                new ParamType() { Name = "pnetn_av", Type = "double" },
                new ParamType() { Name = "flow_ft", Type = "double" },
                new ParamType() { Name = "rec_l", Type = "double" },
                new ParamType() { Name = "rec_h", Type = "double" },
                new ParamType() { Name = "rec_av", Type = "double" },
                new ParamType() { Name = "pressf", Type = "double" },
                new ParamType() { Name = "Rec", Type = "double" },
                new ParamType() { Name = "p_salp", Type = "double" },
                new ParamType() { Name = "p_prod", Type = "double" },
                new ParamType() { Name = "flow_f", Type = "double" },
                new ParamType() { Name = "flow_pt", Type = "double" },
                new ParamType() { Name = "press_l", Type = "double" },
                new ParamType() { Name = "press_h", Type = "double" },
                new ParamType() { Name = "flow_b", Type = "double" },
                new ParamType() { Name = "flow_bav", Type = "double" },
                new ParamType() { Name = "deltap", Type = "double" },
                new ParamType() { Name = "pneti", Type = "double" },
                new ParamType() { Name = "prod", Type = "double" },
                new ParamType() { Name = "feed", Type = "double" },
                new ParamType() { Name = "sumfp", Type = "double" },
                new ParamType() { Name = "fdecl", Type = "double" },
                new ParamType() { Name = "avsp", Type = "double" },
                new ParamType() { Name = "osma", Type = "double" },
                new ParamType() { Name = "osmb", Type = "double" },
                new ParamType() { Name = "tdsf", Type = "double" },
                new ParamType() { Name = "avg_ppress", Type = "double" },
                new ParamType() { Name = "ppress_sum", Type = "double" },
                new ParamType() { Name = "ftemp2", Type = "double" },
                new ParamType() { Name = "pprod2", Type = "double" },                                
                new ParamType() { Name = "recint", Type = "double" },
                new ParamType() { Name = "start", Type = "double" },
                new ParamType() { Name = "elapsed", Type = "double" },
                new ParamType() { Name = "ph", Type = "double" },
                new ParamType() { Name = "fph", Type = "double" },
                new ParamType() { Name = "feedflow", Type = "double" },
                new ParamType() { Name = "nbanks", Type = "int" },
                new ParamType() { Name = "el_tot", Type = "double" },
                new ParamType() { Name = "str", Type = "string" },
                new ParamType() { Name = "ptr", Type = "string" },
                new ParamType() { Name = "ptr2", Type = "string" },
                new ParamType() { Name = "tdsc", Type = "double" },
                new ParamType() { Name = "TotalArea", Type = "double" },
                new ParamType() { Name = "Tube", Type = "array-int", DimCount = 2, Dim1Max = 2, Dim2Max = 4 },
                new ParamType() { Name = "t_ion_ppm", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "ion_ppmf", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "ion_ppm", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "prod", Type = "double" },
                new ParamType() { Name = "PProd", Type = "double" },                
                new ParamType() { Name = "Blend", Type = "double" },
                new ParamType() { Name = "PANumd", Type = "array-string", DimCount = 1, Dim1Max = 19 },

                new ParamType() { Name = "pnetn", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "col", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "Rej_Ions", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "el_bank", Type = "array-int", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "area", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "leak", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "pcoef", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "atc", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "afact", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "prod_sn", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "prod_snt", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "prod_toti", Type = "double" },
                new ParamType() { Name = "prod_totp", Type = "double" },
                new ParamType() { Name = "rej", Type = "array-double", DimCount = 1, Dim1Max = 7 },

                new ParamType() { Name = "press_feed", Type = "array-double", DimCount = 1, Dim1Max = 7 },
                new ParamType() { Name = "flow_feed", Type = "array-double", DimCount = 1, Dim1Max = 5 },
                new ParamType() { Name = "ion_ppmp", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "ion_ppmb", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "ion_ppmc", Type = "array-double", DimCount = 1, Dim1Max = 14 },
                new ParamType() { Name = "scp", Type = "array-double", DimCount = 1, Dim1Max = 15 },
                new ParamType() { Name = "scpk", Type = "array-double", DimCount = 1, Dim1Max = 15 },
        /*
    
                model.CalcData.press_feed[0] = model.CalcData.pressf;
                model.CalcData.flow_feed[0] = model.CalcData.flow_f;
       
                    model.CalcData.ion_ppmp[i] = (1 - model.CalcData.Rej_Ions[i]) * model.CalcData.t_ion_ppm[i] * (Math.Log(1 / (1 - model.CalcData.recint)) / model.CalcData.recint);
                    model.CalcData.ion_ppmb[i] = ((model.CalcData.t_ion_ppm[i] * (model.CalcData.feedflow)) - (model.CalcData.ion_ppmp[i] * model.CalcData.PProd)) / (model.CalcData.feedflow - model.CalcData.PProd);
                    model.CalcData.ion_ppmc[i] = model.CalcData.t_ion_ppm[i];
                    model.CalcData.scp[i] = (double)0;
                    model.CalcData.scpk[i]
       
                
                
        */


            

            };
            return list;
        }

        public class ParamType
        {
            public string Name { get; set; }
            public string Type { get; set; }
            public int DimCount { get; set; }
            public int Dim1Max { get; set; }
            public int Dim2Max { get; set; }
            public int Dim3Max { get; set; }

            public ParamType()
            {
                Name = "";
                Type = "string";
                DimCount = 0;
                Dim1Max = 0;
                Dim2Max = 0;
                Dim3Max = 0;
            }
        }
    }
}
