﻿using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Extensions.Logging;

using ServiceApp.Extensions;
using ServiceApp.Models;

namespace ServiceApp.Services
{
    public interface IComputationService
    {
        void AdjustForTruncation(ProjectionModel projection);
    }

    public class ComputationService : IComputationService
    {
        private ILogger<ComputationService> _logger { get; set; }
        
        public ComputationService(ILogger<ComputationService> logger)
        {
            _logger = logger;            
        }

        public void AdjustForTruncation(ProjectionModel projection)
        {
            return;
            projection.Temperature = projection.Temperature.Adjust4Truncate();
            projection.pH = projection.pH.Adjust4Truncate();
            projection.Manganese = projection.Manganese.Adjust4Truncate();
            projection.Iron = projection.Iron.Adjust4Truncate();
            projection.SaltDensityIndex = projection.SaltDensityIndex.Adjust4Truncate();
            projection.Turbidity = projection.Turbidity.Adjust4Truncate();
            projection.Conductivity = projection.Conductivity.Adjust4Truncate();
            projection.Aluminum = projection.Aluminum.Adjust4Truncate();
            projection.CarbonDioxide = projection.CarbonDioxide.Adjust4Truncate();

            projection.Ions[0].Value = projection.Ions[0].Value.Adjust4Truncate();
            projection.Ions[1].Value = projection.Ions[1].Value.Adjust4Truncate();
            projection.Ions[2].Value = projection.Ions[2].Value.Adjust4Truncate();
            projection.Ions[3].Value = projection.Ions[3].Value.Adjust4Truncate();
            projection.Ions[4].Value = projection.Ions[4].Value.Adjust4Truncate();
            projection.Ions[5].Value = projection.Ions[5].Value.Adjust4Truncate();
            projection.Ions[6].Value = projection.Ions[6].Value.Adjust4Truncate();
            projection.Ions[7].Value = projection.Ions[7].Value.Adjust4Truncate();
            projection.Ions[8].Value = projection.Ions[8].Value.Adjust4Truncate();
            projection.Ions[9].Value = projection.Ions[9].Value.Adjust4Truncate();
            projection.Ions[10].Value = projection.Ions[10].Value.Adjust4Truncate();
            projection.Ions[11].Value = projection.Ions[11].Value.Adjust4Truncate();
            projection.Ions[12].Value = projection.Ions[12].Value.Adjust4Truncate();
            projection.Ions[13].Value = projection.Ions[13].Value.Adjust4Truncate();
           
            //projection.CalcData.ftemp = Math.Round(projection.CalcData.ftemp, 1);
            //projection.CalcData.PANumd[2] = Math.Round(Convert.ToDouble(projection.CalcData.PANumd[2]), 1).ToString();
            //projection.CalcData.PANumd[17] = string.IsNullOrWhiteSpace(projection.CalcData.PANumd[17]) ? "0" : projection.CalcData.PANumd[17];
            //projection.CalcData.PANumd[18] = string.IsNullOrWhiteSpace(projection.CalcData.PANumd[18]) ? "0" : projection.CalcData.PANumd[18];

        }

        
    }  
}
