﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

using NLog;

namespace ServiceApp.Models
{
    public class SettingsModel
    {
        public string AppVersion { get { return Assembly.GetExecutingAssembly().GetName().Version.ToString(); } }
        public string LastProjectionBy { get; set; }
        public string LastSavePath { get; set; }
        public string LastSaveReportPath { get; set; }
        public string LogLevel { get; set; }
        public int LogRetentionDays { get; set; }
        public int IterationTimeoutSeconds { get; set; }
        public Dictionary<string, ElementModel> Elements { get; set; }

        public SettingsModel()
        {
            Elements = new Dictionary<string, ElementModel>();            
        }
    }
}
