﻿using System;
using System.Collections.Generic;
using System.Text;

using ServiceApp.Enums;

namespace ServiceApp.Models
{
    public class IonModel
    {
        public string Name { get; set; }
        public double Value { get; set; }
        public string UnitType { get; set; }
        public double Weight { get; set; }
        public IonType IonType { get; set; }

        public IonModel() {
            Value = 0.0;
            UnitType = "ppm";            
        }

        public IonModel(string name, IonType ionType, double value, string unitType)
        {
            Name = name;
            Value = value;
            UnitType = unitType;
            IonType = ionType;
        }
    }
}
