﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ServiceApp.Extensions
{
    public static class Double
    {
        // MH - The VB6 app saved data in Access as single precision float (only 7 significant digits).
        //      Adjusting the raw water values in a similar way so calulations match between the apps.
        //      Client may want the numbers to be more accurate in the end, simply return number input parameter
        public static double Adjust4Truncate(this double number, int significantDigits = 7)
        {
            var numberString = Convert.ToString(number);
            significantDigits++;  // One more than needed so we can round            
            if (numberString.Contains('.'))
                significantDigits++;
            if (numberString.Length >= significantDigits)
            {
                numberString = numberString.Substring(0, significantDigits);
                number = Convert.ToDouble(numberString);

                var decimalPointIndex = numberString.IndexOf('.') + 2;
                if (decimalPointIndex >= 0)
                    number = Math.Round(number, numberString.Length - decimalPointIndex);
            }

            return number;
        }
    }
}
