# Change Log - MICRODYN-NADIR ROAM



## 2.0.1

* Updated elements.json with new elements data.

* Added node_modules.zip to root folder to ensure correct version of modules are available for build.  This will need to be updated if the unzipped working copies are updated.

* Updated build document to reflect node_modules.zip usage.



## 2.0.0

* Removed Pass 1 text on Concentrate header in Water Saturation Indexes table for single pass projections.

* Added minimum window size to prevent staging section from stretching outside of background box.

* Tested with EV code signing certificate.

* Added CaCO3 to Cation and Anion unit drop downs.

* Updated BuildInstructions.md, entire build process is documented.

  


## 1.0.27
* Changed columns for Design Calculation when viewing at medium view port width; went from one column to three.
* Changed label and error messages from Salt Density Index (SDI) to Silt Density Index (SDI)
* Added new elements to default list.  Verified and updated values based on Element Database.xlsx.
* Switching unit selection now does a unit conversion on product flow, recirc flow, and blend flow values on both passes.
* Changed Raw Water Next button to Calculate.  Button only offers to run auto balance or manual edit.  To proceed to Design Calculation the tab must be clicked; which still checks for balanced water and to save if needed.



## 1.0.26
* Changed turbidity message to display when greater than 1.0
* Elements are now loaded dynamically from external file (in %userprofile%/AppData/Local/Microdyn-Nadir-ROAM/elements.json), allowing new models to be added without recompiling app.
* In report viewer, removed print button and renamed download to "Export to PDF"



## 1.0.25
* Reworked PDF download to default to projection file name and .pdf extension
* Pass 2 validation does turn on until pass 2 is viewed or calculate button is clicked; prevents pass 2 errors while on pass 1 initially.



## 1.0.24
* Water Saturation Table
  * Renamed table title to "Water Saturation Indexes".
  * Removed iron and aluminum rows.
  * Fixed calculation issue with saturation indexes.  One molecular weight was wrong and temperature not converted when in Fahrenheit.
  * Wrong pH passed in for Concentrate column fixed. 
  
* Fixed issue where two pass systems were overwriting the first pass recovery value, causing different results when running calculations with same input values.

* Found and fixed issue with wrong temperature value being passed in to Osmotic Pressure calculation.

* Force PDF viewer to add .pdf to end of filename when downloading if extension isn't there.

* Allow negative sign entry in textboxes.  Validation shows the normal warning dialog if negative number isn't allowed.

* Fixed number of elements / vessel validation issue on pass 1 stage two.

* Second pass raw water pH is set with first pass permeate pH.

* Added zero or greater validation to flux decline and SPIF, both passes.

  

## 1.0.23

* Reworded Cations and Anions validation error message to: "Enter correct [Cation/Anion Name] concentration. Value must be equal to or greater than zero."
* Removed extra apostrophe before "Permeate" in Individual Elements table.
* Added Solubility & Design Warnings for iron, manganese, aluminum, SDI, and turbidity.
* Changed 0.0 to dash for first stage boost pressure in report.
* Fixed report to show stage 2 through 4 boost pressure values.
* Fixed issue where boost pressure wasn't altering values in results in Design Calculation.
* Fixed m3/h units label from causing a line break in Stage Information table.
* Limited Projection By field to 128 characters and changed report to use trailing ellipsis when Projection Name and Projection By are too long.  Note that the Projection Name is limited by the Windows file system.
* Replaced "TriSep" with "MICRODYN-NADIR" in solubility and design warnings.
* Reworded validation error message for stages 1 through 4 Elements / Vessel fields.
* Updated report to use a smaller vertical margin in table cells.  This is to fix the Individual Elements table from causing a page break.
* Limit input to numbers only for all fields except Projection By.
* The report now shows Osmotic Pressure with the correct units and proper unit conversion.
* Added Blended Perm. Flow to report when Blend Flow is greater than zero.
* Adjusted margins and padding to take up less vertical space in the app.



## 1.0.22

* Replaced "pinwheel" busy indicator overlay library with a more versatile one, fixing the issue with the exit application dialog popup getting "covered" by the overlay.



## 1.0.21
* Added iteration timeout value to settings.  Default is 10 seconds.  This is to resolve issue with non-converging systems.

* Fixed bad assignment causing the temperature unit in both passes to not set correctly from raw water.

* Above temperature fix appears to have resolved issue with pH in water quality table.

* Fixed issue with system recovery showing up twice on single pass system.  Two pass systems still shows Pass Recovery and System Recovery on pass one table.

* Fixed issue with app stalling when setting a stage's number of pressure vessels to zero and following stages still had numbers greater than zero.

* Fixed issue with water quality calculations when recirc is greater than zero.

* Application version is now showing the correct value under the help -> about dialog.
  
  
## 1.0.20
* Added more width to unit type drop down on design calculation screen.
* Fixed radio button selection (element size)  wasn't being saved to file correctly.
* Fixed drop down selection (model) not reflecting correct value.  
  * Resolves issue of calculation stalling; max calculation time is currently 10 seconds.
* Report Verbiage, abbreviations, misc
  1. CACO3 changed to CaCO3 in Water Quality table.
  2. Decreased margins to accommodate 8 digit numbers with decimal.
		* This affects all tables.
  3. Increased column width for TDS in Individual Elements table.
  4. Item 2 above should resolve the page break issue with Water Quality table.
  5. Individual Elements table had hard-coded units, fixed.
  6. System Design Feed Pressure now uses stage 1 feed pressure, was using last stage value.
  7. Stage Information Beta changed to two decimal places.
  8. Removed "** Calculations are accurate within +/- 10%" from Water Quality table and "** This projection is not to be used for warranty purposes **" from Stage Information table. "+/- 10%" text added to last page of report.
* Updated Design Calculation result table to erase previous calculation values.
  * Resolves issue when setting number of pressure vessels to 0 for a stage but results persisted.
* Fixed report issue with pH in Water Quality table.
* System Recovery - Modified System Design tables to incorporate Pass Recovery and System Recovery.
* Acid Dosage replaced with Chemical Dosage text.
* Fixed a rounding error issue in CalculateOsmoIon.
* Fixed a calculation error for 2 pass systems; water quality table values were off.