# ROAM Build Instructions

[toc]

## Overview

This guide is a step by step set of instructions on setting up an environment that will compile the source code and performing a build that generates the set up file for ROAM.  It starts with the prerequisite applications needed and how to install them.  Then, it walks through the process of building the source code.  Afterwards, with a successful build, a make is ran that builds the install executable.  Finally, with the code signing hardware, shows how to code sign the installer file.



## Set Up Tools

* Windows OS - Windows 7 SP1 or higher
* Visual Studio 2019 Community Edition
* Node.js 12.13.1 LTS
* Git
* Digicert Code Signing Drivers
* Visual Studio Code (optional)
* Typora (optional)

### Visual Studio 2019 Community Edition

* Download and Install
  * https://visualstudio.microsoft.com/vs/community/
  * Click download link.
  * Run installer, accept warning about preparing/getting ready.
  * When Workloads show up, select ASP.NET and web development; should be first workload.
  * Click install in bottom right corner.
  * Sign in to Visual Studio with a Microsoft account; create one if needed.  This is required to renew the free community license.
  * When solution dialog pops up, select continue without code.
* Load solution source code
  * Unzip source code; for this document I am using c:\source and unzipping to create c:\source\ROAM as the top level folder.
  * In Visual Studio 2019, open solution by going to File -> Open -> Project/Solution.
  * Select solution file; eg. c:\source\ROAM\Roam.sln.
  * Accept security warning.
  * Visual Studio will download packages and install other items; check bottom blue bar for Installing packages complete.
  * To ensure everything is working, right click on ServiceApp project in Solution Explorer then select Rebuild; should eventually see Rebuild All succeeded.

### Node.js 12.13.1 LTS

* Download and Install
  * https://nodejs.org/en/
  * Click Download for Windows (x64) - 12.13.1 LTS.
  * Run installer.
  * Click Next on each screen, accepting defaults.
  * In a command prompt verify install by typing "node --version" and "npm --version", no quotes.  Should get the version numbers.

### Git

* https://git-scm.com/download/win

* Should be asked to save the download file.  If not, select the most recent maintenance build and download.
* Run installer, accept all defaults.

### Digicert Code Signing Drivers

* https://knowledge.digicert.com/content/dam/digicertknowledgebase/attachment/solution/SO20491/SafeNetAuthenticationClient-x32-x64-10.4.exe
* Run driver installer (above), accept all defaults.
* Insert Digicert usb hardware device.
* Run SafeNet Authentication Client Tools
  * Be sure the program selected says Client Tools at the end
* Since the device is initialized and has a password, there shouldn't be anything else to do, just verify it sees the device.

### Visual Studio Code (optional)

* Visual Studio Code does a better job at working with css/html/javascript.  Consider using Visual Studio Code if more than just trivial updates are being made.
* https://code.visualstudio.com/

### Typora (optional)

* Typora is a markdown editor that easily exports to PDF.  The change log and this build document are written in markdown.  If updates to these files are made, it is suggested to used Typora and export to PDF for distributing to users.

* https://www.typora.io/

  

## Build from Source Code

There are two projects that need to be compiled to create the executable.  There is a "backend" process that does the calculations.  It is written in C# (.Net Core) and is the ServiceApp project in the Visual Studio solution.  The "frontend" is an Electron app, written in NodeJS; using css/js/html for UI.

The build steps are to first build the ServiceApp, then publish it using Visual Studio.  Then from a command prompt, build the electron app, under the ClientApp folder.  When configured properly, it will pull in the the compiled/published ServiceApp and make that part of the overall application.

### ServiceApp Set up, Build, and Publish

* Load the Roam.sln solution file in Visual Studio.

* Change code, elements.json, etc. as needed.

* Make sure target is Debug x86:

  ​	![](image-20191215154644199.png)

* Right click ServiceApp project from the  Solution Explorer and select Build to verify source code can build.

* Right click the ServiceApp project again and select properties

* From the property page, select Package on the left.

* Set the Assembly version and Assembly file version.

* Right click the ServiceApp and select Publish to set up the publish profile.
  * Pick a publish target should popup, select Folder in the left menu.
  * On the right side, enter this path: bin\Release\x86\netcoreapp3.0\publish\.  Then click Create Profile.
  * On the Publish screen, click Edit (under FolderProfile) and set these:
    * Configuration: **Release | x86**
    * Target Framework: **netcoreapp3.0**
    * Deployment Mode: **Self-contained**
    * Target Runtime: **win-x86**
    * Target Location: **[folder already selected from above]**

* Click Publish button to start publish.

* Now that the publish settings are configured, future builds just require to build and publish; right clicking on the ServiceApp project to initiate those processes.

### ClientApp Set up and Build

* The configuration should be complete and not need altering.  However, Node modules are frequently updated over time.  Relying on current version of these modules is likely to cause build problems.

* In the root folder, c:\source\Roam\, is a zip files with the node modules used to build the project.  Unzip this file such that you end up with c:\source\Roam\ClientApp\node_modules

* Always run an initial build for ServiceApp in Visual Studio 2019 so that the client app can call it.   

## Run Application Locally

* Open a command prompt and change directories to the ClientApp folder.  For this example, c:\source\Roam\ClientApp.

* Type: npm start

* The client app should build and run.  It will also launch the ServiceApp as an unseen process.

  

## Increment Version Number

* There are two places the version number should be updated once changes have been made.

* In Visual Studio 2019, right click the ServiceApp project and select Properties.  Then click Package on the left, then update both version numbers at the bottom of the property page.

* ClientApp\package.json will have a version property that should be updated as well.

  

## Make Installer

* To create the installer, start by publishing the ServiceApp.  This will compile and place the output in the correct folder that the ClientApp will use to copy into the final installer executable.

* Open a command prompt and change directories to the ClientApp folder.  For this example, c:\source\Roam\ClientApp.

* Type: npm run make

* This can take a couple of minutes to complete

* The final installer executable can be found at ClientApp/out/make/squirrel.windows/ia32

* The file name will include the current version number and end in Setup.exe.

* When the install exe is ran, it installs the full application in %userprofile%/AppData/Local/Microdyn-Nadir

* NOTE: If the application just flashes and closes when trying to run, it is likely the ServiceApp publish folder is not exactly as defined.  Double check that the publish folder is correct.  Also, check in %userprofile%/AppData/Local/Microdyn-Nadir/app-[version]/resources that there is a "services" folder there.  If not, then the publish folder isn't correct.'

## Code Sign Installer

* Insert the Digicert usb hardware device

* Open a command prompt and change directories to the install exe.  This will be  ClientApp/out/squirrel.windows/ia32

* Type (include quotes): 

  "C:\Program Files (x86)\Microsoft SDKs\ClickOnce\SignTool\signtool.exe" sign /t http://timestamp.digicert.com /sha1 76F1B3514B4BFA2EC26D1C10E69CC6C41A7C86AD "Microdyn-Nadir ROAM-2.0.0 Setup.exe"

  * Change the version number in the file name as needed.

* Enter the Token Password when prompted.

* Verify signing with this command:

  "C:\Program Files (x86)\Microsoft SDKs\ClickOnce\SignTool\signtool.exe" verify /pa "Microdyn-Nadir ROAM-2.0.0 Setup.exe"

  

## Update Elements Data File

* Under the ServiceApp source code folder there is a file named elements.json, open it.
* To add an element, copy an existing one, from the quoted name through the end comma.

```
"4040-FR": {
    "Model": "4040-FR",
    "Diameter": 4.0,
    "Length": 40.0,
    "Reject": 99.3,
    "Flow": 1952.0,
    "pcoef": 0.12,
    "pExp": 1.35,
    "area": 75.0,
    "leak": 0.001,
    "Atc1": 9.127736,
    "PSTD": 198.0,
    "TCor": 2700.0
  },
```

* Change the element name in both the first line and the "Model" line, then edit the remaining values as needed.
* Since this is a standard json file
  * Make sure the root braces begin and end the file: { }
  * Make sure each element data group has a comma separating it from the next element.
  * The last element should not end with a comma.
* Save the file.
* Follow the steps to publish the service app and then make the installer, followed by code signing the installer exe.
