const { app, BrowserWindow, ipcMain, dialog } = require("electron");
const electron = require('electron');
const fs = require('fs');
const report = require('./report');
const { ConnectionBuilder } = require("electron-cgi");

// Handle creating/removing shortcuts on Windows when installing/uninstalling.
if (require("electron-squirrel-startup")) {
  // eslint-disable-line global-require
  app.quit();
}

var debug = false;
if (process.argv.includes("--debug"))
  debug = true;

// for testing pdf
//testReport(debug);
//return;


// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow;

function createWindow() {
  var electronScreen = electron.screen;
  var size = electronScreen.getPrimaryDisplay().workAreaSize;
  var iconPath = __dirname + "/assets/icons/png/64x64.png";

  // Create the browser window.
  mainWindow = new electron.BrowserWindow({
    x: (size.width / 2) - 800,
    y: (size.height / 2) - 500,
    width: 1600,
    height: 1000,
    minHeight: 600,
    minWidth: 934,
    webPreferences: {
      nodeIntegration: true
    },
    icon: iconPath,
    plugins: true
  });

  mainWindow.on('app-command', function (e, cmd) {
    console.log(`app-command: ${cmd}`);
    // Navigate the window back when the user hits their mouse back button
    if (cmd == 'browser-backward') {
      console.log('Back!!!');
    }
  });
  // and load the index.html of the app.
  mainWindow.loadURL(`file://${__dirname}/index.html`);

  if (!app.isPackaged || debug) {
    mainWindow.webContents.openDevTools();
  }
  //mainWindow.webContents.openDevTools();
  //mainWindow.setMenu(null);
  //mainWindow.removeMenu();
  //mainWindow.setMenuBarVisibility(false);
  mainWindow.autoHideMenuBar = true;

  // Emitted when the window is requesting to close.
  mainWindow.on("close", (e) => {
    console.log("App message: close");
    //console.log(e);
    e.preventDefault();
    mainWindow.webContents.send("App.WindowClose")
    //.then((response) => {
    //   console.log(`App.WindowClose() Response: ${response}`);

    //   if (response == "Ok")
    //     mainWindow = null;
    // });
  });


  // Emitted when the window is closed.
  mainWindow.on("closed", () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.

    console.log("App message: closed");

    mainWindow = null;
  });
}
// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
electron.app.on("ready", createWindow);

// Quit when all windows are closed.
electron.app.on("window-all-closed", () => {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  console.log("App message: window-all-closed");

  if (process.platform !== "darwin") {
    electron.app.quit();
  }
});

electron.app.on("activate", () => {
  // On OS X it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow();
  }
});


// ************************
// ***** Electron-CGI *****
// ************************

try {
  if (app.isPackaged && !fs.existsSync('./resources/services/ServiceApp.exe')) {
    app.quit();
    return;
  }
} catch (Err) {
  console.error(err);
  app.quit();
  return;
}

function CreateConnection() {
  var newConnection;
  if (app.isPackaged) {
    newConnection = new ConnectionBuilder()
      .connectTo('./resources/services/ServiceApp.exe')
      .build();
  }
  else {
    newConnection = new ConnectionBuilder()
      //.connectTo("dotnet", "run", "--project", "../ServiceApp")
      .connectTo('../ServiceApp/bin/x86/Debug/netcoreapp3.0/ServiceApp.exe')
      .build();
  }
  newConnection.onDisconnect = eCGIconnectionDisconnect;
  console.log(`Connection betwwen node and .net created. Production: ${app.isPackaged}.`);
  console.log(newConnection);
  return newConnection;
}

var eCGIconnection = CreateConnection();

function eCGIconnectionDisconnect() {
  console.log("Connection betwwen node and .net lost.");
  //connection.close();
  eCGIconnection = CreateConnection();
};

// App Messages
ipcMain.on("App.Init", e => {
  InitApp();
});

ipcMain.on("App.Exit", e => {
  ExitApp();
});

ipcMain.on("App.CreateReport", function (event, data) {
  CreateReport(data);
})

// Settings Messages
ipcMain.on("Settings.GetSettings", e => {
  GetSettings();
});

// Projection Messages
ipcMain.on("Projection.LoadProjection", function (event, path) {
  LoadProjection(path);
});

ipcMain.on("Projection.SaveProjection", function (event, data) {
  SaveProjection(data);
});

ipcMain.on("Projection.CalculateRawWater", function (event, data) {
  CalculateRawWater(data);
});

ipcMain.on("Projection.AutoBalanceRawWater", function (event, data) {
  AutoBalanceRawWater(data);
});

ipcMain.on("Projection.InitDesignCalculation", function (event, data) {
  InitDesignCalculation(data);
});

ipcMain.on("Projection.CalcDesignCalculation", function (event, data) {
  CalcDesignCalculation(data);
});

// File Messages
ipcMain.on("File.OpenFileDialog", function (event, path) {
  OpenFileDialog(path);
});

// Report Messages
ipcMain.on("Report.SaveReport", function (event, data) {
  SaveReport(data);
});

ipcMain.on("File.SaveFileDialog", function (event, path, fileType) {
  SaveFileDialog(path, fileType);
});

// Print Messages
ipcMain.on("Print.TestPrint", function (event, arg) {
  console.log("Print.TestPrint()");
  // mainWindow.webContents.print();
  // mainWindow.webContents.printToPDF({}, (error, data) => {
  //   if (error) throw error
  //   fs.writeFile('c:/temp/test2.pdf', data, (error) => {
  //     if (error) throw error
  //     console.log('Write PDF successfully.')
  //   })
  // })

  //shell.openItem('c:/temp/test3.pdf');

  // const win = new PDFWindow({
  //   width: 800,
  //   height: 600
  // })

  // win.loadURL('http://mozilla.github.io/pdf.js/web/compressed.tracemonkey-pldi-09.pdf')
});

// Test Messages
ipcMain.on("Test.Ping", function (event, name) {
  console.log("Test.Ping()");

  eCGIconnection.send("Ping", name, response => {
    console.log(`Test.Ping(): ${response}`);
    mainWindow.webContents.send("Test.PingResponse", response);
  });
});

// App Methods
function InitApp() {
  console.log("Main InitApp()");
  eCGIconnection.send("AppInit", "", response => {
    console.log(`Main AppInit(): ${response}`);
    mainWindow.webContents.send("App.AppInitResponse", response);
  });
}

function ExitApp() {
  console.log("Main ExitApp()");
  app.exit();
}

async function CreateReport(data) {
  console.log("Main CreateReport()");
  //console.log(projection);
  await report.createReport(data.fileName, data.projection).then(function (response) {
    //console.log(response);
    mainWindow.webContents.send("App.CreateReportResponse", response);
  });
}

// Settings Methods
function GetSettings() {
  console.log("Main GetSettings()");
  eCGIconnection.send("GetSettings", "", response => {
    console.log(`Main GetSettings(): ${response}`);
    mainWindow.webContents.send("Settings.GetSettingsResponse", response);
  });
}

function PostSettings(key, value) {
  console.log("Main PostSettings()");
  eCGIconnection.send("PostSettings", `{ "${key}": "${value}" }`, response => {
    console.log(`Main PostSettings(): ${response}`);
  });
}

// File Methods
function OpenFileDialog(path) {
  console.log(`Main OpenFileDialog(): Path='${path}'`);

  var fileName = dialog.showOpenDialogSync(mainWindow, {
    properties: ["openFile"],
    defaultPath: path,
    filters: [
      {
        name: "All Files",
        extensions: ["*"]
      }
    ]
  });

  if (fileName !== undefined) {
    path = fileName[0].substring(0, fileName[0].lastIndexOf("\\"));
    PostSettings("LastSavePath", path);
  }

  console.log(`Main OpenFileDialog(): ${fileName}`);

  mainWindow.webContents.send("File.OpenFileDialogResponse", fileName);
}

function SaveFileDialog(path, fileType) {
  console.log(`Main SaveFileDialog(): Path='${path}', Type='${fileType}'`);

  filterName = "All Files";
  filterExtensions =  ["*"];
  if(fileType == "PDF") {
    filterName = "PDF";
    filterExtensions =  ["pdf"];
  }

  var fileName = dialog.showSaveDialogSync(mainWindow, {
    defaultPath: path,
    filters: [
      {
        name: filterName,
        extensions: filterExtensions
      }
    ]
  });

  if (fileName !== undefined) {
    path = fileName.substring(0, fileName.lastIndexOf("\\"));
    var settingName = "LastSavePath";
    if(fileType == "PDF") {
      settingName = "LastSaveReportPath";
    }
    PostSettings(settingName, path);
  }

  console.log(`Main SaveFileDialog(): ${fileName}`);

  mainWindow.webContents.send("File.SaveFileDialogResponse", fileName);
}

function LoadProjection(path) {
  console.log(`Main LoadProjection(): ${path}`);
  eCGIconnection.send("LoadProjection", `${path}`, response => {
    //console.log(`Main LoadProjection(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.LoadProjectionResponse", JSON.stringify(response));
  });
}

function SaveProjection(data) {
  //console.log(`Main SaveProjection(): ${JSON.stringify(data)}`);
  eCGIconnection.send("SaveProjection", `${JSON.stringify(data)}`, response => {
    //console.log(`Main SaveProjection(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.SaveProjectionResponse", JSON.stringify(response));
  });
}

function CalculateRawWater(data) {
  console.log(`Main CalculateRawWater()`);
  //console.log(JSON.stringify(data)); 
  eCGIconnection.send("CalculateRawWater", JSON.stringify(data), response => {
    //console.log(`Main CalculateRawWater(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.CalculateRawWaterResponse", JSON.stringify(response));
  });
}

function AutoBalanceRawWater(data) {
  console.log(`Main AutoBalanceRawWater()`);
  eCGIconnection.send("AutoBalanceRawWater", `${JSON.stringify(data)}`, response => {
    //console.log(`Main AutoBalanceRawWater(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.AutoBalanceRawWaterResponse", JSON.stringify(response));
  });
}

function InitDesignCalculation(data) {
  console.log(`Main InitDesignCalculation()`);
  eCGIconnection.send("InitDesignCalculation", `${JSON.stringify(data)}`, response => {
    //console.log(`Main InitDesignCalculation(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.InitDesignCalculationResponse", JSON.stringify(response));
  });
}

function CalcDesignCalculation(data) {
  console.log(`Main CalcDesignCalculation()`);
  //console.log(`${JSON.stringify(data)}`);
  eCGIconnection.send("CalcDesignCalculation", `${JSON.stringify(data)}`, response => {
    //console.log(`Main CalcDesignCalculation(): ${JSON.stringify(response)}`);
    mainWindow.webContents.send("Projection.CalcDesignCalculationResponse", JSON.stringify(response));
  });
}

// function CalcDesignCalculation_orig(data) {
//   console.log(`Main CalcDesignCalculation()`);
//   mainWindow.webContents.send("Projection.CalcDesignCalculationResponse", JSON.stringify(designCalculation.Calc(data)));
// }

function SaveReport(data) {
  console.log(`Main SaveReport()`);  
  console.log(data);
  eCGIconnection.send("SaveReport", `${JSON.stringify(data)}`, response => {    
    mainWindow.webContents.send("Report.SaveReportResponse", JSON.stringify(response));
  });
}

function testReport(debug) {
  fileName = 'Test File 3';
  report.createReport(fileName, getTestProjection(), debug);
}

function getTestProjection() {
  var data = {
    "result": 0,
    "data": {
      "aluminum": 0,
      "anMeq": 0,
      "anionCacO3": 0,
      "anionPpm": 0,
      "anionsTotal": 0.6,
      "appVersion": null,
      "bCalc": true,
      "calcDate": "2019-09-27T13:35:45.9456526-06:00",
      "carbonDioxide": 0,
      "catMeq": 0,
      "cationCacO3": 0,
      "cationPpm": 0,
      "cationsTotal": 0.6,
      "conductivity": 0,
      "enablePass2": true,
      "feedWater": {
        "al": 0,
        "fe": 0,
        "kspBaSO4": 0,
        "kspCaF2": 0,
        "kspCaSO4": 0,
        "kspSrSO4": 0,
        "lsi": 0,
        "osmoticPressure": 0.33475766074620905,
        "sdsi": 0,
        "silicaSat": 0
      },
      "ionStrength": 0.0000020215605483600626,
      "ions": [{
        "ionType": 0,
        "name": "Calcium",
        "unitType": "ppm",
        "value": 12,
        "weight": 0.6
      }, {
        "ionType": 0,
        "name": "Magnesium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 0,
        "name": "Sodium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 0,
        "name": "Potassium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 0,
        "name": "Ammonium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 0,
        "name": "Barium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 0,
        "name": "Strontium",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Carbonate",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Bicarbonate",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Sulfate",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Chloride",
        "unitType": "ppm",
        "value": 21.25748,
        "weight": 0.6
      }, {
        "ionType": 1,
        "name": "Fluoride",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Nitrate",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }, {
        "ionType": 1,
        "name": "Silica",
        "unitType": "ppm",
        "value": 0,
        "weight": 0
      }
      ],
      "iron": 0,
      "isModified": false,
      "kspBaSO4": 0,
      "kspCaF2": 0,
      "kspCaSO4": 0,
      "kspSrSO4": 0,
      "lsi": 0,
      "manganese": 0,
      "membrans": {
        "4040-BW": {
          "area": 85,
          "atc1": 9.902317,
          "diameter": 4,
          "flow": 2400,
          "leak": 0.001,
          "length": 40,
          "model": "BW",
          "pExp": 1.35,
          "pcoef": 0.12,
          "pstd": 198,
          "reject": 99.5,
          "tCor": 2700
        },
        "4040-LE": {
          "area": 85,
          "atc1": 13.82198,
          "diameter": 4,
          "flow": 3350,
          "leak": 0.001,
          "length": 40,
          "model": "LE",
          "pExp": 1.35,
          "pcoef": 0.12,
          "pstd": 198,
          "reject": 99.3,
          "tCor": 2700
        },
        "8040-BW-365": {
          "area": 365,
          "atc1": 9.320161,
          "diameter": 7.9,
          "flow": 9700,
          "leak": 0.001,
          "length": 40,
          "model": "BW-3",
          "pExp": 1.56,
          "pcoef": 0.0124,
          "pstd": 198,
          "reject": 99.5,
          "tCor": 2700
        },
        "8040-BW-400": {
          "area": 400,
          "atc1": 9.381414,
          "diameter": 7.9,
          "flow": 10700,
          "leak": 0.001,
          "length": 40,
          "model": "BW-4",
          "pExp": 1.56,
          "pcoef": 0.0124,
          "pstd": 198,
          "reject": 99.5,
          "tCor": 2700
        },
        "8040-BW-440": {
          "area": 440,
          "atc1": 9.32562,
          "diameter": 7.9,
          "flow": 11700,
          "leak": 0.001,
          "length": 40,
          "model": "BW-4",
          "pExp": 1.56,
          "pcoef": 0.0124,
          "pstd": 198,
          "reject": 99.5,
          "tCor": 2700
        },
        "8040-LE-400": {
          "area": 400,
          "atc1": 14.02828,
          "diameter": 7.9,
          "flow": 16000,
          "leak": 0.001,
          "length": 40,
          "model": "LE-4",
          "pExp": 1.56,
          "pcoef": 0.0124,
          "pstd": 198,
          "reject": 99.3,
          "tCor": 2700
        },
        "8040-LE-440": {
          "area": 440,
          "atc1": 13.97966,
          "diameter": 7.9,
          "flow": 17539,
          "leak": 0.001,
          "length": 40,
          "model": "LE-4",
          "pExp": 1.56,
          "pcoef": 0.0124,
          "pstd": 198,
          "reject": 99.3,
          "tCor": 2700
        }
      },
      "osmoticPressure": 0.28691892151380477,
      "pH": 12,
      "pass": [{
        "adjustedpH": null,
        "age": 0,
        "blendFlow": 0,
        "calcData": {
          "acidc": 0,
          "acids": 0,
          "afact": [6.556695521302723, 0, 0, 0, 0, 0, 0],
          "age": 0.0027397260273972603,
          "area": [85, 0, 0, 0, 0, 0, 0],
          "atc": [6.550145375926797, 0, 0, 0, 0, 0, 0],
          "avg_ppress": 0,
          "avsp": 0.0050000000000000044,
          "b_prod": [40, 0, 0, 0, 0, 0, 0],
          "b_salp": [0.9202851592234198, 0, 0, 0, 0, 0, 0],
          "beta": [1.4336884999949573, 0, 0, 0, 0, 0, 0],
          "betaElem": [[0, 1.2950527613490006, 1.4336884999949573, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "betaWarning": 1,
          "bfact": 1,
          "blend": 0,
          "boostPress": [0, 0, 0, 0],
          "caustic": 0,
          "col": [4, 0, 0, 0, 0, 0, 0],
          "con": 1788.003738866988,
          "con_Ret": 1788.003738866988,
          "cph": 12,
          "cph2": 12,
          "deltap": 9.23124927836256,
          "deltapav": 23.676905216492024,
          "dos": 0,
          "dos_daily": 0,
          "dos_monthly": 0,
          "el_bank": [4, 0, 0, 0, 0, 0, 0],
          "el_tot": 4,
          "el_tu": [2, 0, 0, 0],
          "elapsed": 0,
          "fc022": 0,
          "fcl": 0,
          "fco2": 0,
          "fco3": 0,
          "fdecl": 0.025,
          "fee": 1811.8121543637294,
          "feed": 57600,
          "feed_Ret": 1811.8121543637294,
          "feedav": 30,
          "feedflow": 115200,
          "fhco3": 0,
          "flowElem": [[0, 10.054778092955342, 9.987523254454581, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "flow_b": 19.957671096330998,
          "flow_bav": 24.951446501687826,
          "flow_f": 39.91539730518015,
          "flow_feed": [80, 40, 0, 0, 0],
          "flow_ft": 19.957698652590075,
          "flow_pt": 9.987523254454581,
          "fluxElem": [[0, 170.3397700453611, 169.2003939578188, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "fna": 0,
          "fph": 12,
          "fso4": 0,
          "ftemp": 12,
          "ftemp2": 0,
          "ion_Data": [{
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.087,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 40.1
          }, {
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.085,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 24.3
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 0.87,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 23
          }, {
            "a152_ACM1_Type": 1.3,
            "a153_TS80_Type": 1.3,
            "other_Type": 1.07,
            "sB_Type": 1.3,
            "tS_40_Type": 1.3,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 39
          }, {
            "a152_ACM1_Type": 1.5,
            "a153_TS80_Type": 1.5,
            "other_Type": 1.4,
            "sB_Type": 3,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 18
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 137.3
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.08,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 87.6
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 60
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.15,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 61
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.025,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 96
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.17,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 35.45
          }, {
            "a152_ACM1_Type": 0.5,
            "a153_TS80_Type": 0.5,
            "other_Type": 5,
            "sB_Type": 0.5,
            "tS_40_Type": 0.6,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 19
          }, {
            "a152_ACM1_Type": 2,
            "a153_TS80_Type": 2,
            "other_Type": 2.39,
            "sB_Type": 2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 62
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 0.7,
            "other_Type": 1.1,
            "sB_Type": 2,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 60.1
          }
          ],
          "ion_Data_Perm": [{
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.087,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 40.1
          }, {
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.085,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 24.3
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 0.87,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 23
          }, {
            "a152_ACM1_Type": 1.3,
            "a153_TS80_Type": 1.3,
            "other_Type": 1.07,
            "sB_Type": 1.3,
            "tS_40_Type": 1.3,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 39
          }, {
            "a152_ACM1_Type": 1.5,
            "a153_TS80_Type": 1.5,
            "other_Type": 1.4,
            "sB_Type": 3,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 18
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 137.3
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.08,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 87.6
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 60
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.15,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 61
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.025,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 96
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.17,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 35.45
          }, {
            "a152_ACM1_Type": 0.5,
            "a153_TS80_Type": 0.5,
            "other_Type": 5,
            "sB_Type": 0.5,
            "tS_40_Type": 0.6,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 19
          }, {
            "a152_ACM1_Type": 2,
            "a153_TS80_Type": 2,
            "other_Type": 2.39,
            "sB_Type": 2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 62
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 0.7,
            "other_Type": 1.1,
            "sB_Type": 2,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 60.1
          }
          ],
          "ion_ppm": [12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21.25748, 0, 0, 0],
          "ion_ppmb": [27.993291927616692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49.402728340871015, 0, 0, 0],
          "ion_ppmc": [28.054364068518765, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49.69712046846643, 0, 0, 0],
          "ion_ppmf": [14.000867491703207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24.801933804797503, 0, 0, 0],
          "ion_ppmp": [0.00670778492899546, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011859899039046837, 0, 0, 0],
          "leak": [0.001, 0, 0, 0, 0, 0, 0],
          "nbanks": 1,
          "osm_c": 0.6708059515120637,
          "osma": 0,
          "osmb": 0,
          "pExp": [1.35, 0, 0, 0],
          "pProd": 57600,
          "p_prod": 40.08460269481985,
          "p_salp": 0,
          "paNumd": [null, null, "12", "57600", null, null, null, null, null, null, null, null, null, null, null, null, null, "0", "0"],
          "pcoef": [0.12, 0, 0, 0, 0, 0, 0],
          "ph": 12,
          "pneti": 1792.0654268611354,
          "pnetiElem": [[0, 1804.132990339657, 1792.0654268611354, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "pnetiWarning": 0,
          "pnetn": [198, 0, 0, 0, 0, 0, 0],
          "pnetn_av": 198,
          "pph": 12,
          "pph2": 12,
          "ppress": [0, 0, 0, 0],
          "ppress_sum": 0,
          "pprod2": 0,
          "press_feed": [1811.8121543637294, 1788.003738866988, 0, 0, 0, 0],
          "press_h": 1828.985390613304,
          "press_l": 1794.638918114155,
          "pressf": 1785.003738866988,
          "prod": 40,
          "prod_sn": [1589.0282729787575, 0, 0, 0, 0, 0, 0],
          "prod_snt": [6356.11309191503, 0, 0, 0, 0, 0, 0],
          "prod_toti": 6356.11309191503,
          "prod_totp": 1258510.392199176,
          "ptr": "",
          "ptr2": "",
          "rec": 0.5,
          "rec_av": 0.3232588802511231,
          "rec_h": 0.5002896598391046,
          "rec_l": 0.16676321994636817,
          "recint": 0.5,
          "recirc": 0,
          "recircFlow": 0,
          "recircFlowOriginal": 0,
          "rej": [0.005511947333842405, 0, 0, 0, 0, 0, 0],
          "rej_Ions": [0.999565, 0.999575, 0.99565, 0.99465, 0.993, 0.9995, 0.9996, 0.9995, 0.99425, 0.999875, 0.99415, 0.975, 0.98805, 0.9945],
          "retStatus": 0,
          "scp": [0.2683113971598184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.4743959615618735, 0, 0, 0, 0],
          "scpk": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          "sp_fact": 1.3,
          "start": 0,
          "str": "",
          "sumfp": 40.08460269481985,
          "systemFlux": 169.41176470588235,
          "tCor": 1.5117705686950338,
          "t_ion_ppm": [14.000867491703207, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24.801933804797503, 0, 0, 0],
          "tdsElem": [[0, 0.019056659575849615, 0.026886755559120262, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "tdsc": 0,
          "tdsf": 0,
          "totalArea": 340,
          "tube": [2, 0, 0, 0]
        },
        "chemDosage": 0,
        "chemType": "H2SO4",
        "feedCO2": 0,
        "feedTemp": 12,
        "feedTempUnit": "C",
        "fluxDecline": 0.025,
        "productFlow": 40,
        "projectionBy": "",
        "rawWaterpH": 12,
        "recircFlow": 10,
        "recovery": 50,
        "saltPassageIncreaseFactor": 1.3,
        "stageData": [{
          "averageFlux": 169.41176470588235,
          "betaLastElement": 1.4336884999949573,
          "boostPressure": 0,
          "concentratedFlow": 40,
          "concentratedPressure": 1788.003738866988,
          "elementData": [{
            "beta": 1.2950527613490006,
            "elementNumber": 1,
            "flux": 170.3397700453611,
            "ndPressure": 1804.132990339657,
            "permeateFlow": 10.054778092955342,
            "tds": 0.019056659575849615
          }, {
            "beta": 1.4336884999949573,
            "elementNumber": 2,
            "flux": 169.2003939578188,
            "ndPressure": 1792.0654268611354,
            "permeateFlow": 9.987523254454581,
            "tds": 0.026886755559120262
          }
          ],
          "elementSize": 4,
          "elementsVessel": 2,
          "feedFlow": 80,
          "feedPressure": 1811.8121543637294,
          "model": "4040-BW",
          "numberPressureVessels": 2,
          "permeatePressure": 0,
          "productSalinity": 0.023007128980585496,
          "stageNumber": 1
        }
        ],
        "systemFlux": 169.41176470588235,
        "unitType": "imperial",
        "warnings": "\r\n*** WARNING *** Maximum Beta Value of 1.2 exceeded. Reduce recovery or increase element path length!\r\n"
      }, {
        "adjustedpH": null,
        "age": 0,
        "blendFlow": 0,
        "calcData": {
          "acidc": 0,
          "acids": 0,
          "afact": [6.556695521302723, 0, 0, 0, 0, 0, 0],
          "age": 0.0027397260273972603,
          "area": [85, 0, 0, 0, 0, 0, 0],
          "atc": [6.550145375926797, 0, 0, 0, 0, 0, 0],
          "avg_ppress": 0,
          "avsp": 0.0050000000000000044,
          "b_prod": [30, 0, 0, 0, 0, 0, 0],
          "b_salp": [0.00057769751250054, 0, 0, 0, 0, 0, 0],
          "beta": [2.1735003159670785, 0, 0, 0, 0, 0, 0],
          "betaElem": [[0, 1.5177822750633687, 2.1735003159670785, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "betaWarning": 1,
          "bfact": 1,
          "blend": 0,
          "boostPress": [0, 0, 0, 0],
          "caustic": 0,
          "col": [4, 0, 0, 0, 0, 0, 0],
          "con": 1346.9559428995315,
          "con_Ret": 1346.9559428995315,
          "cph": 12,
          "cph2": 12,
          "deltap": 2.2294180832329893,
          "deltapav": 7.261724348308896,
          "dos": 0,
          "dos_daily": 0,
          "dos_monthly": 0,
          "el_bank": [4, 0, 0, 0, 0, 0, 0],
          "el_tot": 4,
          "el_tu": [2, 0, 0, 0],
          "elapsed": 0,
          "fc022": 0,
          "fcl": 0,
          "fco2": 0,
          "fco3": 0,
          "fdecl": 0.025,
          "fee": 1354.359442768225,
          "feed": 14400,
          "feed_Ret": 1354.359442768225,
          "feedav": 12.5,
          "feedflow": 57600,
          "fhco3": 0,
          "flowElem": [[0, 7.533684886623502, 7.513053091000153, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "flow_b": 4.953261917759443,
          "flow_bav": 8.709788515567972,
          "flow_f": 9.906524044752691,
          "flow_feed": [40, 10, 0, 0, 0],
          "flow_ft": 4.953262022376346,
          "flow_pt": 7.513053091000153,
          "fluxElem": [[0, 127.62948513809228, 127.27995824753202, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "fna": 0,
          "fph": 12,
          "fso4": 0,
          "ftemp": 12,
          "ftemp2": 0,
          "ion_Data": [{
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.087,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 40.1
          }, {
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.085,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 24.3
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 0.87,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 23
          }, {
            "a152_ACM1_Type": 1.3,
            "a153_TS80_Type": 1.3,
            "other_Type": 1.07,
            "sB_Type": 1.3,
            "tS_40_Type": 1.3,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 39
          }, {
            "a152_ACM1_Type": 1.5,
            "a153_TS80_Type": 1.5,
            "other_Type": 1.4,
            "sB_Type": 3,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 18
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 137.3
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.08,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 87.6
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 60
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.15,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 61
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.025,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 96
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.17,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 35.45
          }, {
            "a152_ACM1_Type": 0.5,
            "a153_TS80_Type": 0.5,
            "other_Type": 5,
            "sB_Type": 0.5,
            "tS_40_Type": 0.6,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 19
          }, {
            "a152_ACM1_Type": 2,
            "a153_TS80_Type": 2,
            "other_Type": 2.39,
            "sB_Type": 2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 62
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 0.7,
            "other_Type": 1.1,
            "sB_Type": 2,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 60.1
          }
          ],
          "ion_Data_Perm": [{
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.087,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 40.1
          }, {
            "a152_ACM1_Type": 0.2,
            "a153_TS80_Type": 0.2,
            "other_Type": 0.085,
            "sB_Type": 0.2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 24.3
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 0.87,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 23
          }, {
            "a152_ACM1_Type": 1.3,
            "a153_TS80_Type": 1.3,
            "other_Type": 1.07,
            "sB_Type": 1.3,
            "tS_40_Type": 1.3,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 39
          }, {
            "a152_ACM1_Type": 1.5,
            "a153_TS80_Type": 1.5,
            "other_Type": 1.4,
            "sB_Type": 3,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": 1,
            "weight": 18
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 137.3
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.08,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": 2,
            "weight": 87.6
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.1,
            "sB_Type": 0.1,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 60
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.15,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 61
          }, {
            "a152_ACM1_Type": 0.1,
            "a153_TS80_Type": 0.1,
            "other_Type": 0.025,
            "sB_Type": 0.1,
            "tS_40_Type": 0.02,
            "uF_MF_Type": 0,
            "valency": -2,
            "weight": 96
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 1,
            "other_Type": 1.17,
            "sB_Type": 1,
            "tS_40_Type": 1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 35.45
          }, {
            "a152_ACM1_Type": 0.5,
            "a153_TS80_Type": 0.5,
            "other_Type": 5,
            "sB_Type": 0.5,
            "tS_40_Type": 0.6,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 19
          }, {
            "a152_ACM1_Type": 2,
            "a153_TS80_Type": 2,
            "other_Type": 2.39,
            "sB_Type": 2,
            "tS_40_Type": 0.1,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 62
          }, {
            "a152_ACM1_Type": 1,
            "a153_TS80_Type": 0.7,
            "other_Type": 1.1,
            "sB_Type": 2,
            "tS_40_Type": 1.5,
            "uF_MF_Type": 0,
            "valency": -1,
            "weight": 60.1
          }
          ],
          "ion_ppm": [0.006696446539317127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011839851861286393, 0, 0, 0],
          "ion_ppmb": [0.026769633309094536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.04697533108014554, 0, 0, 0],
          "ion_ppmc": [0.027021528017562225, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.04777621786646289, 0, 0, 0],
          "ion_ppmf": [0.006696446539317127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011839851861286393, 0, 0, 0],
          "ion_ppmp": [0.0000010195871971303423, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.000024172622395365083, 0, 0, 0],
          "leak": [0.001, 0, 0, 0, 0, 0, 0],
          "nbanks": 1,
          "osm_c": 0.0006451656523246347,
          "osma": 0,
          "osmb": 0,
          "pExp": [1.35, 0, 0, 0],
          "pProd": 43200,
          "p_prod": 30.09347595524731,
          "p_salp": 0,
          "paNumd": [null, null, "12", "43200", null, null, null, null, null, null, null, null, null, null, null, null, null, "0", "0"],
          "pcoef": [0.12, 0, 0, 0, 0, 0, 0],
          "ph": 12,
          "pneti": 1348.0702223695425,
          "pnetiElem": [[0, 1351.7721939883995, 1348.0702223695425, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "pnetiWarning": 0,
          "pnetn": [198, 0, 0, 0, 0, 0, 0],
          "pnetn_av": 198,
          "pph": 12,
          "pph2": 12,
          "ppress": [0, 0, 0, 0],
          "ppress_sum": 0,
          "pprod2": 0,
          "press_feed": [1354.359442768225, 1346.9559428995315, 0, 0, 0, 0],
          "press_h": 1362.9906247686802,
          "press_l": 1345.7282607677703,
          "pressf": 1343.9559428995315,
          "prod": 30,
          "prod_sn": [1589.0282729787575, 0, 0, 0, 0, 0, 0],
          "prod_snt": [6356.11309191503, 0, 0, 0, 0, 0, 0],
          "prod_toti": 6356.11309191503,
          "prod_totp": 1258510.392199176,
          "ptr": "",
          "ptr2": "",
          "rec": 0.75,
          "rec_av": 0.5744204186875319,
          "rec_h": 0.9040024685729179,
          "rec_l": 0.30133415619097265,
          "recint": 0.75,
          "recirc": 0,
          "recircFlow": 0,
          "recircFlowOriginal": 0,
          "rej": [0.005511947333842405, 0, 0, 0, 0, 0, 0],
          "rej_Ions": [0.999565, 0.999575, 0.99565, 0.99465, 0.993, 0.9995, 0.9996, 0.9995, 0.99425, 0.999875, 0.99415, 0.975, 0.98805, 0.9945],
          "retStatus": 0,
          "scp": [0.00016844454074638903, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.00029782338999797956, 0, 0, 0, 0],
          "scpk": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
          "sp_fact": 1.3,
          "start": 0,
          "str": "",
          "sumfp": 30.09347595524731,
          "systemFlux": 127.05882352941177,
          "tCor": 1.5117705686950338,
          "t_ion_ppm": [0.006696446539317127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.011839851861286393, 0, 0, 0],
          "tdsElem": [[0, 0.000013217747968070148, 0.00002519220959249542, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0], [0, 0, 0, 0, 0, 0, 0, 0]],
          "tdsc": 0,
          "tdsf": 0,
          "totalArea": 340,
          "tube": [2, 0, 0, 0]
        },
        "chemDosage": 0,
        "chemType": "H2SO4",
        "feedCO2": 0,
        "feedTemp": 12,
        "feedTempUnit": "C",
        "fluxDecline": 0.025,
        "productFlow": 30,
        "projectionBy": null,
        "rawWaterpH": 12,
        "recircFlow": 0,
        "recovery": 75,
        "saltPassageIncreaseFactor": 1.3,
        "stageData": [{
          "averageFlux": 127.05882352941177,
          "betaLastElement": 2.1735003159670785,
          "boostPressure": 0,
          "concentratedFlow": 10,
          "concentratedPressure": 1346.9559428995315,
          "elementData": [{
            "beta": 1.5177822750633687,
            "elementNumber": 1,
            "flux": 127.62948513809228,
            "ndPressure": 1351.7721939883995,
            "permeateFlow": 7.533684886623502,
            "tds": 0.000013217747968070148
          }, {
            "beta": 2.1735003159670785,
            "elementNumber": 2,
            "flux": 127.27995824753202,
            "ndPressure": 1348.0702223695425,
            "permeateFlow": 7.513053091000153,
            "tds": 0.00002519220959249542
          }
          ],
          "elementSize": 4,
          "elementsVessel": 2,
          "feedFlow": 40,
          "feedPressure": 1354.359442768225,
          "model": "4040-BW",
          "numberPressureVessels": 2,
          "permeatePressure": 0,
          "productSalinity": 0.000019256583750018,
          "stageNumber": 1
        }
        ],
        "systemFlux": 127.05882352941177,
        "unitType": null,
        "warnings": "\r\n*** WARNING *** Maximum Beta Value of 1.2 exceeded. Reduce recovery or increase element path length!\r\n"
      }
      ],
      "pass1Conc": {
        "al": 0,
        "fe": 0,
        "kspBaSO4": 0,
        "kspCaF2": 0,
        "kspCaSO4": 0,
        "kspSrSO4": 0,
        "lsi": 0,
        "osmoticPressure": 0.6707477489611237,
        "sdsi": 0,
        "silicaSat": 0
      },
      "pass2Conc": {
        "al": 0,
        "fe": 0,
        "kspBaSO4": 0,
        "kspCaF2": 0,
        "kspCaSO4": 0,
        "kspSrSO4": 0,
        "lsi": 0,
        "osmoticPressure": 0.0006452821270365321,
        "sdsi": 0,
        "silicaSat": 0
      },
      "rawWater": {
        "al": 0,
        "fe": 0,
        "kspBaSO4": 0,
        "kspCaF2": 0,
        "kspCaSO4": 0,
        "kspSrSO4": 0,
        "lsi": 0,
        "osmoticPressure": 0.28691892151380477,
        "sdsi": 0,
        "silicaSat": 0
      },
      "saltDensityIndex": 0,
      "sdsi": 0,
      "silicaSat": 0,
      "tds": 33.25748,
      "temperature": 12,
      "temperatureUnit": "C",
      "turbidity": 0,
      "vCacO3": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      "vMilli": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      "vppm": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      "waterIsBalanced": false
    }

  }

    ;

  //console.log(projection);
  return data.data;
}