$(document).ready(function () {
    console.log("Index.html ready");
    AppService.init();
    $('select[required]').change(function () { $('select').valid(); }) // Hack for Materialize and jQuery validation

    //AppService.FileName = "Untitled Project";
    RoutingService.setPageView('intro');

    $("input[type='text']").on("change", function () { ProjectionModified(this); });
    $("input[type='radio']").on("change", function () { ProjectionModified(this); });
    $("select").on("change", function () { ProjectionModified(this); });

    $('.numbersOnly').keyup(function () {
        console.log('numbersOnly');
        if (this.value != this.value.replace(/[^0-9\.-]/g, '')) {
            this.value = this.value.replace(/[^0-9\.-]/g, '');
        }
    });

   
});

function ProjectionModified(elem) {
    // console.log("ProjectionModified");
    // console.log(elem);
    if (!AppService.IgnoreModified && AppService.IsModified == false) {
        AppService.IsModified = true;
        AppService.FileName = `${AppService.FileName}`;
    }
}

function Pass2Enabler() {
    console.log(`Pass2Enabler(): ${$("#enablePass2").data("checkbox").elem.checked}`);
    if ($("#enablePass2").data("checkbox").elem.checked) {
        $("#pass-tabs li:last").show();
        if(AppService.Pass2Validation)
            $("#pass2 *").removeClass("validationOff");
        $("#twoPassToggleButton").html("Disable 2 Pass System");
    }
    else {
        var tabs = $("#pass-tabs").data("tabs");
        tabs.open(1);
        $("#pass-tabs li:last").hide();
        $("#pass2 *").addClass("validationOff");
        $("#twoPassToggleButton").html("Create 2 Pass System");
    }
}

$.validator.setDefaults({
    ignore: ".validationOff,:disabled",
    onclick: false,
    onkeyup: false,
    onfocusout: function (element) {
        $(element).valid();
    },
    validClass: "valid",
    errorClass: "invalid",
    errorPlacement: function (error, element) {
        if ($(".message-dialog").length > 0)
            return;
        var errorPrimaryMessage = `Enter Correct ${element[0].name}`;
        var errorSecondaryMessage = $(element).next(".error-message").html();
        if ($(element).is("select"))
            errorSecondaryMessage = $(element).parent().next(".error-message").html();
        console.log("errorPlacement");
        console.log(element);
        OpenMessageDialog(errorPrimaryMessage, errorSecondaryMessage, "Ok", null);
        return true;
    }
});

$.validator.addMethod("selectRequired", function (value, element, arg) {
    console.log(`selectRequired()`);

    if ($(element).closest('form').attr('id') != "design-calculation-form")
        return true;
    console.log(`selectRequired: ${element.id}`);
    console.log(value);
    var isValid = (value != "default");

    // Materialize restructures select, so this applies the invalid state properly
    if (isValid)
        $(element).parent().removeClass('select-invalid');
    else
        $(element).parent().addClass('select-invalid');
    return this.optional(element) || isValid;
}, "");

$.validator.addMethod("checkTemperature", function (value, element) {
    console.log(`Temp req: ${value}`);
    if (value == "" || isNaN(parseFloat(value)))
        return this.optional(element) || false;

    var temperatureUnit = $("input:radio[name=tempUnit]");
    if (temperatureUnit.filter(":checked").val() == "C")
        return this.optional(element) || (value >= 2 && value <= 45);
    else
        return this.optional(element) || (value >= 35 && value <= 113);
}, '');

$.validator.addMethod("pass2ProductFlow", function (value, element) {
    if (value == "" || isNaN(parseFloat(value) || value <= 0.0))
        return false;

    return this.optional(element) || (value <= ($("#pass1-productFlow").val() * 0.95));
}, '');

$.validator.addMethod("stageRequired", function (value, element) {
    console.log("StageRequired");
    var elemVessels = $(element).prevAll("input[id$='numberPressureVessels']").first();

    if (elemVessels.length == 0)
        elemVessels = $(element).parent().prevAll("input[id$='numberPressureVessels']").first();

    var numVessels = elemVessels.val();
    console.log(numVessels);
    if ((numVessels == "") || (isNaN(parseFloat(numVessels)) || (parseFloat(numVessels) < 1.0)))
        return true;
    console.log($(element).attr('id').endsWith('-elementsVessel'));
    console.log(value);
    if ($(element).attr('id').endsWith('-elementsVessel'))
        return (parseFloat(value) > 0.0);
    if ($(element).attr('id').endsWith('-model'))
        return (value != "default");

    //return false;
}, '');

function OpenMessageDialog(primaryMessage, secondaryMessage, actions, callback) {
    if (callback == undefined)
        callback = Metro.noop;
    console.log(`"OpenMessageDialog: ${primaryMessage}`);
    actionButtons = [{ caption: "Ok", cls: "js-dialog-close", onclick: function () { callback("Ok"); } }];

    if (actions == "OkCancel")
        actionButtons = [
            { caption: "Ok", cls: "js-dialog-close", onclick: function () { callback("Ok"); } },
            { caption: "Cancel", cls: "js-dialog-close", onclick: function () { callback("Cancel"); } }
        ];
    else if (actions == "BalanceEdit")
        actionButtons = [
            { caption: "Balance", cls: "js-dialog-close", onclick: function () { callback("Balance"); } },
            { caption: "Edit", cls: "js-dialog-close", onclick: function () { callback("Edit"); } }
        ];

    else if (actions == "SaveBeforeDesignCalc")
        actionButtons = [
            { caption: "Save", cls: "js-dialog-close", onclick: function () { callback("Save"); } },
            { caption: "Cancel", cls: "js-dialog-close", onclick: function () { callback("Cancel"); } }
        ];

    return Metro.dialog.create({
        title: " ",
        content: `
        <div class="dialog-container">
            <div class="message-icon">
                <span class="mif-warning mif-5x"></span>
            </div>
            <div class="message-content">
                <div class="dialog-primary-message">${primaryMessage}</div>
                <div class="dialog-secondary-message">${secondaryMessage}</div>
            </div>
        </div>`,
        closeButton: true,
        clsDialog: "message-dialog",
        actions: actionButtons,
        onClose: onMessageDialogClose
    });
}

function onMessageDialogClose() {
    console.log("onMessageDialogClose");
    // console.log(AppService.Activity);
    // if(AppService.Activity != null)
    // AppService.openActivityOverlay();  // Handles case where modal close remvoes overlay but there is still the calculation overlay running

    //AppService.closeActivityOverlay();
}

function OpenAboutDialog(appVersion) {
    return Metro.dialog.create({
        title: "About ROAM",
        content: `        
            <h6 style="font-size:0.97rem;margin-top:0px;margin-bottom:20px;">Reverse Osmosis Application for MICRODYN-NADIR (ROAM)</h6>
            <h6 style="font-size:0.97rem;padding: 0px 0px 25px 24px;margin:0px -24px 25px -24px;border-bottom: 1px solid #e9e9e9;">Version: ${appVersion}</h6>            
            <p style="padding: 0px 24px 25px 24px;margin:0px -24px 25px -24px;border-bottom: 1px solid #e9e9e9;">Reverse Osmosis Application for MICRODYN-NADIR (ROAM) is a design software used to estimate system designs for MICRODYN RO and NF products.</p>
            <img src="assets/images/logo.svg" height=50 style="margin: 0px 0px 15px 0px;" />
            <address>
            <strong>Europe</strong><br>
            Germany: +49 611 962 6001<br>
            Italy: +39 0721 1796201 <br>
            info@microdyn-nadir.com<br>
            </address>
            <address>
            <strong>Americas</strong><br>
            USA: +1 805 964 8003<br>
            Brazil: +55 11 3378 7500<br>
            info@microdyn-nadir.com<br>
            </address>
            <address style="margin-bottom:0px;">
            <strong>Asia</strong><br>
            China: +86 592 677 5500<br>
            Singapore: +65 6457 7533<br>
            infochina@microdyn-nadir.cn
            </address>
       `,
        closeButton: true,
        clsDialog: "message-dialog",
        //        actions: actionButtons
    });
}

function nthIndex(str, pat, n) {
    var L = str.length, i = -1;
    while (n-- && i++ < L) {
        i = str.indexOf(pat, i);
        if (i < 0) break;
    }
    return i;
}

function UpdateFilterModels(radioElem) {
    //var diameter = $(radioElem).filter(":checked").data("caption");
    console.log("UpdateFilterModels()");
    console.log(radioElem);

    var metroSelect = $(radioElem).parent().next(".col8");
    if (metroSelect.length == 0)
        metroSelect = $(radioElem).parent().next().next(".col8");
    console.log(metroSelect);

    var selectUL = $(metroSelect).find('ul.d-menu');
    selectUL.empty();

    var selectElement = $(metroSelect).find("select");
    selectElement.empty();

    var size = 8;
    if ($(radioElem).filter(":checked").data("caption") == "4 inches") {
        size = 4;
    }    

    var origIgnore = $("form").validate().settings.ignore;
    $("form").validate().settings.ignore = "*";  // Hack to turn off validation   
    SettingsService.setElements(size, selectUL, selectElement);
    // models.forEach(function (value, index, array) {
    //     if (index == 0) {
    //         $(selectElement).append(`<option value="${value}">Select...</option>`);
    //         $(selectUL).append(`<li data-text="Select..." data-value="${value}" class="active"><a>Select...</a></li>`);
    //         selectElement.data('select').val('default');
    //     }
    //     else {
    //         $(selectElement).append(`<option value="${value}">${value}</option>`);
    //         $(selectUL).append(`<li data-text="${value}" data-value="${value}"><a>${value}</a></li>`);
    //     }
    // });
    $("form").validate().settings.ignore = origIgnore; // turn it back on
}

