class SettingsService {
    static init() {
        console.log("SettingsService init()");
        this.getSettings().then((response) => {
            this.Settings = JSON.parse(response);
            //AppService.AppVersion = this.Settings.AppVersion;
            console.log(`SettingsService init()`);
            console.log(this.Settings);

        });
    }

    static get AppVersion() { console.log(`AppVersion: ${this.Settings.AppVersion}`); return SettingsService.formatAppVersion(this.Settings.AppVersion); }
    static get LastSavePath() { return this.Settings.LastSavePath; }
    static set LastSavePath(path) { this.Settings.LastSavePath = path; }
    static get LastReportSavePath() { return this.Settings.LastSaveReportPath; }
    static set LastReportSavePath(path) { this.Settings.LastSaveReportPath = path; }

    static async getSettings() {
        return await new Promise((resolve, reject) => {
            ipcRenderer.once("Settings.GetSettingsResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("Settings.GetSettings");
        });
    }

    static setElements(elementSize, selectUL, selectElement) {
        console.log(`setElements(): size = ${elementSize}`);
        var sizedElements = [];
        var elements = this.Settings.Elements;
        Object.keys(elements).forEach(function (key) {
            var element = elements[key];
            if (elementSize == 4 && element.Diameter == 4) {
                sizedElements.push(element);  // 4 inch are set to 4
            }
            else if (elementSize != 4 && element.Diameter != 4) {
                sizedElements.push(element);  // 8 inch may be 7.9, catching those here
            }
        });

        $(selectElement).append(`<option value="default">Select...</option>`);
        $(selectUL).append(`<li data-text="Select..." data-value="default" class="active"><a>Select...</a></li>`);
        selectElement.data('select').val('default');
        sizedElements.forEach(function (value, index, array) {
            $(selectElement).append(`<option value="${value.Model}">${value.Model}</option>`);
            $(selectUL).append(`<li data-text="${value.Model}" data-value="${value.Model}"><a>${value.Model}</a></li>`);
        });
    }

    static formatAppVersion(val) {
        console.log(val);
        if (val == undefined || val == "" || (val.match(/./g) || []).length <= 2)
            return;
    
        var idx = nthIndex(val, ".", 3);
        return val.substring(0, idx);
    }
}

SettingsService.init();