class RoutingService {
    static init() {
        $.ajax({ url: 'views/intro.html', async: false, success: (data) => { $("#pageViewIntro").html(data); } });
        $.ajax({ url: 'views/projection.html', async: false, success: (data) => { $("#pageViewProjection").html(data); } });
        console.log("RoutingService init()");
    }

    static setPageView(name) {
        console.log(`setPageView(): ${name}`);
        switch (name) {
            case "intro":
                $("#pageViewProjection").addClass("d-none");
                $("#pageViewIntro").removeClass("d-none");
                break;
            default:
                $("#pageViewIntro").addClass("d-none");
                $("#pageViewProjection").removeClass("d-none");
                $("body").removeClass("intro-body");
                var tabs = $("#menu-tabs").data("tabs");
                tabs.open(1);
                break;
        }
    };

    static currentTab() {
        var tabs = $("#menu-tabs").data("tabs");
        return $(tabs.elem).find("li.active").index();
    }

    static gotoTab(tabNum) {
        var tabs = $("#menu-tabs").data("tabs");
        tabs.open(tabNum);
    }

    static previousTab() {
        var tabs = $("#menu-tabs").data("tabs");
        var tabNum = $(tabs.elem).find("li.active").index();
        tabs.open(tabNum);
    }

    static nextTab() {
        var tabs = $("#menu-tabs").data("tabs");
        var tabNum = $(tabs.elem).find("li.active").index();
        tabs.open(tabNum + 2);
    }
}

RoutingService.init();