class ProjectionService {
    static init() {
        this.zero = "0.00";
        this.elems = {};
        this.elems.pass = [{}, {}];
        this.elems.pass[0] = {};
        this.elems.pass[1] = {};
        this.elems.pass[0].stageData = [{}, {}, {}, {}];
        this.elems.pass[1].stageData = [{}, {}, {}, {}];

        ProjectionService.SetElements();
    }

    static NewProjection() {
        AppService.init();
        AppService.IgnoreModified = true;

        var origIgnore = $("form").validate().settings.ignore;
        $("form").validate().settings.ignore = "*";  // Hack to turn off validation   

        this.elems.temperatureUnit.val(["C"]);
        this.elems.temperature.val(this.zero);
        this.elems.pH.val(this.zero);
        this.elems.manganese.val(this.zero);
        this.elems.iron.val(this.zero);
        this.elems.saltDensityIndex.val(this.zero);
        this.elems.turbidity.val(this.zero);
        this.elems.conductivity.val(this.zero);
        this.elems.aluminum.val(this.zero);
        this.elems.carbonDioxide.val(this.zero);

        this.elems.calcium.val(this.zero);
        this.elems.magnesium.val(this.zero);
        this.elems.sodium.val(this.zero);
        this.elems.potassium.val(this.zero);
        this.elems.ammonium.val(this.zero);
        this.elems.barium.val(this.zero);
        this.elems.strontium.val(this.zero);

        this.elems.carbonate.val(this.zero);
        this.elems.bicarbonate.val(this.zero);
        this.elems.sulfate.val(this.zero);
        this.elems.chloride.val(this.zero);
        this.elems.fluoride.val(this.zero);
        this.elems.nitrate.val(this.zero);
        this.elems.silica.val(this.zero);

        this.elems.calciumUnit.val("ppm");
        this.elems.magnesiumUnit.val("ppm");
        this.elems.sodiumUnit.val("ppm");
        this.elems.potassiumUnit.val("ppm");
        this.elems.ammoniumUnit.val("ppm");
        this.elems.bariumUnit.val("ppm");
        this.elems.strontiumUnit.val("ppm");

        this.elems.carbonateUnit.val("ppm");
        this.elems.bicarbonateUnit.val("ppm");
        this.elems.sulfateUnit.val("ppm");
        this.elems.chlorideUnit.val("ppm");
        this.elems.fluorideUnit.val("ppm");
        this.elems.nitrateUnit.val("ppm");
        this.elems.silicaUnit.val("ppm");

        this.elems.calciumEquiv.val(this.zero);
        this.elems.magnesiumEquiv.val(this.zero);
        this.elems.sodiumEquiv.val(this.zero);
        this.elems.potassiumEquiv.val(this.zero);
        this.elems.ammoniumEquiv.val(this.zero);
        this.elems.bariumEquiv.val(this.zero);
        this.elems.strontiumEquiv.val(this.zero);

        this.elems.carbonateEquiv.val(this.zero);
        this.elems.bicarbonateEquiv.val(this.zero);
        this.elems.sulfateEquiv.val(this.zero);
        this.elems.chlorideEquiv.val(this.zero);
        this.elems.fluorideEquiv.val(this.zero);
        this.elems.nitrateEquiv.val(this.zero);
        this.elems.silicaEquiv.val(this.zero);

        this.elems.cationsTotal.val(this.zero);
        this.elems.anionsTotal.val(this.zero);

        this.elems.kspCaSO4.val(this.zero);
        this.elems.kspSrSO4.val(this.zero);
        this.elems.kspBaSO4.val(this.zero);
        this.elems.kspCaF2.val(this.zero);
        this.elems.lsi.val(this.zero);
        this.elems.sdsi.val(this.zero);
        this.elems.tds.val(this.zero);
        this.elems.osmoticPressure.val(this.zero);

        // Design Calculation
        this.elems.pass[0].unitType.val();
        this.elems.pass[0].projectionBy.val("");
        this.elems.pass[0].recovery.val(this.zero);
        this.elems.pass[0].feedTemp.val(this.zero);
        //this.elems.pass[0].feedTempUnit.val(this.zero);
        this.elems.pass[0].rawWaterpH.val(this.zero);
        this.elems.pass[0].adjustedpH.val(this.zero);
        this.elems.pass[0].productFlow.val(this.zero);
        this.elems.pass[0].chemType.val("H2SO4");
        this.elems.pass[0].age.val("0");
        this.elems.pass[0].fluxDecline.val("0.025");
        this.elems.pass[0].saltPassageIncreaseFactor.val("1.30");
        this.elems.pass[0].recircFlow.val(this.zero);
        this.elems.pass[0].blendFlow.val(this.zero);
        this.elems.pass[0].systemFlux.val(this.zero);
        this.elems.pass[0].feedCO2.val(this.zero);
        this.elems.pass[0].chemDosage.val(this.zero);
        if (this.elems.enablePass2.checked)
            $("#twoPassToggleButton").click();

        this.elems.pass[1].recovery.val(this.zero);
        this.elems.pass[1].feedTemp.val(this.zero);
        //this.elems.pass[1].feedTempUnit.val(this.zero);
        this.elems.pass[1].rawWaterpH.val(this.zero);
        this.elems.pass[1].adjustedpH.val(this.zero);
        this.elems.pass[1].productFlow.val(this.zero);
        this.elems.pass[1].chemType.val("H2SO4");
        this.elems.pass[1].age.val("0");
        this.elems.pass[1].fluxDecline.val(this.zero);
        this.elems.pass[1].saltPassageIncreaseFactor.val(this.zero);
        this.elems.pass[1].recircFlow.val(this.zero);
        this.elems.pass[1].blendFlow.val(this.zero);
        this.elems.pass[1].systemFlux.val(this.zero);
        this.elems.pass[1].feedCO2.val(this.zero);
        this.elems.pass[1].chemDosage.val(this.zero);

        var j = 0;
        var i = 0;
        for (j = 0; j < 2; j++) {
            for (i = 0; i < 4; i++) {
                this.elems.pass[j].stageData[i].NumberPressureVessels.val('');
                this.elems.pass[j].stageData[i].BoostPressure.val('');
                this.elems.pass[j].stageData[i].PermeatePressure.val('');
                this.elems.pass[j].stageData[i].ElementsVessel.val('');
                $(`#pass${j + 1}-stage${i + 1}-elementSize4`).prop("checked", true).trigger("click");
                UpdateFilterModels(this.elems.pass[j].stageData[i].ElementSize); // Set filter model drop down
                this.elems.pass[j].stageData[i].Model.val('default');

                this.elems.pass[j].stageData[i].AverageFlux.text('');
                this.elems.pass[j].stageData[i].ConcentratedFlow.text('');
                this.elems.pass[j].stageData[i].FeedPressure.text('');
                this.elems.pass[j].stageData[i].BetaLastElement.text('');
                this.elems.pass[j].stageData[i].ProductSalinity.text('');
                this.elems.pass[j].stageData[i].ConcentratedPressure.text('');
                this.elems.pass[j].stageData[i].FeedFlow.text('');
            }
        }

        $("form").validate().settings.ignore = origIgnore; // turn it back on

        AppService.IgnoreModified = false;
    }

    static GetProjectionData() {
        var data = {};
        data.Ions = [{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}];
        // data.Ions.Calcium = {};
        // data.Ions.Magnesium = {};
        // data.Ions.Sodium = {};
        // data.Ions.Potassium = {};
        // data.Ions.Ammonium = {};
        // data.Ions.Barium = {};
        // data.Ions.Strontium = {};
        // data.Ions.Carbonate = {};
        // data.Ions.Bicarbonate = {};
        // data.Ions.Sulfate = {};
        // data.Ions.Chloride = {};
        // data.Ions.Fluoride = {};
        // data.Ions.Nitrate = {};
        // data.Ions.Silica = {};

        data.pass = [{}, {}];
        data.pass[0].stageData = [];
        data.pass[1].stageData = [];

        data.temperature = isNaN(parseFloat(this.elems.temperature.val())) ? 0.00 : this.elems.temperature.val();
        data.temperatureUnit = this.elems.temperatureUnit.filter(":checked").val();
        data.pH = this.elems.pH.val();
        data.manganese = this.elems.manganese.val();
        data.iron = this.elems.iron.val();
        data.saltDensityIndex = this.elems.saltDensityIndex.val();
        data.turbidity = this.elems.turbidity.val();
        data.conductivity = this.elems.conductivity.val();
        data.aluminum = this.elems.aluminum.val();
        data.carbonDioxide = this.elems.carbonDioxide.val();

        data.Ions[0].Name = "Calcium";
        data.Ions[1].Name = "Magnesium";
        data.Ions[2].Name = "Sodium";
        data.Ions[3].Name = "Potassium";
        data.Ions[4].Name = "Ammonium";
        data.Ions[5].Name = "Barium";
        data.Ions[6].Name = "Strontium";

        data.Ions[7].Name = "Carbonate";
        data.Ions[8].Name = "Bicarbonate";
        data.Ions[9].Name = "Sulfate";
        data.Ions[10].Name = "Chloride";
        data.Ions[11].Name = "Fluoride";
        data.Ions[12].Name = "Nitrate";
        data.Ions[13].Name = "Silica";

        data.Ions[0].Value = this.elems.calcium.val();
        data.Ions[1].Value = this.elems.magnesium.val();
        data.Ions[2].Value = this.elems.sodium.val();
        data.Ions[3].Value = this.elems.potassium.val();
        data.Ions[4].Value = this.elems.ammonium.val();
        data.Ions[5].Value = this.elems.barium.val();
        data.Ions[6].Value = this.elems.strontium.val();

        data.Ions[7].Value = this.elems.carbonate.val();
        data.Ions[8].Value = this.elems.bicarbonate.val();
        data.Ions[9].Value = this.elems.sulfate.val();
        data.Ions[10].Value = this.elems.chloride.val();
        data.Ions[11].Value = this.elems.fluoride.val();
        data.Ions[12].Value = this.elems.nitrate.val();
        data.Ions[13].Value = this.elems.silica.val();

        data.Ions[0].UnitType = this.elems.calciumUnit.val();
        data.Ions[1].UnitType = this.elems.magnesiumUnit.val();
        data.Ions[2].UnitType = this.elems.sodiumUnit.val();
        data.Ions[3].UnitType = this.elems.potassiumUnit.val();
        data.Ions[4].UnitType = this.elems.ammoniumUnit.val();
        data.Ions[5].UnitType = this.elems.bariumUnit.val();
        data.Ions[6].UnitType = this.elems.strontiumUnit.val();

        data.Ions[7].UnitType = this.elems.carbonateUnit.val();
        data.Ions[8].UnitType = this.elems.bicarbonateUnit.val();
        data.Ions[9].UnitType = this.elems.sulfateUnit.val();
        data.Ions[10].UnitType = this.elems.chlorideUnit.val();
        data.Ions[11].UnitType = this.elems.fluorideUnit.val();
        data.Ions[12].UnitType = this.elems.nitrateUnit.val();
        data.Ions[13].UnitType = this.elems.silicaUnit.val();

        data.Ions[0].Weight = this.elems.calciumEquiv.val();
        data.Ions[1].Weight = this.elems.magnesiumEquiv.val();
        data.Ions[2].Weight = this.elems.sodiumEquiv.val();
        data.Ions[3].Weight = this.elems.potassiumEquiv.val();
        data.Ions[4].Weight = this.elems.ammoniumEquiv.val();
        data.Ions[5].Weight = this.elems.bariumEquiv.val();
        data.Ions[6].Weight = this.elems.strontiumEquiv.val();

        data.Ions[7].Weight = this.elems.carbonateEquiv.val();
        data.Ions[8].Weight = this.elems.bicarbonateEquiv.val();
        data.Ions[9].Weight = this.elems.sulfateEquiv.val();
        data.Ions[10].Weight = this.elems.chlorideEquiv.val();
        data.Ions[11].Weight = this.elems.fluorideEquiv.val();
        data.Ions[12].Weight = this.elems.nitrateEquiv.val();
        data.Ions[12].Weight = this.elems.silicaEquiv.val();

        data.cationsTotal = this.elems.cationsTotal.val();
        data.anionsTotal = this.elems.anionsTotal.val();

        data.kspCaSO4 = this.elems.kspCaSO4.val();
        data.kspSrSO4 = this.elems.kspSrSO4.val();
        data.kspBaSO4 = this.elems.kspBaSO4.val();
        data.kspCaF2 = this.elems.kspCaF2.val();
        data.lsi = this.elems.lsi.val();
        data.sdsi = this.elems.sdsi.val();
        data.tds = this.elems.tds.val();
        data.osmoticPressure = this.elems.osmoticPressure.val();

        // Design Calculation
        data.calcDate = this.elems.calcDate.val();
        data.enablePass2 = this.elems.enablePass2.checked;

        data.pass[0].unitType = this.elems.pass[0].unitType.val();
        data.pass[0].projectionBy = this.elems.pass[0].projectionBy.val();
        data.pass[0].recovery = this.elems.pass[0].recovery.val();
        data.pass[0].feedTemp = this.elems.pass[0].feedTemp.val();
        data.pass[0].feedTempUnit = this.elems.pass[0].feedTempUnit.filter(":checked").val();
        data.pass[0].rawWaterpH = this.elems.pass[0].rawWaterpH.val();
        data.pass[0].adjustedpH = this.elems.pass[0].adjustedpH.val();
        data.pass[0].productFlow = this.elems.pass[0].productFlow.val();
        data.pass[0].chemType = this.elems.pass[0].chemType.val();
        data.pass[0].age = this.elems.pass[0].age.val();
        data.pass[0].fluxDecline = this.elems.pass[0].fluxDecline.val();
        data.pass[0].saltPassageIncreaseFactor = this.elems.pass[0].saltPassageIncreaseFactor.val();
        data.pass[0].recircFlow = this.elems.pass[0].recircFlow.val();
        data.pass[0].blendFlow = this.elems.pass[0].blendFlow.val();
        data.pass[0].systemFlux = this.elems.pass[0].systemFlux.val();
        data.pass[0].feedCO2 = this.elems.pass[0].feedCO2.val();
        data.pass[0].chemDosage = this.elems.pass[0].chemDosage.val();

        var i = 0;
        var j = 0;
        for (j = 0; j < 2; j++) {
            for (i = 0; i < 4; i++) {
                if (this.elems.pass[j].stageData[i].NumberPressureVessels.val() != '' && this.elems.pass[j].stageData[i].NumberPressureVessels.val() > 0) {
                    data.pass[j].stageData.push({});
                    data.pass[j].stageData[i].StageNumber = i + 1;
                    data.pass[j].stageData[i].NumberPressureVessels = this.elems.pass[j].stageData[i].NumberPressureVessels.val();
                    data.pass[j].stageData[i].BoostPressure = this.elems.pass[j].stageData[i].BoostPressure.val();
                    data.pass[j].stageData[i].PermeatePressure = this.elems.pass[j].stageData[i].PermeatePressure.val();
                    data.pass[j].stageData[i].ElementsVessel = this.elems.pass[j].stageData[i].ElementsVessel.val();
                    data.pass[j].stageData[i].ElementSize = this.elems.pass[j].stageData[i].ElementSize.filter(":checked").val();
                    data.pass[j].stageData[i].Model = this.elems.pass[j].stageData[i].Model.val();

                    console.log(`Model: ${this.elems.pass[j].stageData[i].Model.val()}`);
                }
                else {
                    break;
                }
            }
        }

        data.pass[1].recovery = this.elems.pass[1].recovery.val();
        data.pass[1].feedTemp = this.elems.pass[1].feedTemp.val();
        data.pass[1].feedTempUnit = this.elems.pass[1].feedTempUnit.filter(":checked").val();
        data.pass[1].rawWaterpH = this.elems.pass[1].rawWaterpH.val();
        data.pass[1].adjustedpH = this.elems.pass[1].adjustedpH.val();
        data.pass[1].productFlow = this.elems.pass[1].productFlow.val();
        data.pass[1].chemType = this.elems.pass[1].chemType.val();
        data.pass[1].age = this.elems.pass[1].age.val();
        data.pass[1].fluxDecline = this.elems.pass[1].fluxDecline.val();
        data.pass[1].saltPassageIncreaseFactor = this.elems.pass[1].saltPassageIncreaseFactor.val();
        data.pass[1].recircFlow = this.elems.pass[1].recircFlow.val();
        data.pass[1].blendFlow = this.elems.pass[1].blendFlow.val();
        data.pass[1].systemFlux = this.elems.pass[1].systemFlux.val();
        data.pass[1].feedCO2 = this.elems.pass[1].feedCO2.val();
        data.pass[1].chemDosage = this.elems.pass[1].chemDosage.val();

        ProjectionService.SetZeros();

        return data;
    }

    static SetProjectionData(projection) {
        console.log(`SetProjectionData()`);
        console.log(projection);
        AppService.IgnoreModified = true;
        //AppService.AppVersion = projection.appVersion;

        var origIgnore = $("form").validate().settings.ignore;
        console.log(origIgnore);
        $("form").validate().settings.ignore = "*";  // Hack to turn off validation   

        // Raw Water
        this.elems.temperature.val(projection.data.temperature);
        this.elems.temperatureUnit.val([`${projection.data.temperatureUnit}`]);
        console.log("Raw Temp Unit");
        console.log([`${projection.data.temperatureUnit}`]);
        console.log(this.elems.temperatureUnit.filter(":checked").val());
        this.elems.pH.val(projection.data.pH);
        this.elems.manganese.val(projection.data.manganese);
        this.elems.iron.val(projection.data.iron);
        this.elems.saltDensityIndex.val(projection.data.saltDensityIndex);
        this.elems.turbidity.val(projection.data.turbidity);
        this.elems.conductivity.val(projection.data.conductivity);
        this.elems.aluminum.val(projection.data.aluminum);
        this.elems.carbonDioxide.val(projection.data.carbonDioxide);

        this.elems.calcium.val(projection.data.ions[0].value);
        this.elems.magnesium.val(projection.data.ions[1].value);
        this.elems.sodium.val(projection.data.ions[2].value);
        this.elems.potassium.val(projection.data.ions[3].value);
        this.elems.ammonium.val(projection.data.ions[4].value);
        this.elems.barium.val(projection.data.ions[5].value);
        this.elems.strontium.val(projection.data.ions[6].value);

        this.elems.carbonate.val(projection.data.ions[7].value);
        this.elems.bicarbonate.val(projection.data.ions[8].value);
        this.elems.sulfate.val(projection.data.ions[9].value);
        this.elems.chloride.val(projection.data.ions[10].value);
        this.elems.fluoride.val(projection.data.ions[11].value);
        this.elems.nitrate.val(projection.data.ions[12].value);
        this.elems.silica.val(projection.data.ions[13].value);

        this.elems.calciumUnit.val(projection.data.ions[0].unitType);
        this.elems.magnesiumUnit.val(projection.data.ions[1].unitType);
        this.elems.sodiumUnit.val(projection.data.ions[2].unitType);
        this.elems.potassiumUnit.val(projection.data.ions[3].unitType);
        this.elems.ammoniumUnit.val(projection.data.ions[4].unitType);
        this.elems.bariumUnit.val(projection.data.ions[5].unitType);
        this.elems.strontiumUnit.val(projection.data.ions[6].unitType);

        this.elems.carbonateUnit.val(projection.data.ions[7].unitType);
        this.elems.bicarbonateUnit.val(projection.data.ions[8].unitType);
        this.elems.sulfateUnit.val(projection.data.ions[9].unitType);
        this.elems.chlorideUnit.val(projection.data.ions[10].unitType);
        this.elems.fluorideUnit.val(projection.data.ions[11].unitType);
        this.elems.nitrateUnit.val(projection.data.ions[12].unitType);
        this.elems.silicaUnit.val(projection.data.ions[13].unitType);

        this.elems.calciumEquiv.val(projection.data.ions[0].weight.toFixed(2));
        this.elems.magnesiumEquiv.val(projection.data.ions[1].weight.toFixed(2));
        this.elems.sodiumEquiv.val(projection.data.ions[2].weight.toFixed(2));
        this.elems.potassiumEquiv.val(projection.data.ions[3].weight.toFixed(2));
        this.elems.ammoniumEquiv.val(projection.data.ions[4].weight.toFixed(2));
        this.elems.bariumEquiv.val(projection.data.ions[5].weight.toFixed(2));
        this.elems.strontiumEquiv.val(projection.data.ions[6].weight.toFixed(2));

        this.elems.carbonateEquiv.val(projection.data.ions[7].weight.toFixed(2));
        this.elems.bicarbonateEquiv.val(projection.data.ions[8].weight.toFixed(2));
        this.elems.sulfateEquiv.val(projection.data.ions[9].weight.toFixed(2));
        this.elems.chlorideEquiv.val(projection.data.ions[10].weight.toFixed(2));
        this.elems.fluorideEquiv.val(projection.data.ions[11].weight.toFixed(2));
        this.elems.nitrateEquiv.val(projection.data.ions[12].weight.toFixed(2));
        this.elems.silicaEquiv.val(projection.data.ions[13].weight.toFixed(2));

        this.elems.cationsTotal.val(projection.data.cationsTotal.toFixed(2));
        this.elems.anionsTotal.val(projection.data.anionsTotal.toFixed(2));

        this.elems.kspCaSO4.val(projection.data.kspCaSO4.toFixed(2));
        this.elems.kspSrSO4.val(projection.data.kspSrSO4.toFixed(2));
        this.elems.kspBaSO4.val(projection.data.kspBaSO4.toFixed(2));
        this.elems.kspCaF2.val(projection.data.kspCaF2.toFixed(2));
        this.elems.lsi.val(projection.data.lsi.toFixed(2));
        this.elems.sdsi.val(projection.data.sdsi.toFixed(2));
        this.elems.tds.val(projection.data.tds.toFixed(2));
        this.elems.osmoticPressure.val(projection.data.osmoticPressure.toFixed(2));

        // Design Calculation
        this.elems.calcDate.val(projection.data.calcDate);
        this.elems.enablePass2.checked = projection.data.enablePass2;

        this.elems.pass[0].unitType.val(projection.data.pass[0].unitType);
        this.elems.pass[0].projectionBy.val(projection.data.pass[0].projectionBy);
        this.elems.pass[0].recovery.val(projection.data.pass[0].recovery);
        this.elems.pass[0].feedTemp.val(projection.data.pass[0].feedTemp);
        this.elems.pass[0].feedTempUnit.val([projection.data.pass[0].feedTempUnit]);
        console.log("Feed Temp Unit");
        console.log([`${projection.data.pass[0].feedTempUnit}`]);
        console.log(this.elems.pass[0].feedTempUnit);
        this.elems.pass[0].rawWaterpH.val(projection.data.pass[0].rawWaterpH);
        this.elems.pass[0].adjustedpH.val(projection.data.pass[0].adjustedpH);
        this.elems.pass[0].productFlow.val(projection.data.pass[0].productFlow);
        this.elems.pass[0].chemType.val(projection.data.pass[0].chemType);
        this.elems.pass[0].age.val(projection.data.pass[0].age);
        this.elems.pass[0].fluxDecline.val(projection.data.pass[0].fluxDecline);
        this.elems.pass[0].saltPassageIncreaseFactor.val(projection.data.pass[0].saltPassageIncreaseFactor);
        this.elems.pass[0].recircFlow.val(projection.data.pass[0].recircFlow);
        this.elems.pass[0].blendFlow.val(projection.data.pass[0].blendFlow);
        this.elems.pass[0].systemFlux.val(projection.data.pass[0].systemFlux.toFixed(1));
        this.elems.pass[0].feedCO2.val(projection.data.pass[0].feedCO2.toFixed(2));
        this.elems.pass[0].chemDosage.val(projection.data.pass[0].chemDosage.toFixed(2));

        this.elems.pass[1].recovery.val(projection.data.pass[1].recovery);
        this.elems.pass[1].feedTemp.val(projection.data.pass[1].feedTemp);
        this.elems.pass[1].feedTempUnit.val([`${projection.data.pass[1].feedTempUnit}`]);
        this.elems.pass[1].rawWaterpH.val(projection.data.pass[1].rawWaterpH);
        this.elems.pass[1].adjustedpH.val(projection.data.pass[1].adjustedpH);
        this.elems.pass[1].productFlow.val(projection.data.pass[1].productFlow);
        this.elems.pass[1].chemType.val(projection.data.pass[1].chemType);
        this.elems.pass[1].age.val(projection.data.pass[1].age);
        this.elems.pass[1].fluxDecline.val(projection.data.pass[1].fluxDecline);
        this.elems.pass[1].saltPassageIncreaseFactor.val(projection.data.pass[1].saltPassageIncreaseFactor);
        this.elems.pass[1].recircFlow.val(projection.data.pass[1].recircFlow);
        this.elems.pass[1].blendFlow.val(projection.data.pass[1].blendFlow);
        this.elems.pass[1].systemFlux.val(projection.data.pass[1].systemFlux);
        this.elems.pass[1].feedCO2.val(projection.data.pass[1].feedCO2);
        this.elems.pass[1].chemDosage.val(projection.data.pass[1].chemDosage);

        var i = 0;
        var j = 0;
        for (j = 0; j < 2; j++) {
            for (i = 0; i < 4; i++) {
                if ((projection.data.pass[j].stageData[i] != null)) {
                    this.elems.pass[j].stageData[i].NumberPressureVessels.val(projection.data.pass[j].stageData[i].numberPressureVessels);
                    this.elems.pass[j].stageData[i].BoostPressure.val(projection.data.pass[j].stageData[i].boostPressure);
                    this.elems.pass[j].stageData[i].PermeatePressure.val(projection.data.pass[j].stageData[i].permeatePressure);
                    this.elems.pass[j].stageData[i].ElementsVessel.val(projection.data.pass[j].stageData[i].elementsVessel);
                    this.elems.pass[j].stageData[i].ElementSize.val([`${projection.data.pass[j].stageData[i].elementSize}`]);
                    UpdateFilterModels(this.elems.pass[j].stageData[i].ElementSize); // Set filter model drop down
                    this.elems.pass[j].stageData[i].Model.val(projection.data.pass[j].stageData[i].model);

                    this.elems.pass[j].stageData[i].AverageFlux.html(projection.data.pass[j].stageData[i].averageFlux.toFixed(1));
                    this.elems.pass[j].stageData[i].FeedPressure.html(projection.data.pass[j].stageData[i].feedPressure.toFixed(1));
                    this.elems.pass[j].stageData[i].ConcentratedPressure.html(projection.data.pass[j].stageData[i].concentratedPressure.toFixed(1));
                    this.elems.pass[j].stageData[i].FeedFlow.html(projection.data.pass[j].stageData[i].feedFlow.toFixed(1));
                    this.elems.pass[j].stageData[i].ConcentratedFlow.html(projection.data.pass[j].stageData[i].concentratedFlow.toFixed(1));
                    this.elems.pass[j].stageData[i].BetaLastElement.html(projection.data.pass[j].stageData[i].betaLastElement.toFixed(2));
                    this.elems.pass[j].stageData[i].ProductSalinity.html(projection.data.pass[j].stageData[i].productSalinity.toFixed(1));
                }
                else {
                    this.elems.pass[j].stageData[i].AverageFlux.html("");
                    this.elems.pass[j].stageData[i].FeedPressure.html("");
                    this.elems.pass[j].stageData[i].ConcentratedPressure.html("");
                    this.elems.pass[j].stageData[i].FeedFlow.html("");
                    this.elems.pass[j].stageData[i].ConcentratedFlow.html("");
                    this.elems.pass[j].stageData[i].BetaLastElement.html("");
                    this.elems.pass[j].stageData[i].ProductSalinity.html("");
                }
            }
        }

        ProjectionService.SetZeros();

        $("form").validate().settings.ignore = origIgnore; // turn it back on
        AppService.IgnoreModified = false;
    }

    static SetZeros() {
        console.log("SetZeros()");
        $(`input[type="text"]`).each(function () {
            var id = $(this).attr('id');
            var value = $(this).val();

            if (id == "pass1-projectionBy" ||
                id == "pass1-adjustedpH" ||
                id == "pass2-adjustedpH") {
                if ($(this).val() == 0)
                    $(this).val("");
            }
            else if ((id == "pass1-age" ||
                id == "pass1-stage1-numberPressureVessels" ||
                id == "pass1-stage1-elementsVessel" ||
                id == "pass1-stage2-numberPressureVessels" ||
                id == "pass1-stage2-elementsVessel" ||
                id == "pass1-stage3-numberPressureVessels" ||
                id == "pass1-stage3-elementsVessel" ||
                id == "pass1-stage4-numberPressureVessels" ||
                id == "pass1-stage4-elementsVessel" ||
                id == "pass2-age" ||
                id == "pass2-stage1-numberPressureVessels" ||
                id == "pass2-stage1-elementsVessel" ||
                id == "pass2-stage2-numberPressureVessels" ||
                id == "pass2-stage2-elementsVessel" ||
                id == "pass2-stage3-numberPressureVessels" ||
                id == "pass2-stage3-elementsVessel" ||
                id == "pass2-stage4-numberPressureVessels" ||
                id == "pass2-stage4-elementsVessel") && (value == "" || value == 0)) {
                $(this).val("0");
            }
            else if (value == "" || parseFloat(value) == 0 || isNaN(value)) {
                $(this).val(ProjectionService.zero);
            }
        });

        $("#results-card label").each(function () {
            if ($(this).text() == "0.0" || $(this).text() == "0.00")
                $(this).text("");
        });
    }

    static SetElements() {
        console.log("ProjectionService.SetElements()");

        // Raw Water
        this.elems.temperatureUnit = $("input:radio[name=tempUnit]");
        this.elems.temperature = $("#temperature");
        this.elems.pH = $("#pH");
        this.elems.manganese = $("#manganese");
        this.elems.iron = $("#iron");
        this.elems.saltDensityIndex = $("#saltDensityIndex");
        this.elems.turbidity = $("#turbidity");
        this.elems.conductivity = $("#conductivity");
        this.elems.aluminum = $("#aluminum");
        this.elems.carbonDioxide = $("#carbonDioxide");

        this.elems.calcium = $("#calcium");
        this.elems.magnesium = $("#magnesium");
        this.elems.sodium = $("#sodium");
        this.elems.potassium = $("#potassium");
        this.elems.ammonium = $("#ammonium");
        this.elems.barium = $("#barium");
        this.elems.strontium = $("#strontium");

        this.elems.carbonate = $("#carbonate");
        this.elems.bicarbonate = $("#bicarbonate");
        this.elems.sulfate = $("#sulfate");
        this.elems.chloride = $("#chloride");
        this.elems.fluoride = $("#fluoride");
        this.elems.nitrate = $("#nitrate");
        this.elems.silica = $("#silica");

        this.elems.calciumUnit = $("#calciumUnit").data("select");
        this.elems.magnesiumUnit = $("#magnesiumUnit").data("select");
        this.elems.sodiumUnit = $("#sodiumUnit").data("select");
        this.elems.potassiumUnit = $("#potassiumUnit").data("select");
        this.elems.ammoniumUnit = $("#ammoniumUnit").data("select");
        this.elems.bariumUnit = $("#bariumUnit").data("select");
        this.elems.strontiumUnit = $("#strontiumUnit").data("select");

        this.elems.carbonateUnit = $("#carbonateUnit").data("select");
        this.elems.bicarbonateUnit = $("#bicarbonateUnit").data("select");
        this.elems.sulfateUnit = $("#sulfateUnit").data("select");
        this.elems.chlorideUnit = $("#chlorideUnit").data("select");
        this.elems.fluorideUnit = $("#fluorideUnit").data("select");
        this.elems.nitrateUnit = $("#nitrateUnit").data("select");
        this.elems.silicaUnit = $("#silicaUnit").data("select");

        this.elems.calciumEquiv = $("#calciumEquiv");
        this.elems.magnesiumEquiv = $("#magnesiumEquiv");
        this.elems.sodiumEquiv = $("#sodiumEquiv");
        this.elems.potassiumEquiv = $("#potassiumEquiv");
        this.elems.ammoniumEquiv = $("#ammoniumEquiv");
        this.elems.bariumEquiv = $("#bariumEquiv");
        this.elems.strontiumEquiv = $("#strontiumEquiv");

        this.elems.carbonateEquiv = $("#carbonateEquiv");
        this.elems.bicarbonateEquiv = $("#bicarbonateEquiv");
        this.elems.sulfateEquiv = $("#sulfateEquiv");
        this.elems.chlorideEquiv = $("#chlorideEquiv");
        this.elems.fluorideEquiv = $("#fluorideEquiv");
        this.elems.nitrateEquiv = $("#nitrateEquiv");
        this.elems.silicaEquiv = $("#silicaEquiv");

        this.elems.cationsTotal = $("#cationsTotal");
        this.elems.anionsTotal = $("#anionsTotal");

        this.elems.kspCaSO4 = $("#kspCaSO4");
        this.elems.kspSrSO4 = $("#kspSrSO4");
        this.elems.kspBaSO4 = $("#kspBaSO4");
        this.elems.kspCaF2 = $("#kspCaF2");
        this.elems.lsi = $("#lsi");
        this.elems.sdsi = $("#sdsi");
        this.elems.tds = $("#tds");
        this.elems.osmoticPressure = $("#osmoticPressure");

        // Desgin Calculation
        this.elems.calcDate = $("#CalcDate");
        this.elems.enablePass2 = $("#enablePass2").data("checkbox").elem;

        this.elems.pass[0].unitType = $("#pass1-unitType").data("select");
        this.elems.pass[0].projectionBy = $("#pass1-projectionBy");
        this.elems.pass[0].recovery = $("#pass1-recovery");
        this.elems.pass[0].feedTemp = $("#pass1-feedTemp");
        this.elems.pass[0].feedTempUnit = $("input:radio[name=pass1-feedTempUnit]");
        this.elems.pass[0].rawWaterpH = $("#pass1-rawWaterpH");
        this.elems.pass[0].adjustedpH = $("#pass1-adjustedpH");
        this.elems.pass[0].productFlow = $("#pass1-productFlow");
        this.elems.pass[0].chemType = $("#pass1-chemType").data("select");
        this.elems.pass[0].age = $("#pass1-age");
        this.elems.pass[0].fluxDecline = $("#pass1-fluxDecline");
        this.elems.pass[0].saltPassageIncreaseFactor = $("#pass1-saltPassageIncreaseFactor");
        this.elems.pass[0].recircFlow = $("#pass1-recircFlow");
        this.elems.pass[0].blendFlow = $("#pass1-blendFlow");
        this.elems.pass[0].systemFlux = $("#pass1-systemFlux");
        this.elems.pass[0].feedCO2 = $("#pass1-feedCO2");
        this.elems.pass[0].chemDosage = $("#pass1-chemDosage");

        this.elems.pass[1].recovery = $("#pass2-recovery");
        this.elems.pass[1].feedTemp = $("#pass2-feedTemp");
        this.elems.pass[1].feedTempUnit = $("input:radio[name=pass2-feedTempUnit]");
        this.elems.pass[1].rawWaterpH = $("#pass2-rawWaterpH");
        this.elems.pass[1].adjustedpH = $("#pass2-adjustedpH");
        this.elems.pass[1].productFlow = $("#pass2-productFlow");
        this.elems.pass[1].chemType = $("#pass2-chemType").data("select");
        this.elems.pass[1].age = $("#pass2-age");
        this.elems.pass[1].fluxDecline = $("#pass2-fluxDecline");
        this.elems.pass[1].saltPassageIncreaseFactor = $("#pass2-saltPassageIncreaseFactor");
        this.elems.pass[1].recircFlow = $("#pass2-recircFlow");
        this.elems.pass[1].blendFlow = $("#pass2-blendFlow");
        this.elems.pass[1].systemFlux = $("#pass2-systemFlux");
        this.elems.pass[1].feedCO2 = $("#pass2-feedCO2");
        this.elems.pass[1].chemDosage = $("#pass2-chemDosage");

        var i = 0;
        var j = 0;
        for (j = 0; j < 2; j++) {
            for (i = 0; i < 4; i++) {
                this.elems.pass[j].stageData[i].NumberPressureVessels = $(`#pass${j + 1}-stage${i + 1}-numberPressureVessels`);
                this.elems.pass[j].stageData[i].BoostPressure = $(`#pass${j + 1}-stage${i + 1}-boostPressure`);
                this.elems.pass[j].stageData[i].PermeatePressure = $(`#pass${j + 1}-stage${i + 1}-permeatePressure`);
                this.elems.pass[j].stageData[i].ElementsVessel = $(`#pass${j + 1}-stage${i + 1}-elementsVessel`);
                this.elems.pass[j].stageData[i].ElementSize = $(`input:radio[name=pass${j + 1}-stage${i + 1}-elementSize]`);
                this.elems.pass[j].stageData[i].Model = $(`#pass${j + 1}-stage${i + 1}-model`).data("select");

                this.elems.pass[j].stageData[i].AverageFlux = $(`#pass${j + 1}-stage${i + 1}-averageFlux`);
                this.elems.pass[j].stageData[i].ConcentratedFlow = $(`#pass${j + 1}-stage${i + 1}-concentratedFlow`);
                this.elems.pass[j].stageData[i].FeedPressure = $(`#pass${j + 1}-stage${i + 1}-feedPressure`);
                this.elems.pass[j].stageData[i].BetaLastElement = $(`#pass${j + 1}-stage${i + 1}-betaLastElement`);
                this.elems.pass[j].stageData[i].ProductSalinity = $(`#pass${j + 1}-stage${i + 1}-productSalinity`);
                this.elems.pass[j].stageData[i].ConcentratedPressure = $(`#pass${j + 1}-stage${i + 1}-concentratedPressure`);
                this.elems.pass[j].stageData[i].FeedFlow = $(`#pass${j + 1}-stage${i + 1}-feedFlow`);
            }
        }
    }
}

$(document).ready(function () {
    ProjectionService.init();
});
