const { ipcRenderer } = require('electron');

class AppService {
    //static get AppVersion() { return this.appVersion; }
    //static set AppVersion(val) { this.appVersion = formatAppVersion(val); }
    static get FileName() { return $("#filename").text(); }
    static set FileName(filename) { $("#filename").text(/([^\\]+)$/.exec(filename)[1]); }
    static get IsModified() { return this.isModified; }
    static set IsModified(val) { console.log('IsModified'); this.isModified = val; this.showModified(val); }
    static get IgnoreModified() { return this.ignoreModified; }
    static set IgnoreModified(val) { this.ignoreModified = val; }
    static get IsFileKnown() { return this.isFileKnown; }
    static set IsFileKnown(val) { this.isFileKnown = val; }
    // static get Activity() { return this.activity; }
    // static set Activity(val) { this.activity = val; }
    static get IsActivityOn() { return this.isActivityOn; }
    static set IsActivityOn(val) { this.isActivityOn = val; }
    static get PdfDataUri() { return this.pdfDataUri; }
    static set PdfDataUri(val) { this.pdfDataUri = val; }
    static get Pass2Validation() { return this.pass2Validation; }
    static set Pass2Validation(val) { this.pass2Validation = val; }

    static init() {
        console.log("App.init()");        
        this.appVersion = "";
        this.isModified = false;        // Tracks if projection has changes
        this.ignoreModified = false;    // Bypasses the showModified indicator, useful when user loads a new projection
        this.isFileKnown = false;       // Tracks if projection has a known file name
        this.fullFileName = "";         // Holds complete file path with file name
        this.calculatedProjection;
        this.reportProjection = null;   // If any calc errors occur, set this to null to prevent running a report on bad data.
        this.activity = null;           // Holds overlay (Metro Activity) object for calculations
        this.isActivityOn = false;
        this.pdfDataUri = "";           // Holds report pdf as blob, used for saving to file
        this.pass2Validation = false;   // True if pass 2 viewed or calculate clicked, prevents pass 2 validation when on pass 1 initially

        // Handles case where OS level close window is intiated (user click exit, kills process, etc.)
        ipcRenderer.on("App.WindowClose", function (event, args) {
            AppService.verifyExitApp();
        });
    }

    // ***** Test *****
    static async ping(name) {
        return await new Promise((resolve, reject) => {
            ipcRenderer.once("Test.PingResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("Test.Ping", name);
        });
    }

    static async initApp() {
        console.log("initApp()")
        // return await new Promise((resolve, reject) => {
        //     ipcRenderer.once("App.AppInitResponse", (event, arg) => {
        //         resolve(arg);
        //     });
        //     ipcRenderer.send("App.Init", name);
        // });
        ipcRenderer.sendSync("App.Init", name);
    }

    static verifyExitApp() {
        console.log(`verifyExitApp`);
        if (this.isModified)
            OpenMessageDialog("Project has been modified", "Are you sure you want to exit the application?", "OkCancel",
                AppService.verifyExitAppResponse)
        else
            AppService.exitApp();
    }

    static verifyExitAppResponse(canClose) {
        console.log(`verifyExitAppResponse: ${canClose}`);
        if (canClose == "Ok")
            AppService.exitApp();
        else if (AppService.IsActivityOn) {
            //AppService.closeActivityOverlay();
            console.log("Exit Cancelled, opening overlay...");
            AppService.openActivityOverlay();
        }
    }

    // Only call this after verifying unsaved changes
    static async exitApp() {
        ipcRenderer.send("App.Exit", name);
    }

    static async calculateRawWater() {
        console.log(`AppService.calculateRawWater()`);
        AppService.openActivityOverlay();
        var result = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.CalculateRawWaterResponse", (event, arg) => {
                resolve(arg);
                AppService.closeActivityOverlay();
            });
            ipcRenderer.send("Projection.CalculateRawWater", ProjectionService.GetProjectionData());
        });
        console.log("AppService.calculateRawWater()");
        //console.log(result);
        return result;
    }

    static async autoBalanceRawWater() {
        console.log(`AppService.autoBalanceRawWater()`);
        var result = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.AutoBalanceRawWaterResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("Projection.AutoBalanceRawWater", ProjectionService.GetProjectionData());
        });
        return result;
    }

    static async initDesignCalculation() {
        console.log(`AppService.initDesignCalculation()`);
        var projection = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.InitDesignCalculationResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("Projection.InitDesignCalculation", ProjectionService.GetProjectionData());
        });
        ProjectionService.SetProjectionData(JSON.parse(projection));
        console.log("Init Design Result...");
        console.log(projection);
        return projection;
    }

    static async calcDesignCalculation() {
        console.log(`AppService.calcDesignCalculation()`);

        //$("#ButtonCalculate").addClass('disabled');  // Disable Calculate button while processing
        AppService.openActivityOverlay();

        var projection = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.CalcDesignCalculationResponse", (event, arg) => {
                resolve(arg);
                this.reportProjection = arg;


                // $("#ButtonCalculate").removeClass('disabled');  // Done processing, enable calculate
                AppService.closeActivityOverlay();
            });
            ipcRenderer.send("Projection.CalcDesignCalculation", ProjectionService.GetProjectionData());
        });

        projection = JSON.parse(projection);
        if (projection.result == 0) {  // Success
            ProjectionService.SetProjectionData(projection);
        }
        else {
            console.log(projection);
            OpenMessageDialog("An error occured during the calculation.", projection.data, "Ok");
            this.reportProjection = null;
        }

        return projection;
    }

    // static createReport() {

    // }

    static async newProjection() {
        console.log(`AppService.newProjection()`);
        RoutingService.setPageView('projection');
        ProjectionService.NewProjection();

        AppService.FileName = "Untitled Project";
        AppService.IsModified = false;
        AppService.IsFileKnown = false;
    }

    static async loadProjection() {
        console.log(`AppService.loadProjection(): path='${SettingsService.LastSavePath}'`);

        // Open file dialog and get file path
        var filePath = await new Promise((resolve, reject) => {
            ipcRenderer.once("File.OpenFileDialogResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("File.OpenFileDialog", SettingsService.LastSavePath);
        });

        if (filePath === undefined || filePath === null)
            return null;

        RoutingService.setPageView("projection");
        SettingsService.LastSavePath = filePath[0].substring(0, filePath[0].lastIndexOf("\\"));

        // Get file data
        var projection = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.LoadProjectionResponse", (event, arg) => {
                resolve(arg);
            });
            ipcRenderer.send("Projection.LoadProjection", filePath);
        });

        //console.log(`Projection: ${projection}`);

        var origIgnore = $("form").validate().settings.ignore;
        $("form").validate().settings.ignore = "*";  // Hack to turn off validation when we load a file
        ProjectionService.NewProjection();  // Reset values to initial state
        ProjectionService.SetProjectionData(JSON.parse(projection));
        $("form").validate().settings.ignore = origIgnore; // turn it back on

        this.fullFileName = filePath[0];
        AppService.FileName = filePath[0];
        AppService.IsModified = false;
        AppService.IsFileKnown = true;

        Pass2Enabler();

        return projection;
    }

    static async saveProjection(showSaveAs) {
        console.log(`Save projection() showSaveAs: ${showSaveAs}`)
        if (showSaveAs) {
            // Open file save dialog and get file path
            var filePath = await new Promise((resolve, reject) => {
                ipcRenderer.once("File.SaveFileDialogResponse", (event, arg) => {
                    resolve(arg);
                });
                ipcRenderer.send("File.SaveFileDialog", SettingsService.LastSavePath);
            });

            if (filePath === undefined || filePath === null)
                return null;

            SettingsService.LastSavePath = filePath.substring(0, filePath.lastIndexOf("\\"));
            this.fullFileName = filePath;
        }

        // Save file data
        console.log(`Last save path: ${SettingsService.LastSavePath}`);
        console.log(`Full file name: ${this.fullFileName}`);

        var result = await new Promise((resolve, reject) => {
            ipcRenderer.once("Projection.SaveProjectionResponse", (event, arg) => {
                resolve(arg);
                //console.log(arg);               
            });
            var data = { filePath: this.fullFileName, data: ProjectionService.GetProjectionData() }
            //console.log(data);
            ipcRenderer.send("Projection.SaveProjection", data);
        });
        //console.log(result);
        console.log("setting app vars");
        AppService.FileName = this.fullFileName;
        AppService.IsModified = false;
        AppService.IsFileKnown = true;
    }

    static showModified(val) {
        console.log(`showModified: ${val}`);
        if (AppService.IgnoreModified)
            return;
        if (val)
            $("#isModified").removeClass("d-none");
        else
            $("#isModified").addClass("d-none");
    }

    static async createReport() {
        console.log("createReport()");

        if (this.reportProjection == null) {
            OpenMessageDialog("Report cannot be created.", "Please calculate a successful design before creating a report.", "Ok");
            return false;
        }

        AppService.openActivityOverlay();

        var projection = JSON.parse(this.reportProjection).data;
        console.log(projection);
        return await new Promise((resolve, reject) => {
            ipcRenderer.once("App.CreateReportResponse", (event, arg) => {
                resolve(arg);

                AppService.PdfDataUri = "data:application/pdf;base64," + arg;

                $("#pdfFrame").attr('src', `assets/lib/pdfviewer/web/viewer.html?file=${AppService.PdfDataUri}`);

                RoutingService.gotoTab(3);
                AppService.closeActivityOverlay();
                return true;
            });
            var data = { fileName: AppService.FileName, projection: projection };

            ipcRenderer.send("App.CreateReport", data);
        });
    }

    static async saveReport() {
        console.log("saveReport");
        // Open file save dialog and get file path
        var filePath = await new Promise((resolve, reject) => {
            ipcRenderer.once("File.SaveFileDialogResponse", (event, arg) => {
                resolve(arg);
            });
            var defaultFilePath = `${SettingsService.LastReportSavePath}/${AppService.FileName}.pdf`;
            ipcRenderer.send("File.SaveFileDialog", defaultFilePath, "PDF");
        });
        console.log(filePath);
        if (filePath === undefined || filePath === null)
            return null;

        SettingsService.LastReportSavePath = filePath.substring(0, filePath.lastIndexOf("\\"));

        var result = await new Promise((resolve, reject) => {
            ipcRenderer.once("Report.SaveReportResponse", (event, arg) => {
                resolve(arg);
                //console.log(arg);               
            });
            var data = { filePath: filePath, data: AppService.PdfDataUri }
            //console.log(data);
            ipcRenderer.send("Report.SaveReport", data);
        });
    }

    static openActivityOverlay() {
        console.log("openActivityOverlay");
        // console.log(AppService.Activity);
        // if (AppService.IsActivityOn) {
        //     AppService.closeActivityOverlay();
        // }
        //AppService.Activity = Metro.activity.open({ type: 'ring', style: 'dark', overlayAlpha: 0.25, overlayColor: '#fcfcfc', overlayClickClose: false });
        if (!AppService.IsActivityOn)
            $.LoadingOverlay("show", {
                image: '<svg xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0" width="256px" height="256px" viewBox="0 0 128 128" xml:space="preserve"><g><path d="M64 0a7 7 0 1 1-7 7 7 7 0 0 1 7-7zm29.86 12.2a2.8 2.8 0 1 1-3.83 1.02 2.8 2.8 0 0 1 3.83-1.02zm22.16 21.68a3.15 3.15 0 1 1-4.3-1.15 3.15 3.15 0 0 1 4.3 1.15zm.87 60.53a4.2 4.2 0 1 1-1.57-5.7 4.2 4.2 0 0 1 1.54 5.73zm7.8-30.5a3.85 3.85 0 1 1-3.85-3.85 3.85 3.85 0 0 1 3.85 3.84zm-30 53.2a4.55 4.55 0 1 1 1.66-6.23 4.55 4.55 0 0 1-1.67 6.22zM64 125.9a4.9 4.9 0 1 1 4.9-4.9 4.9 4.9 0 0 1-4.9 4.9zm-31.06-8.22a5.25 5.25 0 1 1 7.17-1.93 5.25 5.25 0 0 1-7.14 1.93zM9.9 95.1a5.6 5.6 0 1 1 7.65 2.06A5.6 5.6 0 0 1 9.9 95.1zM1.18 63.9a5.95 5.95 0 1 1 5.95 5.94 5.95 5.95 0 0 1-5.96-5.94zm8.1-31.6a6.3 6.3 0 1 1 2.32 8.6 6.3 6.3 0 0 1-2.3-8.6zM32.25 8.87a6.65 6.65 0 1 1-2.44 9.1 6.65 6.65 0 0 1 2.46-9.1z" fill="#008240"/><animateTransform attributeName="transform" type="rotate" values="0 64 64;30 64 64;60 64 64;90 64 64;120 64 64;150 64 64;180 64 64;210 64 64;240 64 64;270 64 64;300 64 64;330 64 64" calcMode="discrete" dur="1560ms" repeatCount="indefinite"></animateTransform></g></svg>',
                imageColor: false,
                background: "rgba(252, 252, 252, 0.25)",
                fade: [200, 200],
                zIndex: 800
            });
        AppService.IsActivityOn = true;
        //console.log(AppService.Activity[0].style.visibility);


    }

    static closeActivityOverlay() {
        // Metro.activity.close(AppService.Activity);
        // AppService.Activity = null;
        //console.log(AppService.Activity[0].style.visibility);
        console.log("closeActivityOverlay");
        if (AppService.IsActivityOn)
            $.LoadingOverlay("hide");
        AppService.IsActivityOn = false;
    }
}





AppService.init();