'use strict';

exports.__esModule = true;
exports['default'] = textEllipsis;

function textEllipsis(str, maxLength) {
  var _ref = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

  var _ref$side = _ref.side;
  var side = _ref$side === undefined ? 'end' : _ref$side;
  var _ref$ellipsis = _ref.ellipsis;
  var ellipsis = _ref$ellipsis === undefined ? '...' : _ref$ellipsis;

  if (str.length > maxLength) {
    switch (side) {
      case 'start':
        return ellipsis + str.slice(-(maxLength - ellipsis.length));
      case 'end':
      default:
        return str.slice(0, maxLength - ellipsis.length) + ellipsis;
    }
  }
  return str;
}

module.exports = exports['default'];