# get-installed-path [![NPM version](https://img.shields.io/npm/v/get-installed-path.svg?style=flat)](https://www.npmjs.com/package/get-installed-path) [![NPM downloads](https://img.shields.io/npm/dm/get-installed-path.svg?style=flat)](https://npmjs.org/package/get-installed-path) [![npm total downloads][downloads-img]][downloads-url]

> Get installation path where the given package is installed. Works for globally and locally installed packages. Works on Windows too.

[![code climate][codeclimate-img]][codeclimate-url] 
[![standard code style][standard-img]][standard-url] 
[![linux build status][travis-img]][travis-url] 
[![windows build status][appveyor-img]][appveyor-url] 
[![coverage status][coveralls-img]][coveralls-url] 
[![dependency status][david-img]][david-url]

You might also be interested in [detect-installed](https://github.com/tunnckocore/detect-installed#readme).

## Table of Contents
- [Install](#install)
- [Usage](#usage)
- [API](#api)
  * [getInstalledPath](#getinstalledpath)
  * [.sync](#sync)
- [Related](#related)
- [Contributing](#contributing)
- [Building docs](#building-docs)
- [Running tests](#running-tests)
- [Author](#author)
- [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install
Install with [npm](https://www.npmjs.com/)

```
$ npm install get-installed-path --save
```

or install using [yarn](https://yarnpkg.com)

```
$ yarn add get-installed-path
```

## Usage
> For more use-cases see the [tests](test.js)

```js
const getInstalledPath = require('get-installed-path')
```

## API

### [getInstalledPath](index.js#L82)
> Get installed path of globally or locally `name` package. By default it checks if `name` exists as directory in [global-modules][] directory of the system. Pass `opts.local` to get path of `name` package from local directory or from `opts.cwd`. Returns rejected promise if module not found in global/local `node_modules` folder or if it exist but is not a directory.

**Params**

* `name` **{String}**: package name    
* `opts` **{Object}**: pass `opts.local` to check locally    
* `returns` **{Promise}**: rejected promise if `name` not a string or is empty string  

**Example**

```js
const getInstalledPath = require('get-installed-path')

getInstalledPath('npm').then((path) => {
  console.log(path)
  // => '/home/charlike/.nvm/path/to/lib/node_modules/npm'
})

getInstalledPath('foo-bar-barwerwlekrjw').catch((err) => {
  console.log(err.message)
  // => 'module not found "foo-bar-barwerwlekrjw" in path ...'
})

getInstalledPath('npm', {
  local: true
}).catch((err) => {
  console.log(err.message)
  // => 'module not found "foo-bar-barwerwlekrjw" in path ...'
})

getInstalledPath('global-modules', {
  local: true
}).then((path) => {
  console.log(path)
  // => '~/code/get-installed-path/node_modules/global-modules'
})

// If you are using it for some sub-directory
// pass `opts.cwd` to be where the `node_modules`
// folder is.
process.chidr('foo-bar-baz')
getInstalledPath('global-modules', {
  local: true,
  cwd: '../'
}).then((path) => {
  console.log(path)
  // => '~/code/get-installed-path/node_modules/global-modules'
})

// When searching for the path of a package that is required
// by several other packages, its path may not be in the
// closest node_modules. In this case, to search recursively,
// you can use the following:
getInstalledPath('npm', {
  paths: process.mainModule.paths
}).then((path) => {
  // ...
})
// `process.mainModule` refers to the location of the current
// entry script.
```

### [.sync](index.js#L136)
> Get installed path of a `name` package synchronous.

**Params**

* `name` **{String}**: package name    
* `opts` **{Object}**: pass `opts.local` to check locally    
* `returns` **{Boolean}**: or throw `TypeError` if `name` not a string or is empty string  

**Example**

```js
const getInstalledPath = require('get-installed-path')

const npmPath = getInstalledPath.sync('npm')
console.log(npmPath)
// => '/home/charlike/.nvm/path/to/lib/node_modules/npm'

const gmPath = getInstalledPath.sync('global-modules', { local: true })
console.log(gmPath)
// => '~/code/get-installed-path/node_modules/global-modules'
```

## Related
- [always-done](https://www.npmjs.com/package/always-done): Handle completion and errors with elegance! Support for streams, callbacks, promises, child processes, async/await and sync functions. A drop-in replacement… [more](https://github.com/hybridables/always-done#readme) | [homepage](https://github.com/hybridables/always-done#readme "Handle completion and errors with elegance! Support for streams, callbacks, promises, child processes, async/await and sync functions. A drop-in replacement for [async-done][] - pass 100% of its tests plus more")
- [detect-installed](https://www.npmjs.com/package/detect-installed): Checks that given package is installed globally or locally. | [homepage](https://github.com/tunnckocore/detect-installed#readme "Checks that given package is installed globally or locally.")
- [global-modules](https://www.npmjs.com/package/global-modules): The directory used by npm for globally installed npm modules. | [homepage](https://github.com/jonschlinkert/global-modules "The directory used by npm for globally installed npm modules.")
- [global-paths](https://www.npmjs.com/package/global-paths): Returns an array of unique "global" directories based on the user's platform and environment. The resulting paths can be used… [more](https://github.com/jonschlinkert/global-paths) | [homepage](https://github.com/jonschlinkert/global-paths "Returns an array of unique "global" directories based on the user's platform and environment. The resulting paths can be used for doing lookups for generators or other globally installed npm packages. Node.js / JavaScript.")
- [global-prefix](https://www.npmjs.com/package/global-prefix): Get the npm global path prefix. | [homepage](https://github.com/jonschlinkert/global-prefix "Get the npm global path prefix.")
- [is-installed](https://www.npmjs.com/package/is-installed): Checks that given package is installed on the system - globally or locally. | [homepage](https://github.com/tunnckoCore/is-installed#readme "Checks that given package is installed on the system - globally or locally.")
- [minibase](https://www.npmjs.com/package/minibase): Minimalist alternative for Base. Build complex APIs with small units called plugins. Works well with most of the already existing… [more](https://github.com/node-minibase/minibase#readme) | [homepage](https://github.com/node-minibase/minibase#readme "Minimalist alternative for Base. Build complex APIs with small units called plugins. Works well with most of the already existing [base][] plugins.")
- [try-catch-core](https://www.npmjs.com/package/try-catch-core): Low-level package to handle completion and errors of sync or asynchronous functions, using [once][] and [dezalgo][] libs. Useful for and… [more](https://github.com/hybridables/try-catch-core#readme) | [homepage](https://github.com/hybridables/try-catch-core#readme "Low-level package to handle completion and errors of sync or asynchronous functions, using [once][] and [dezalgo][] libs. Useful for and used in higher-level libs such as [always-done][] to handle completion of anything.")

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/tunnckoCore/get-installed-path/issues/new).  
Please read the [contributing guidelines](CONTRIBUTING.md) for advice on opening issues, pull requests, and coding standards.  
If you need some help and can spent some cash, feel free to [contact me at CodeMentor.io](https://www.codementor.io/tunnckocore?utm_source=github&utm_medium=button&utm_term=tunnckocore&utm_campaign=github) too.

**In short:** If you want to contribute to that project, please follow these things

1. Please DO NOT edit [README.md](README.md), [CHANGELOG.md](CHANGELOG.md) and [.verb.md](.verb.md) files. See ["Building docs"](#building-docs) section.
2. Ensure anything is okey by installing the dependencies and run the tests. See ["Running tests"](#running-tests) section.
3. Always use `npm run commit` to commit changes instead of `git commit`, because it is interactive and user-friendly. It uses [commitizen][] behind the scenes, which follows Conventional Changelog idealogy.
4. Do NOT bump the version in package.json. For that we use `npm run release`, which is [standard-version][] and follows Conventional Changelog idealogy.

Thanks a lot! :)

## Building docs
Documentation and that readme is generated using [verb-generate-readme][], which is a [verb][] generator, so you need to install both of them and then run `verb` command like that

```
$ npm install verbose/verb#dev verb-generate-readme --global && verb
```

_Please don't edit the README directly. Any changes to the readme must be made in [.verb.md](.verb.md)._

## Running tests
Clone repository and run the following in that cloned directory

```
$ npm install && npm test
```

## Author
**Charlike Mike Reagent**

+ [github/tunnckoCore](https://github.com/tunnckoCore)
+ [twitter/tunnckoCore](http://twitter.com/tunnckoCore)
+ [codementor/tunnckoCore](https://codementor.io/tunnckoCore)

## License
Copyright © 2016, [Charlike Mike Reagent](http://i.am.charlike.online). Released under the [MIT license](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.2.0, on December 12, 2016._  
_Project scaffolded using [charlike][] cli._

[always-done]: https://github.com/hybridables/always-done
[async-done]: https://github.com/gulpjs/async-done
[base]: https://github.com/node-base/base
[charlike]: https://github.com/tunnckocore/charlike
[commitizen]: https://github.com/commitizen/cz-cli
[dezalgo]: https://github.com/npm/dezalgo
[global-modules]: https://github.com/jonschlinkert/global-modules
[once]: https://github.com/isaacs/once
[standard-version]: https://github.com/conventional-changelog/standard-version
[verb-generate-readme]: https://github.com/verbose/verb-generate-readme
[verb]: https://github.com/verbose/verb

[downloads-url]: https://www.npmjs.com/package/get-installed-path
[downloads-img]: https://img.shields.io/npm/dt/get-installed-path.svg

[codeclimate-url]: https://codeclimate.com/github/tunnckoCore/get-installed-path
[codeclimate-img]: https://img.shields.io/codeclimate/github/tunnckoCore/get-installed-path.svg

[travis-url]: https://travis-ci.org/tunnckoCore/get-installed-path
[travis-img]: https://img.shields.io/travis/tunnckoCore/get-installed-path/master.svg?label=linux

[appveyor-url]: https://ci.appveyor.com/project/tunnckoCore/get-installed-path
[appveyor-img]: https://img.shields.io/appveyor/ci/tunnckoCore/get-installed-path/master.svg?label=windows

[coveralls-url]: https://coveralls.io/r/tunnckoCore/get-installed-path
[coveralls-img]: https://img.shields.io/coveralls/tunnckoCore/get-installed-path.svg

[david-url]: https://david-dm.org/tunnckoCore/get-installed-path
[david-img]: https://img.shields.io/david/tunnckoCore/get-installed-path.svg

[standard-url]: https://github.com/feross/standard
[standard-img]: https://img.shields.io/badge/code%20style-standard-brightgreen.svg

