"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var BASE_URL = 'https://github.com/electron/electron/releases/download/';
var NIGHTLY_BASE_URL = 'https://github.com/electron/nightlies/releases/download/';
var FileNameUse;
(function (FileNameUse) {
    FileNameUse[FileNameUse["LOCAL"] = 0] = "LOCAL";
    FileNameUse[FileNameUse["REMOTE"] = 1] = "REMOTE";
})(FileNameUse = exports.FileNameUse || (exports.FileNameUse = {}));
function getArtifactFileName(details, usage) {
    if (usage === void 0) { usage = FileNameUse.LOCAL; }
    utils_1.ensureIsTruthyString(details, 'artifactName');
    utils_1.ensureIsTruthyString(details, 'version');
    if (details.isGeneric) {
        // When downloading we have to use the artifact name directly as that it was is stored in the release on GitHub
        if (usage === FileNameUse.REMOTE) {
            return details.artifactName;
        }
        // When caching / using on your local disk we want the generic artifact to be versioned
        return details.version + "-" + details.artifactName;
    }
    utils_1.ensureIsTruthyString(details, 'platform');
    utils_1.ensureIsTruthyString(details, 'arch');
    return [
        details.artifactName,
        details.version,
        details.platform,
        details.arch
    ].concat((details.artifactSuffix ? [details.artifactSuffix] : [])).join('-') + ".zip";
}
exports.getArtifactFileName = getArtifactFileName;
function mirrorVar(name, options, defaultValue) {
    // Convert camelCase to camel_case for env var reading
    var lowerName = name.replace(/([a-z])([A-Z])/g, function (_, a, b) { return a + "_" + b; }).toLowerCase();
    return (process.env["NPM_CONFIG_ELECTRON_" + lowerName.toUpperCase()] ||
        process.env["npm_config_electron_" + lowerName] ||
        process.env["npm_package_config_electron_" + lowerName] ||
        process.env["ELECTRON_" + lowerName.toUpperCase()] ||
        options[name] ||
        defaultValue);
}
function getArtifactRemoteURL(details) {
    var opts = details.mirrorOptions || {};
    var base = mirrorVar('mirror', opts, BASE_URL);
    if (details.version.includes('nightly')) {
        base = mirrorVar('nightly_mirror', opts, NIGHTLY_BASE_URL);
    }
    var path = mirrorVar('customDir', opts, details.version);
    var file = mirrorVar('customFilename', opts, getArtifactFileName(details, FileNameUse.REMOTE));
    return "" + base + path + "/" + file;
}
exports.getArtifactRemoteURL = getArtifactRemoteURL;
//# sourceMappingURL=artifact-utils.js.map