"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const currentVersion = require('../package').version;

const copyTemplateFile =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (destDir, basename) {
    const templateDir = _path.default.resolve(__dirname, '..', 'tmpl');

    yield _fsExtra.default.copy(_path.default.join(templateDir, basename), _path.default.resolve(destDir, basename));
  });

  return function copyTemplateFile(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

const updateFileByLine =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(function* (inputPath, lineHandler, outputPath = undefined) {
    const fileContents = (yield _fsExtra.default.readFile(inputPath, 'utf8')).split('\n').map(lineHandler).join('\n');
    yield _fsExtra.default.writeFile(outputPath || inputPath, fileContents);

    if (outputPath !== undefined) {
      yield _fsExtra.default.remove(inputPath);
    }
  });

  return function updateFileByLine(_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

class WebpackTemplate {
  constructor() {
    _defineProperty(this, "devDependencies", [`@electron-forge/plugin-webpack@${currentVersion}`, // TODO: Use the @zeit publish once https://github.com/zeit/webpack-asset-relocator-loader/pull/41 has been merged
    '@marshallofsound/webpack-asset-relocator-loader@^0.5.0', 'css-loader@^3.0.0', 'node-loader@^0.6.0', 'style-loader@^0.23.1']);

    _defineProperty(this, "initializeTemplate",
    /*#__PURE__*/
    function () {
      var _ref3 = _asyncToGenerator(function* (directory) {
        yield (0, _asyncOra.asyncOra)('Setting up Forge configuration',
        /*#__PURE__*/
        _asyncToGenerator(function* () {
          const pjPath = _path.default.resolve(directory, 'package.json');

          const currentPJ = yield _fsExtra.default.readJson(pjPath);
          currentPJ.main = '.webpack/main';
          currentPJ.config.forge.plugins = currentPJ.config.forge.plugins || [];
          currentPJ.config.forge.plugins.push(['@electron-forge/plugin-webpack', {
            mainConfig: './webpack.main.config.js',
            renderer: {
              config: './webpack.renderer.config.js',
              entryPoints: [{
                html: './src/index.html',
                js: './src/renderer.js',
                name: 'main_window'
              }]
            }
          }]);
          yield _fsExtra.default.writeJson(pjPath, currentPJ, {
            spaces: 2
          });
        }));
        yield (0, _asyncOra.asyncOra)('Setting up webpack configuration',
        /*#__PURE__*/
        _asyncToGenerator(function* () {
          yield copyTemplateFile(directory, 'webpack.main.config.js');
          yield copyTemplateFile(directory, 'webpack.renderer.config.js');
          yield copyTemplateFile(directory, 'webpack.rules.js');
          yield copyTemplateFile(_path.default.join(directory, 'src'), 'renderer.js');
          yield updateFileByLine(_path.default.resolve(directory, 'src', 'index.js'), line => {
            if (line.includes('mainWindow.loadURL')) return '  mainWindow.loadURL(MAIN_WINDOW_WEBPACK_ENTRY);';
            return line;
          }, _path.default.resolve(directory, 'src', 'main.js'));
          yield updateFileByLine(_path.default.resolve(directory, 'src', 'index.html'), line => {
            if (line.includes('link rel="stylesheet"')) return '';
            return line;
          });
        }));
      });

      return function (_x5) {
        return _ref3.apply(this, arguments);
      };
    }());
  }

}

var _default = new WebpackTemplate();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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