"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Publisher {
  constructor(config, providedPlatforms) {
    this.config = config;
    this.providedPlatforms = providedPlatforms;

    _defineProperty(this, "name", void 0);

    _defineProperty(this, "defaultPlatforms", void 0);

    _defineProperty(this, "__isElectronForgePublisher", void 0);

    this.config = config;
    Object.defineProperty(this, '__isElectronForgePublisher', {
      value: true,
      enumerable: false,
      configurable: false
    });
  }

  get platforms() {
    if (this.providedPlatforms) return this.providedPlatforms;
    if (this.defaultPlatforms) return this.defaultPlatforms;
    return ['win32', 'linux', 'darwin', 'mas'];
  }
  /**
   * Publishers must implement this method to publish the artifacts returned from
   * make calls.  If any errors occur you must throw them, failing silently or simply
   * logging will not propagate issues up to forge.
   *
   * Please note for a given version publish will be called multiple times, once
   * for each set of "platform" and "arch".  This means if you are publishing
   * darwin and win32 artifacts to somewhere like GitHub on the first publish call
   * you will have to create the version on GitHub and the second call will just
   * be appending files to the existing version.
   */


  publish(opts) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // eslint-disable-line @typescript-eslint/no-unused-vars
      throw new Error(`Publisher ${_this.name} did not implement the publish method`);
    })();
  }

}

exports.default = Publisher;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9QdWJsaXNoZXIudHMiXSwibmFtZXMiOlsiUHVibGlzaGVyIiwiY29uc3RydWN0b3IiLCJjb25maWciLCJwcm92aWRlZFBsYXRmb3JtcyIsIk9iamVjdCIsImRlZmluZVByb3BlcnR5IiwidmFsdWUiLCJlbnVtZXJhYmxlIiwiY29uZmlndXJhYmxlIiwicGxhdGZvcm1zIiwiZGVmYXVsdFBsYXRmb3JtcyIsInB1Ymxpc2giLCJvcHRzIiwiRXJyb3IiLCJuYW1lIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7QUFzQmUsTUFBZUEsU0FBZixDQUF1RDtBQU9wRUMsRUFBQUEsV0FBVyxDQUFRQyxNQUFSLEVBQTZCQyxpQkFBN0IsRUFBa0U7QUFBQSxTQUExREQsTUFBMEQsR0FBMURBLE1BQTBEO0FBQUEsU0FBckNDLGlCQUFxQyxHQUFyQ0EsaUJBQXFDOztBQUFBOztBQUFBOztBQUFBOztBQUMzRSxTQUFLRCxNQUFMLEdBQWNBLE1BQWQ7QUFDQUUsSUFBQUEsTUFBTSxDQUFDQyxjQUFQLENBQXNCLElBQXRCLEVBQTRCLDRCQUE1QixFQUEwRDtBQUN4REMsTUFBQUEsS0FBSyxFQUFFLElBRGlEO0FBRXhEQyxNQUFBQSxVQUFVLEVBQUUsS0FGNEM7QUFHeERDLE1BQUFBLFlBQVksRUFBRTtBQUgwQyxLQUExRDtBQUtEOztBQUVELE1BQUlDLFNBQUosR0FBZ0I7QUFDZCxRQUFJLEtBQUtOLGlCQUFULEVBQTRCLE9BQU8sS0FBS0EsaUJBQVo7QUFDNUIsUUFBSSxLQUFLTyxnQkFBVCxFQUEyQixPQUFPLEtBQUtBLGdCQUFaO0FBQzNCLFdBQU8sQ0FBQyxPQUFELEVBQVUsT0FBVixFQUFtQixRQUFuQixFQUE2QixLQUE3QixDQUFQO0FBQ0Q7QUFFRDs7Ozs7Ozs7Ozs7OztBQVdNQyxFQUFBQSxPQUFOLENBQWNDLElBQWQsRUFBc0M7QUFBQTs7QUFBQTtBQUFFO0FBQ3RDLFlBQU0sSUFBSUMsS0FBSixDQUFXLGFBQVksS0FBSSxDQUFDQyxJQUFLLHVDQUFqQyxDQUFOO0FBRG9DO0FBRXJDOztBQW5DbUUiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgaW1wb3J0L25vLWV4dHJhbmVvdXMtZGVwZW5kZW5jaWVzXG5pbXBvcnQge1xuICBGb3JnZVBsYXRmb3JtLCBGb3JnZUNvbmZpZywgRm9yZ2VNYWtlUmVzdWx0LCBJRm9yZ2VQdWJsaXNoZXIsXG59IGZyb20gJ0BlbGVjdHJvbi1mb3JnZS9zaGFyZWQtdHlwZXMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIFB1Ymxpc2hlck9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGJhc2UgZGlyZWN0b3J5IG9mIHRoZSBhcHBzIHNvdXJjZSBjb2RlXG4gICAqL1xuICBkaXI6IHN0cmluZztcbiAgLyoqXG4gICAqIFRoZSByZXN1bHRzIGZyb20gcnVubmluZyB0aGUgbWFrZSBjb21tYW5kXG4gICAqL1xuICBtYWtlUmVzdWx0czogRm9yZ2VNYWtlUmVzdWx0W107XG4gIC8qKlxuICAgKiBUaGUgcmF3IGZvcmdlQ29uZmlnIHRoaXMgYXBwIGlzIHVzaW5nLlxuICAgKlxuICAgKiBZb3UgcHJvYmFibHkgc2hvdWxkbid0IHVzZSB0aGlzXG4gICAqL1xuICBmb3JnZUNvbmZpZzogRm9yZ2VDb25maWc7XG59XG5cbmV4cG9ydCBkZWZhdWx0IGFic3RyYWN0IGNsYXNzIFB1Ymxpc2hlcjxDPiBpbXBsZW1lbnRzIElGb3JnZVB1Ymxpc2hlciB7XG4gIHB1YmxpYyBhYnN0cmFjdCBuYW1lOiBzdHJpbmc7XG5cbiAgcHVibGljIGRlZmF1bHRQbGF0Zm9ybXM/OiBGb3JnZVBsYXRmb3JtW107XG5cbiAgX19pc0VsZWN0cm9uRm9yZ2VQdWJsaXNoZXIhOiB0cnVlO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBjb25maWc6IEMsIHByb3RlY3RlZCBwcm92aWRlZFBsYXRmb3Jtcz86IEZvcmdlUGxhdGZvcm1bXSkge1xuICAgIHRoaXMuY29uZmlnID0gY29uZmlnO1xuICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0aGlzLCAnX19pc0VsZWN0cm9uRm9yZ2VQdWJsaXNoZXInLCB7XG4gICAgICB2YWx1ZTogdHJ1ZSxcbiAgICAgIGVudW1lcmFibGU6IGZhbHNlLFxuICAgICAgY29uZmlndXJhYmxlOiBmYWxzZSxcbiAgICB9KTtcbiAgfVxuXG4gIGdldCBwbGF0Zm9ybXMoKSB7XG4gICAgaWYgKHRoaXMucHJvdmlkZWRQbGF0Zm9ybXMpIHJldHVybiB0aGlzLnByb3ZpZGVkUGxhdGZvcm1zO1xuICAgIGlmICh0aGlzLmRlZmF1bHRQbGF0Zm9ybXMpIHJldHVybiB0aGlzLmRlZmF1bHRQbGF0Zm9ybXM7XG4gICAgcmV0dXJuIFsnd2luMzInLCAnbGludXgnLCAnZGFyd2luJywgJ21hcyddIGFzIEZvcmdlUGxhdGZvcm1bXTtcbiAgfVxuXG4gIC8qKlxuICAgKiBQdWJsaXNoZXJzIG11c3QgaW1wbGVtZW50IHRoaXMgbWV0aG9kIHRvIHB1Ymxpc2ggdGhlIGFydGlmYWN0cyByZXR1cm5lZCBmcm9tXG4gICAqIG1ha2UgY2FsbHMuICBJZiBhbnkgZXJyb3JzIG9jY3VyIHlvdSBtdXN0IHRocm93IHRoZW0sIGZhaWxpbmcgc2lsZW50bHkgb3Igc2ltcGx5XG4gICAqIGxvZ2dpbmcgd2lsbCBub3QgcHJvcGFnYXRlIGlzc3VlcyB1cCB0byBmb3JnZS5cbiAgICpcbiAgICogUGxlYXNlIG5vdGUgZm9yIGEgZ2l2ZW4gdmVyc2lvbiBwdWJsaXNoIHdpbGwgYmUgY2FsbGVkIG11bHRpcGxlIHRpbWVzLCBvbmNlXG4gICAqIGZvciBlYWNoIHNldCBvZiBcInBsYXRmb3JtXCIgYW5kIFwiYXJjaFwiLiAgVGhpcyBtZWFucyBpZiB5b3UgYXJlIHB1Ymxpc2hpbmdcbiAgICogZGFyd2luIGFuZCB3aW4zMiBhcnRpZmFjdHMgdG8gc29tZXdoZXJlIGxpa2UgR2l0SHViIG9uIHRoZSBmaXJzdCBwdWJsaXNoIGNhbGxcbiAgICogeW91IHdpbGwgaGF2ZSB0byBjcmVhdGUgdGhlIHZlcnNpb24gb24gR2l0SHViIGFuZCB0aGUgc2Vjb25kIGNhbGwgd2lsbCBqdXN0XG4gICAqIGJlIGFwcGVuZGluZyBmaWxlcyB0byB0aGUgZXhpc3RpbmcgdmVyc2lvbi5cbiAgICovXG4gIGFzeW5jIHB1Ymxpc2gob3B0czogUHVibGlzaGVyT3B0aW9ucykgeyAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby11bnVzZWQtdmFyc1xuICAgIHRocm93IG5ldyBFcnJvcihgUHVibGlzaGVyICR7dGhpcy5uYW1lfSBkaWQgbm90IGltcGxlbWVudCB0aGUgcHVibGlzaCBtZXRob2RgKTtcbiAgfVxufVxuIl19