import { ForgePlatform, ForgeConfig, ForgeMakeResult, IForgePublisher } from '@electron-forge/shared-types';
export interface PublisherOptions {
    /**
     * The base directory of the apps source code
     */
    dir: string;
    /**
     * The results from running the make command
     */
    makeResults: ForgeMakeResult[];
    /**
     * The raw forgeConfig this app is using.
     *
     * You probably shouldn't use this
     */
    forgeConfig: ForgeConfig;
}
export default abstract class Publisher<C> implements IForgePublisher {
    config: C;
    protected providedPlatforms?: ForgePlatform[] | undefined;
    abstract name: string;
    defaultPlatforms?: ForgePlatform[];
    __isElectronForgePublisher: true;
    constructor(config: C, providedPlatforms?: ForgePlatform[] | undefined);
    readonly platforms: ForgePlatform[];
    /**
     * Publishers must implement this method to publish the artifacts returned from
     * make calls.  If any errors occur you must throw them, failing silently or simply
     * logging will not propagate issues up to forge.
     *
     * Please note for a given version publish will be called multiple times, once
     * for each set of "platform" and "arch".  This means if you are publishing
     * darwin and win32 artifacts to somewhere like GitHub on the first publish call
     * you will have to create the version on GitHub and the second call will just
     * be appending files to the existing version.
     */
    publish(opts: PublisherOptions): Promise<void>;
}
