/// <reference types="node" />
import { ForgeConfig, ForgeHookFn, IForgePlugin, StartOptions } from '@electron-forge/shared-types';
import { ChildProcess } from 'child_process';
export { StartOptions };
export default abstract class Plugin<C> implements IForgePlugin {
    config: C;
    abstract name: string;
    __isElectronForgePlugin: true;
    constructor(config: C);
    init(_dir: string, _config: ForgeConfig): void;
    getHook(_hookName: string): ForgeHookFn | null;
    startLogic(_startOpts: StartOptions): Promise<ChildProcess | string | string[] | false>;
}
