"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _makerBase = _interopRequireDefault(require("@electron-forge/maker-base"));

var _path = _interopRequireDefault(require("path"));

var _util = require("util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MakerZIP extends _makerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'zip');

    _defineProperty(this, "defaultPlatforms", ['darwin', 'mas', 'win32', 'linux']);
  }

  isSupportedOnCurrentPlatform() {
    return true;
  }

  make({
    dir,
    makeDir,
    appName,
    packageJSON,
    targetPlatform
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // eslint-disable-next-line global-require
      const _require = require('cross-zip'),
            zip = _require.zip;

      const zipDir = ['darwin', 'mas'].includes(targetPlatform) ? _path.default.resolve(dir, `${appName}.app`) : dir;

      const zipPath = _path.default.resolve(makeDir, `${_path.default.basename(dir)}-${packageJSON.version}.zip`);

      yield _this.ensureFile(zipPath);
      yield (0, _util.promisify)(zip)(zipDir, zipPath);
      return [zipPath];
    })();
  }

}

exports.default = MakerZIP;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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