"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _makerBase = _interopRequireDefault(require("@electron-forge/maker-base"));

var _electronWinstaller = require("electron-winstaller");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class MakerSquirrel extends _makerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'squirrel');

    _defineProperty(this, "defaultPlatforms", ['win32']);
  }

  isSupportedOnCurrentPlatform() {
    return this.isInstalled('electron-winstaller') && !process.env.DISABLE_SQUIRREL_TEST;
  }

  make({
    dir,
    makeDir,
    targetArch,
    packageJSON,
    appName
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const outPath = _path.default.resolve(makeDir, `squirrel.windows/${targetArch}`);

      yield _this.ensureDirectory(outPath);
      const winstallerConfig = Object.assign({
        name: packageJSON.name,
        title: appName,
        noMsi: true,
        exe: `${appName}.exe`,
        setupExe: `${appName}-${packageJSON.version} Setup.exe`
      }, _this.config, {
        appDirectory: dir,
        outputDirectory: outPath
      });
      yield (0, _electronWinstaller.createWindowsInstaller)(winstallerConfig);
      const artifacts = [_path.default.resolve(outPath, 'RELEASES'), _path.default.resolve(outPath, winstallerConfig.setupExe || `${appName}Setup.exe`), _path.default.resolve(outPath, `${winstallerConfig.name}-${packageJSON.version}-full.nupkg`)];

      const deltaPath = _path.default.resolve(outPath, `${winstallerConfig.name}-${packageJSON.version}-delta.nupkg`);

      if (winstallerConfig.remoteReleases || (yield _fsExtra.default.pathExists(deltaPath))) {
        artifacts.push(deltaPath);
      }

      const msiPath = _path.default.resolve(outPath, winstallerConfig.setupMsi || `${appName}Setup.msi`);

      if (!winstallerConfig.noMsi && (yield _fsExtra.default.pathExists(msiPath))) {
        artifacts.push(msiPath);
      }

      return artifacts;
    })();
  }

}

exports.default = MakerSquirrel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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