"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rpmArch = rpmArch;
exports.default = void 0;

require("source-map-support/register");

var _makerBase = _interopRequireDefault(require("@electron-forge/maker-base"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function rpmArch(nodeArch) {
  switch (nodeArch) {
    case 'ia32':
      return 'i386';

    case 'x64':
      return 'x86_64';

    case 'armv7l':
      return 'armv7hl';

    case 'arm':
      return 'armv6hl';

    default:
      return nodeArch;
  }
}

class MakerRpm extends _makerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'rpm');

    _defineProperty(this, "defaultPlatforms", ['linux']);
  }

  isSupportedOnCurrentPlatform() {
    return this.isInstalled('electron-installer-redhat') && process.platform === 'linux';
  }

  make({
    dir,
    makeDir,
    targetArch
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // eslint-disable-next-line global-require, import/no-unresolved
      const installer = require('electron-installer-redhat');

      const outDir = _path.default.resolve(makeDir);

      yield _this.ensureDirectory(outDir);

      const _ref = yield installer(_objectSpread({}, _this.config, {
        arch: rpmArch(targetArch),
        src: dir,
        dest: outDir,
        rename: undefined
      })),
            packagePaths = _ref.packagePaths;

      return packagePaths;
    })();
  }

}

exports.default = MakerRpm;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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