"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debianArch = debianArch;
exports.default = void 0;

require("source-map-support/register");

var _makerBase = _interopRequireDefault(require("@electron-forge/maker-base"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function debianArch(nodeArch) {
  switch (nodeArch) {
    case 'ia32':
      return 'i386';

    case 'x64':
      return 'amd64';

    case 'armv7l':
      return 'armhf';

    case 'arm':
      return 'armel';

    default:
      return nodeArch;
  }
}

class MakerDeb extends _makerBase.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'deb');

    _defineProperty(this, "defaultPlatforms", ['linux']);
  }

  isSupportedOnCurrentPlatform() {
    return this.isInstalled('electron-installer-debian') && process.platform === 'linux';
  }

  make({
    dir,
    makeDir,
    targetArch
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // eslint-disable-next-line global-require, import/no-unresolved
      const installer = require('electron-installer-debian');

      const outDir = _path.default.resolve(makeDir);

      yield _this.ensureDirectory(outDir);

      const _ref = yield installer(_objectSpread({
        options: {}
      }, _this.config, {
        arch: debianArch(targetArch),
        src: dir,
        dest: outDir,
        rename: undefined
      })),
            packagePaths = _ref.packagePaths;

      return packagePaths;
    })();
  }

}

exports.default = MakerDeb;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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