"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Maker {
  constructor(configFetcher = {}, providedPlatforms) {
    this.configFetcher = configFetcher;
    this.providedPlatforms = providedPlatforms;

    _defineProperty(this, "config", void 0);

    _defineProperty(this, "name", void 0);

    _defineProperty(this, "defaultPlatforms", void 0);

    _defineProperty(this, "__isElectronForgeMaker", void 0);

    Object.defineProperty(this, '__isElectronForgeMaker', {
      value: true,
      enumerable: false,
      configurable: false
    });
  }

  get platforms() {
    if (this.providedPlatforms) return this.providedPlatforms;
    return this.defaultPlatforms;
  } // TODO: Remove this, it is an eye-sore and is a nasty hack to provide forge
  //       v5 style functionality in the new API


  prepareConfig(targetArch) {
    if (typeof this.configFetcher === 'function') {
      this.config = this.configFetcher(targetArch);
    } else {
      this.config = this.configFetcher;
    }
  }
  /**
   * Makers must implement this method and return true or false indicating whether
   * this maker can be run on the current platform.  Normally this is just a process.platform
   * check but it can be a deeper check for dependencies like fake-root or other
   * required external build tools.
   *
   * If the issue is a missing dependency you should log out a HELPFUL error message
   * telling the developer exactly what is missing and if possible how to get it.
   */


  isSupportedOnCurrentPlatform() {
    if (this.isSupportedOnCurrentPlatform === Maker.prototype.isSupportedOnCurrentPlatform) {
      throw new Error(`Maker ${this.name} did not implement the isSupportedOnCurrentPlatform method`);
    }

    return true;
  }
  /**
   * Makers must implement this method and return an array of absolute paths
   * to the artifacts generated by your maker
   */


  make(opts) {
    var _this = this;

    return _asyncToGenerator(function* () {
      // eslint-disable-line max-len, @typescript-eslint/no-unused-vars
      if (_this.make === Maker.prototype.make) {
        throw new Error(`Maker ${_this.name} did not implement the make method`);
      }

      return [];
    })();
  }
  /**
   * Helpers
   */

  /**
   * Ensures the directory exists and is forced to be empty.
   *
   * I.e. If the directory already exists it is deleted and recreated, this
   * is a destructive operation
   */


  ensureDirectory(dir) {
    return _asyncToGenerator(function* () {
      if (yield _fsExtra.default.pathExists(dir)) {
        yield _fsExtra.default.remove(dir);
      }

      return _fsExtra.default.mkdirs(dir);
    })();
  }
  /**
   * Ensures the path to the file exists and the file does not exist
   *
   * I.e. If the file already exists it is deleted and the path created
   */


  ensureFile(file) {
    return _asyncToGenerator(function* () {
      if (yield _fsExtra.default.pathExists(file)) {
        yield _fsExtra.default.remove(file);
      }

      yield _fsExtra.default.mkdirs(_path.default.dirname(file));
    })();
  }
  /**
   * Checks if the given module is installed, used for testing if optional dependencies
   * are installed or not
   */


  isInstalled(module) {
    try {
      // eslint-disable-next-line global-require, import/no-dynamic-require
      require(module);

      return true;
    } catch (e) {
      // Package doesn't exist -- must not be installable on this platform
      return false;
    }
  }

}

exports.default = Maker;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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