"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _installerDarwin = _interopRequireDefault(require("@electron-forge/installer-darwin"));

var _crossSpawnPromise = _interopRequireDefault(require("cross-spawn-promise"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InstallerZip extends _installerDarwin.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'zip');
  }

  install({
    filePath,
    installSpinner
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      yield (0, _crossSpawnPromise.default)('unzip', ['-q', '-o', _path.default.basename(filePath)], {
        cwd: _path.default.dirname(filePath)
      });
      const appPath = (yield _fsExtra.default.readdir(_path.default.dirname(filePath))).filter(file => file.endsWith('.app')).map(file => _path.default.resolve(_path.default.dirname(filePath), file)).sort((fA, fB) => _fsExtra.default.statSync(fA).ctime.getTime() - _fsExtra.default.statSync(fB).ctime.getTime())[0];
      const targetApplicationPath = `/Applications/${_path.default.basename(appPath)}`;
      yield _this.moveApp(appPath, targetApplicationPath, installSpinner);
      yield (0, _crossSpawnPromise.default)('open', ['-R', targetApplicationPath], {
        detached: true
      });
    })();
  }

}

exports.default = InstallerZip;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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