"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "InstallerOptions", {
  enumerable: true,
  get: function get() {
    return _installerBase.InstallerOptions;
  }
});
exports.default = void 0;

require("source-map-support/register");

var _installerBase = _interopRequireWildcard(require("@electron-forge/installer-base"));

var _child_process = require("child_process");

var _util = require("util");

var _sudoPrompt = _interopRequireDefault(require("sudo-prompt"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InstallerLinux extends _installerBase.default {
  constructor(..._args) {
    super(..._args);

    _defineProperty(this, "which",
    /*#__PURE__*/
    function () {
      var _ref = _asyncToGenerator(function* (type, prog, promise) {
        if ((0, _child_process.spawnSync)('which', [prog]).status === 0) {
          yield promise();
        } else {
          throw new Error(`${prog} is required to install ${type} packages`);
        }
      });

      return function (_x, _x2, _x3) {
        return _ref.apply(this, arguments);
      };
    }());

    _defineProperty(this, "sudo", (type, program, args) => this.which(type, program, () => (0, _util.promisify)(_sudoPrompt.default.exec)(`${program} ${args}`, {
      name: 'Electron Forge'
    })));
  }

}

exports.default = InstallerLinux;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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