"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unmountImage = exports.mountImage = exports.getMountedImages = void 0;

require("source-map-support/register");

var _crossSpawnPromise = _interopRequireDefault(require("cross-spawn-promise"));

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:hdiutil');

const getMountedImages =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* () {
    const output = yield (0, _crossSpawnPromise.default)('hdiutil', ['info']);
    const mounts = output.toString().split(/====\n/g);
    mounts.shift();
    const mountObjects = [];
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = mounts[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const mount = _step.value;

        try {
          const mountPath = /\/Volumes\/(.+)\n/g.exec(mount)[1];
          const imagePath = /image-path +: +(.+)\n/g.exec(mount)[1];
          mountObjects.push({
            mountPath,
            imagePath
          });
        } catch (err) {// Ignore
        }
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    d('identified active mounts', mountObjects);
    return mountObjects;
  });

  return function getMountedImages() {
    return _ref.apply(this, arguments);
  };
}();

exports.getMountedImages = getMountedImages;

const mountImage =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(function* (filePath) {
    d('mounting image:', filePath);
    const output = yield (0, _crossSpawnPromise.default)('hdiutil', ['attach', '-noautoopen', '-nobrowse', '-noverify', filePath]);
    const mountPath = /\/Volumes\/(.+)\n/g.exec(output.toString())[1];
    d('mounted at:', mountPath);
    return {
      mountPath,
      imagePath: filePath
    };
  });

  return function mountImage(_x) {
    return _ref2.apply(this, arguments);
  };
}();

exports.mountImage = mountImage;

const unmountImage =
/*#__PURE__*/
function () {
  var _ref3 = _asyncToGenerator(function* (mount) {
    d('unmounting current mount:', mount);
    yield (0, _crossSpawnPromise.default)('hdiutil', ['unmount', '-force', `/Volumes/${mount.mountPath}`]);
  });

  return function unmountImage(_x2) {
    return _ref3.apply(this, arguments);
  };
}();

exports.unmountImage = unmountImage;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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