"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _installerDarwin = _interopRequireDefault(require("@electron-forge/installer-darwin"));

var _crossSpawnPromise = _interopRequireDefault(require("cross-spawn-promise"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _hdiutil = require("./util/hdiutil");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class InstallerDMG extends _installerDarwin.default {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "name", 'dmg');
  }

  install({
    filePath,
    installSpinner
  }) {
    var _this = this;

    return _asyncToGenerator(function* () {
      const mounts = yield (0, _hdiutil.getMountedImages)();
      let targetMount = mounts.find(mount => mount.imagePath === filePath);

      if (!targetMount) {
        targetMount = yield (0, _hdiutil.mountImage)(filePath);
      }

      try {
        const volumePath = _path.default.resolve('/Volumes', targetMount.mountPath);

        const appName = (yield _fsExtra.default.readdir(volumePath)).find(file => file.endsWith('.app'));

        if (!appName) {
          throw new Error('Failed to find .app file in DMG');
        }

        const appPath = _path.default.resolve(volumePath, appName);

        const targetApplicationPath = `/Applications/${_path.default.basename(appPath)}`;
        yield _this.moveApp(appPath, targetApplicationPath, installSpinner, true);
        yield (0, _crossSpawnPromise.default)('open', ['-R', targetApplicationPath], {
          detached: true
        });
      } finally {
        yield (0, _hdiutil.unmountImage)(targetMount);
      }
    })();
  }

}

exports.default = InstallerDMG;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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