"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "InstallerOptions", {
  enumerable: true,
  get: function get() {
    return _installerBase.InstallerOptions;
  }
});
exports.default = void 0;

require("source-map-support/register");

var _installerBase = _interopRequireWildcard(require("@electron-forge/installer-base"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _util = require("util");

var _sudoPrompt = _interopRequireDefault(require("sudo-prompt"));

var _child_process = require("child_process");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

class InstallerDarwin extends _installerBase.default {
  moveApp(appPath, targetApplicationPath, spinner, copyInstead = false) {
    return _asyncToGenerator(function* () {
      let writeAccess = true;

      try {
        yield _fsExtra.default.access('/Applications', _fsExtra.default.constants.W_OK);
      } catch (err) {
        writeAccess = false;
      }

      if (yield _fsExtra.default.pathExists(targetApplicationPath)) {
        spinner.fail();
        throw new Error(`The application "${_path.default.basename(targetApplicationPath)}" appears to already exist in /Applications.`);
      }

      const moveCommand = `${copyInstead ? 'cp -r' : 'mv'} "${appPath}" "${targetApplicationPath}"`;

      if (writeAccess) {
        yield (0, _util.promisify)(_child_process.exec)(moveCommand);
      } else {
        yield (0, _util.promisify)(_sudoPrompt.default.exec)(moveCommand, {
          name: 'Electron Forge'
        });
      }
    })();
  }

}

exports.default = InstallerDarwin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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