import { OraImpl } from '@electron-forge/async-ora';
export interface InstallerOptions {
    filePath: string;
    installSpinner: OraImpl;
}
export default abstract class Installer {
    abstract name: string;
    __isElectronForgeInstaller: boolean;
    constructor();
    /**
     * Installers must implement this method and install the given filePath
     * when called.  This method must return a promise
     */
    install(_opts: InstallerOptions): Promise<void>;
}
