"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasYarn = exports.yarnOrNpmSpawn = exports.default = void 0;

require("source-map-support/register");

var _crossSpawnPromise = _interopRequireDefault(require("cross-spawn-promise"));

var _logSymbols = _interopRequireDefault(require("log-symbols"));

var _yarnOrNpm = _interopRequireDefault(require("yarn-or-npm"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const safeYarnOrNpm = () => {
  const system = (0, _yarnOrNpm.default)();

  switch (process.env.NODE_INSTALLER) {
    case 'yarn':
    case 'npm':
      return process.env.NODE_INSTALLER;

    default:
      if (process.env.NODE_INSTALLER) {
        // eslint-disable-next-line no-console
        console.warn(`${_logSymbols.default.warning} Unknown NODE_INSTALLER, using detected installer ${system}`.yellow);
      }

      return system;
  }
};

var _default = safeYarnOrNpm; // eslint-disable-next-line max-len

exports.default = _default;

const yarnOrNpmSpawn = (args, opts) => (0, _crossSpawnPromise.default)(safeYarnOrNpm(), args, opts);

exports.yarnOrNpmSpawn = yarnOrNpmSpawn;

const hasYarn = () => safeYarnOrNpm() === 'yarn';

exports.hasYarn = hasYarn;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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