"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = upgradeForgeConfig;
exports.updateUpgradedForgeDevDeps = updateUpgradedForgeDevDeps;

require("source-map-support/register");

var _path = _interopRequireDefault(require("path"));

var _initNpm = require("../api/init-scripts/init-npm");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function mapMakeTargets(forge5Config) {
  const makeTargets = new Map();

  if (forge5Config.makeTargets) {
    for (var _i = 0, _Object$entries = Object.entries(forge5Config.makeTargets); _i < _Object$entries.length; _i++) {
      const _Object$entries$_i = _slicedToArray(_Object$entries[_i], 2),
            platform = _Object$entries$_i[0],
            targets = _Object$entries$_i[1];

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = targets[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          const target = _step.value;
          let platforms = makeTargets.get(target);

          if (platforms === undefined) {
            platforms = [];
            makeTargets.set(target, platforms);
          }

          platforms.push(platform);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }

  return makeTargets;
}

const forge5MakerMappings = new Map([['electronInstallerDebian', 'deb'], ['electronInstallerDMG', 'dmg'], ['electronInstallerFlatpak', 'flatpak'], ['electronInstallerRedhat', 'rpm'], ['electronInstallerSnap', 'snap'], ['electronWinstallerConfig', 'squirrel'], ['electronWixMSIConfig', 'wix'], ['windowsStoreConfig', 'appx']]);
/**
 * Converts Forge v5 maker config to v6.
 */

function generateForgeMakerConfig(forge5Config) {
  const makeTargets = mapMakeTargets(forge5Config);
  const makers = [];
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = forge5MakerMappings[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      const _step2$value = _slicedToArray(_step2.value, 2),
            forge5Key = _step2$value[0],
            makerType = _step2$value[1];

      const config = forge5Config[forge5Key];

      if (config) {
        makers.push({
          name: `@electron-forge/maker-${makerType}`,
          config: forge5Config[forge5Key],
          platforms: makeTargets.get(makerType) || null
        });
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }

  const zipPlatforms = makeTargets.get('zip');

  if (zipPlatforms) {
    makers.push({
      name: '@electron-forge/maker-zip',
      platforms: zipPlatforms
    });
  }

  return makers;
}

const forge5PublisherMappings = new Map([['github_repository', 'github'], ['s3', 's3'], ['electron-release-server', 'electron-release-server'], ['snapStore', 'snapcraft']]);
/**
 * Transforms v5 GitHub publisher config to v6 syntax.
 */

function transformGitHubPublisherConfig(config) {
  const name = config.name,
        owner = config.owner,
        options = config.options,
        gitHubConfig = _objectWithoutProperties(config, ["name", "owner", "options"]);

  gitHubConfig.repository = {
    name,
    owner
  };

  if (options) {
    gitHubConfig.octokitOptions = options;
  }

  return gitHubConfig;
}
/**
 * Converts Forge v5 publisher config to v6.
 */


function generateForgePublisherConfig(forge5Config) {
  const publishers = [];
  var _iteratorNormalCompletion3 = true;
  var _didIteratorError3 = false;
  var _iteratorError3 = undefined;

  try {
    for (var _iterator3 = forge5PublisherMappings[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
      const _step3$value = _slicedToArray(_step3.value, 2),
            forge5Key = _step3$value[0],
            publisherType = _step3$value[1];

      let config = forge5Config[forge5Key];

      if (config) {
        if (publisherType === 'github') {
          config = transformGitHubPublisherConfig(config);
        }

        publishers.push({
          config,
          name: `@electron-forge/publisher-${publisherType}`,
          platforms: null
        });
      }
    }
  } catch (err) {
    _didIteratorError3 = true;
    _iteratorError3 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
        _iterator3.return();
      }
    } finally {
      if (_didIteratorError3) {
        throw _iteratorError3;
      }
    }
  }

  return publishers;
}
/**
 * Upgrades Forge v5 config to v6.
 */


function upgradeForgeConfig(forge5Config) {
  const forgeConfig = {};

  if (forge5Config.electronPackagerConfig) {
    delete forge5Config.electronPackagerConfig.packageManager;
    forgeConfig.packagerConfig = forge5Config.electronPackagerConfig;
  }

  if (forge5Config.electronRebuildConfig) {
    forgeConfig.electronRebuildConfig = forge5Config.electronRebuildConfig;
  }

  forgeConfig.makers = generateForgeMakerConfig(forge5Config);
  forgeConfig.publishers = generateForgePublisherConfig(forge5Config);
  return forgeConfig;
}

function updateUpgradedForgeDevDeps(packageJSON, devDeps) {
  const forgeConfig = packageJSON.config.forge;
  devDeps = devDeps.filter(dep => !dep.startsWith('@electron-forge/maker-')); // eslint-disable-next-line max-len

  devDeps = devDeps.concat(forgeConfig.makers.map(maker => (0, _initNpm.siblingDep)(_path.default.basename(maker.name)))); // eslint-disable-next-line max-len

  devDeps = devDeps.concat(forgeConfig.publishers.map(publisher => (0, _initNpm.siblingDep)(_path.default.basename(publisher.name))));

  if (Object.keys(packageJSON.devDependencies).find(dep => dep === 'electron-prebuilt-compile')) {
    devDeps = devDeps.concat((0, _initNpm.siblingDep)('plugin-compile'));
  }

  return devDeps;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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