"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _readPackageJson = require("./read-package-json");

var _electronVersion = require("./electron-version");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:project-resolver'); // FIXME: If we want getElectronVersion to be overridable by plugins
//        and / or forge config then we need to be able to resolve
//        the dir without calling getElectronVersion

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir) {
    let mDir = dir;
    let bestGuessDir = null;
    let lastError = null;
    let prevDir;

    while (prevDir !== mDir) {
      prevDir = mDir;

      const testPath = _path.default.resolve(mDir, 'package.json');

      d('searching for project in:', mDir);

      if (yield _fsExtra.default.pathExists(testPath)) {
        const packageJSON = yield (0, _readPackageJson.readRawPackageJson)(mDir); // TODO: Move this check to inside the forge config resolver and use
        //       mutatedPackageJson reader

        try {
          yield (0, _electronVersion.getElectronVersion)(mDir, packageJSON);
        } catch (err) {
          lastError = err.message;
        }

        if (packageJSON.config && packageJSON.config.forge) {
          d('electron-forge compatible package.json found in', testPath);
          return mDir;
        }

        bestGuessDir = mDir;
      }

      mDir = _path.default.dirname(mDir);
    }

    if (bestGuessDir) {
      d('guessing on the best electron-forge package.json found in', bestGuessDir);
      return bestGuessDir;
    }

    if (lastError) {
      throw lastError;
    }

    return null;
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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