"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requireSearchRaw = requireSearchRaw;
exports.default = void 0;

require("source-map-support/register");

var _debug = _interopRequireDefault(require("debug"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const d = (0, _debug.default)('electron-forge:require-search');

function requireSearchRaw(relativeTo, paths) {
  const testPaths = paths.concat(paths.map(mapPath => _path.default.resolve(relativeTo, mapPath))).concat(paths.map(mapPath => _path.default.resolve(relativeTo, 'node_modules', mapPath)));
  d('searching', testPaths, 'relative to', relativeTo);
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = testPaths[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      const testPath = _step.value;

      try {
        d('testing', testPath); // eslint-disable-next-line global-require, import/no-dynamic-require

        return require(testPath);
      } catch (err) {// Ignore the error
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return != null) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  d('failed to find a module in', testPaths);
  return null;
}

// eslint-disable-next-line arrow-parens
var _default = (relativeTo, paths) => {
  const result = requireSearchRaw(relativeTo, paths);
  return typeof result === 'object' && result && result.default ? result.default : result;
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3JlcXVpcmUtc2VhcmNoLnRzIl0sIm5hbWVzIjpbImQiLCJyZXF1aXJlU2VhcmNoUmF3IiwicmVsYXRpdmVUbyIsInBhdGhzIiwidGVzdFBhdGhzIiwiY29uY2F0IiwibWFwIiwibWFwUGF0aCIsInBhdGgiLCJyZXNvbHZlIiwidGVzdFBhdGgiLCJyZXF1aXJlIiwiZXJyIiwicmVzdWx0IiwiZGVmYXVsdCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFBOztBQUNBOzs7O0FBRUEsTUFBTUEsQ0FBQyxHQUFHLG9CQUFNLCtCQUFOLENBQVY7O0FBRU8sU0FBU0MsZ0JBQVQsQ0FBNkJDLFVBQTdCLEVBQWlEQyxLQUFqRCxFQUE0RTtBQUNqRixRQUFNQyxTQUFTLEdBQUdELEtBQUssQ0FDcEJFLE1BRGUsQ0FDUkYsS0FBSyxDQUFDRyxHQUFOLENBQVVDLE9BQU8sSUFBSUMsY0FBS0MsT0FBTCxDQUFhUCxVQUFiLEVBQXlCSyxPQUF6QixDQUFyQixDQURRLEVBRWZGLE1BRmUsQ0FFUkYsS0FBSyxDQUFDRyxHQUFOLENBQVVDLE9BQU8sSUFBSUMsY0FBS0MsT0FBTCxDQUFhUCxVQUFiLEVBQXlCLGNBQXpCLEVBQXlDSyxPQUF6QyxDQUFyQixDQUZRLENBQWxCO0FBR0FQLEVBQUFBLENBQUMsQ0FBQyxXQUFELEVBQWNJLFNBQWQsRUFBeUIsYUFBekIsRUFBd0NGLFVBQXhDLENBQUQ7QUFKaUY7QUFBQTtBQUFBOztBQUFBO0FBS2pGLHlCQUF1QkUsU0FBdkIsOEhBQWtDO0FBQUEsWUFBdkJNLFFBQXVCOztBQUNoQyxVQUFJO0FBQ0ZWLFFBQUFBLENBQUMsQ0FBQyxTQUFELEVBQVlVLFFBQVosQ0FBRCxDQURFLENBRUY7O0FBQ0EsZUFBT0MsT0FBTyxDQUFDRCxRQUFELENBQWQ7QUFDRCxPQUpELENBSUUsT0FBT0UsR0FBUCxFQUFZLENBQ1o7QUFDRDtBQUNGO0FBYmdGO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7O0FBY2pGWixFQUFBQSxDQUFDLENBQUMsNEJBQUQsRUFBK0JJLFNBQS9CLENBQUQ7QUFDQSxTQUFPLElBQVA7QUFDRDs7QUFNRDtlQUNlLENBQUlGLFVBQUosRUFBd0JDLEtBQXhCLEtBQXNEO0FBQ25FLFFBQU1VLE1BQU0sR0FBR1osZ0JBQWdCLENBQW9CQyxVQUFwQixFQUFnQ0MsS0FBaEMsQ0FBL0I7QUFDQSxTQUFPLE9BQU9VLE1BQVAsS0FBa0IsUUFBbEIsSUFBOEJBLE1BQTlCLElBQXdDQSxNQUFNLENBQUNDLE9BQS9DLEdBQXlERCxNQUFNLENBQUNDLE9BQWhFLEdBQTBFRCxNQUFqRjtBQUNELEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZGVidWcgZnJvbSAnZGVidWcnO1xuaW1wb3J0IHBhdGggZnJvbSAncGF0aCc7XG5cbmNvbnN0IGQgPSBkZWJ1ZygnZWxlY3Ryb24tZm9yZ2U6cmVxdWlyZS1zZWFyY2gnKTtcblxuZXhwb3J0IGZ1bmN0aW9uIHJlcXVpcmVTZWFyY2hSYXc8VD4ocmVsYXRpdmVUbzogc3RyaW5nLCBwYXRoczogc3RyaW5nW10pOiBUIHwgbnVsbCB7XG4gIGNvbnN0IHRlc3RQYXRocyA9IHBhdGhzXG4gICAgLmNvbmNhdChwYXRocy5tYXAobWFwUGF0aCA9PiBwYXRoLnJlc29sdmUocmVsYXRpdmVUbywgbWFwUGF0aCkpKVxuICAgIC5jb25jYXQocGF0aHMubWFwKG1hcFBhdGggPT4gcGF0aC5yZXNvbHZlKHJlbGF0aXZlVG8sICdub2RlX21vZHVsZXMnLCBtYXBQYXRoKSkpO1xuICBkKCdzZWFyY2hpbmcnLCB0ZXN0UGF0aHMsICdyZWxhdGl2ZSB0bycsIHJlbGF0aXZlVG8pO1xuICBmb3IgKGNvbnN0IHRlc3RQYXRoIG9mIHRlc3RQYXRocykge1xuICAgIHRyeSB7XG4gICAgICBkKCd0ZXN0aW5nJywgdGVzdFBhdGgpO1xuICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIGdsb2JhbC1yZXF1aXJlLCBpbXBvcnQvbm8tZHluYW1pYy1yZXF1aXJlXG4gICAgICByZXR1cm4gcmVxdWlyZSh0ZXN0UGF0aCk7XG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAvLyBJZ25vcmUgdGhlIGVycm9yXG4gICAgfVxuICB9XG4gIGQoJ2ZhaWxlZCB0byBmaW5kIGEgbW9kdWxlIGluJywgdGVzdFBhdGhzKTtcbiAgcmV0dXJuIG51bGw7XG59XG5cbmV4cG9ydCB0eXBlIFBvc3NpYmxlTW9kdWxlPFQ+ID0ge1xuICBkZWZhdWx0PzogVDtcbn0gJiBUO1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgYXJyb3ctcGFyZW5zXG5leHBvcnQgZGVmYXVsdCA8VD4ocmVsYXRpdmVUbzogc3RyaW5nLCBwYXRoczogc3RyaW5nW10pOiBUIHwgbnVsbCA9PiB7XG4gIGNvbnN0IHJlc3VsdCA9IHJlcXVpcmVTZWFyY2hSYXc8UG9zc2libGVNb2R1bGU8VD4+KHJlbGF0aXZlVG8sIHBhdGhzKTtcbiAgcmV0dXJuIHR5cGVvZiByZXN1bHQgPT09ICdvYmplY3QnICYmIHJlc3VsdCAmJiByZXN1bHQuZGVmYXVsdCA/IHJlc3VsdC5kZWZhdWx0IDogcmVzdWx0IGFzIChUIHwgbnVsbCk7XG59O1xuIl19