"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _asyncOra = require("@electron-forge/async-ora");

var _electronRebuild = _interopRequireDefault(require("electron-rebuild"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (buildPath, electronVersion, platform, arch, config = {}) {
    yield (0, _asyncOra.asyncOra)('Preparing native dependencies',
    /*#__PURE__*/
    function () {
      var _ref2 = _asyncToGenerator(function* (rebuildSpinner) {
        const rebuilder = (0, _electronRebuild.default)(Object.assign({}, config, {
          buildPath,
          electronVersion,
          arch
        }));
        const lifecycle = rebuilder.lifecycle;
        let found = 0;
        let done = 0;

        const redraw = () => {
          rebuildSpinner.text = `Preparing native dependencies: ${done} / ${found}`;
        };

        lifecycle.on('module-found', () => {
          found += 1;
          redraw();
        });
        lifecycle.on('module-done', () => {
          done += 1;
          redraw();
        });
        yield rebuilder;
      });

      return function (_x5) {
        return _ref2.apply(this, arguments);
      };
    }());
  });

  return function (_x, _x2, _x3, _x4) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3JlYnVpbGQudHMiXSwibmFtZXMiOlsiYnVpbGRQYXRoIiwiZWxlY3Ryb25WZXJzaW9uIiwicGxhdGZvcm0iLCJhcmNoIiwiY29uZmlnIiwicmVidWlsZFNwaW5uZXIiLCJyZWJ1aWxkZXIiLCJPYmplY3QiLCJhc3NpZ24iLCJsaWZlY3ljbGUiLCJmb3VuZCIsImRvbmUiLCJyZWRyYXciLCJ0ZXh0Iiwib24iXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOztBQUdBOzs7Ozs7Ozs7OzsrQkFHZSxXQUNiQSxTQURhLEVBRWJDLGVBRmEsRUFHYkMsUUFIYSxFQUliQyxJQUphLEVBS2JDLE1BQStCLEdBQUcsRUFMckIsRUFNVjtBQUNILFVBQU0sd0JBQVMsK0JBQVQ7QUFBQTtBQUFBO0FBQUEsb0NBQTBDLFdBQU9DLGNBQVAsRUFBMEI7QUFDeEUsY0FBTUMsU0FBUyxHQUFHLDhCQUFRQyxNQUFNLENBQUNDLE1BQVAsQ0FBYyxFQUFkLEVBQWtCSixNQUFsQixFQUEwQjtBQUNsREosVUFBQUEsU0FEa0Q7QUFFbERDLFVBQUFBLGVBRmtEO0FBR2xERSxVQUFBQTtBQUhrRCxTQUExQixDQUFSLENBQWxCO0FBRHdFLGNBTWhFTSxTQU5nRSxHQU1sREgsU0FOa0QsQ0FNaEVHLFNBTmdFO0FBUXhFLFlBQUlDLEtBQUssR0FBRyxDQUFaO0FBQ0EsWUFBSUMsSUFBSSxHQUFHLENBQVg7O0FBRUEsY0FBTUMsTUFBTSxHQUFHLE1BQU07QUFDbkJQLFVBQUFBLGNBQWMsQ0FBQ1EsSUFBZixHQUF1QixrQ0FBaUNGLElBQUssTUFBS0QsS0FBTSxFQUF4RTtBQUNELFNBRkQ7O0FBSUFELFFBQUFBLFNBQVMsQ0FBQ0ssRUFBVixDQUFhLGNBQWIsRUFBNkIsTUFBTTtBQUFFSixVQUFBQSxLQUFLLElBQUksQ0FBVDtBQUFZRSxVQUFBQSxNQUFNO0FBQUssU0FBNUQ7QUFDQUgsUUFBQUEsU0FBUyxDQUFDSyxFQUFWLENBQWEsYUFBYixFQUE0QixNQUFNO0FBQUVILFVBQUFBLElBQUksSUFBSSxDQUFSO0FBQVdDLFVBQUFBLE1BQU07QUFBSyxTQUExRDtBQUVBLGNBQU1OLFNBQU47QUFDRCxPQW5CSzs7QUFBQTtBQUFBO0FBQUE7QUFBQSxRQUFOO0FBb0JELEciLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBhc3luY09yYSB9IGZyb20gJ0BlbGVjdHJvbi1mb3JnZS9hc3luYy1vcmEnO1xuaW1wb3J0IHsgRm9yZ2VQbGF0Zm9ybSwgRm9yZ2VBcmNoIH0gZnJvbSAnQGVsZWN0cm9uLWZvcmdlL3NoYXJlZC10eXBlcyc7XG5cbmltcG9ydCByZWJ1aWxkIGZyb20gJ2VsZWN0cm9uLXJlYnVpbGQnO1xuaW1wb3J0IHsgUmVidWlsZE9wdGlvbnMgfSBmcm9tICdlbGVjdHJvbi1yZWJ1aWxkL2xpYi9zcmMvcmVidWlsZCc7XG5cbmV4cG9ydCBkZWZhdWx0IGFzeW5jIChcbiAgYnVpbGRQYXRoOiBzdHJpbmcsXG4gIGVsZWN0cm9uVmVyc2lvbjogc3RyaW5nLFxuICBwbGF0Zm9ybTogRm9yZ2VQbGF0Zm9ybSxcbiAgYXJjaDogRm9yZ2VBcmNoLFxuICBjb25maWc6IFBhcnRpYWw8UmVidWlsZE9wdGlvbnM+ID0ge30sXG4pID0+IHtcbiAgYXdhaXQgYXN5bmNPcmEoJ1ByZXBhcmluZyBuYXRpdmUgZGVwZW5kZW5jaWVzJywgYXN5bmMgKHJlYnVpbGRTcGlubmVyKSA9PiB7XG4gICAgY29uc3QgcmVidWlsZGVyID0gcmVidWlsZChPYmplY3QuYXNzaWduKHt9LCBjb25maWcsIHtcbiAgICAgIGJ1aWxkUGF0aCxcbiAgICAgIGVsZWN0cm9uVmVyc2lvbixcbiAgICAgIGFyY2gsXG4gICAgfSkpO1xuICAgIGNvbnN0IHsgbGlmZWN5Y2xlIH0gPSByZWJ1aWxkZXI7XG5cbiAgICBsZXQgZm91bmQgPSAwO1xuICAgIGxldCBkb25lID0gMDtcblxuICAgIGNvbnN0IHJlZHJhdyA9ICgpID0+IHtcbiAgICAgIHJlYnVpbGRTcGlubmVyLnRleHQgPSBgUHJlcGFyaW5nIG5hdGl2ZSBkZXBlbmRlbmNpZXM6ICR7ZG9uZX0gLyAke2ZvdW5kfWA7XG4gICAgfTtcblxuICAgIGxpZmVjeWNsZS5vbignbW9kdWxlLWZvdW5kJywgKCkgPT4geyBmb3VuZCArPSAxOyByZWRyYXcoKTsgfSk7XG4gICAgbGlmZWN5Y2xlLm9uKCdtb2R1bGUtZG9uZScsICgpID0+IHsgZG9uZSArPSAxOyByZWRyYXcoKTsgfSk7XG5cbiAgICBhd2FpdCByZWJ1aWxkZXI7XG4gIH0pO1xufTtcbiJdfQ==