"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readMutatedPackageJson = exports.readRawPackageJson = void 0;

require("source-map-support/register");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _hook = require("./hook");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const readRawPackageJson =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir) {
    return _fsExtra.default.readJson(_path.default.resolve(dir, 'package.json'));
  });

  return function readRawPackageJson(_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.readRawPackageJson = readRawPackageJson;

const readMutatedPackageJson =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(function* (dir, forgeConfig) {
    return (0, _hook.runMutatingHook)(forgeConfig, 'readPackageJson', (yield readRawPackageJson(dir)));
  });

  return function readMutatedPackageJson(_x2, _x3) {
    return _ref2.apply(this, arguments);
  };
}();

exports.readMutatedPackageJson = readMutatedPackageJson;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL3JlYWQtcGFja2FnZS1qc29uLnRzIl0sIm5hbWVzIjpbInJlYWRSYXdQYWNrYWdlSnNvbiIsImRpciIsImZzIiwicmVhZEpzb24iLCJwYXRoIiwicmVzb2x2ZSIsInJlYWRNdXRhdGVkUGFja2FnZUpzb24iLCJmb3JnZUNvbmZpZyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQ0E7O0FBQ0E7O0FBRUE7Ozs7Ozs7O0FBRU8sTUFBTUEsa0JBQWtCO0FBQUE7QUFBQTtBQUFBLCtCQUFHLFdBQU9DLEdBQVA7QUFBQSxXQUF1QkMsaUJBQUdDLFFBQUgsQ0FBWUMsY0FBS0MsT0FBTCxDQUFhSixHQUFiLEVBQWtCLGNBQWxCLENBQVosQ0FBdkI7QUFBQSxHQUFIOztBQUFBLGtCQUFsQkQsa0JBQWtCO0FBQUE7QUFBQTtBQUFBLEdBQXhCOzs7O0FBRUEsTUFBTU0sc0JBQXNCO0FBQUE7QUFBQTtBQUFBLGdDQUFHLFdBQU9MLEdBQVAsRUFBb0JNLFdBQXBCO0FBQUEsV0FBaUQsMkJBQWdCQSxXQUFoQixFQUE2QixpQkFBN0IsU0FBc0RQLGtCQUFrQixDQUFDQyxHQUFELENBQXhFLEVBQWpEO0FBQUEsR0FBSDs7QUFBQSxrQkFBdEJLLHNCQUFzQjtBQUFBO0FBQUE7QUFBQSxHQUE1QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZvcmdlQ29uZmlnIH0gZnJvbSAnQGVsZWN0cm9uLWZvcmdlL3NoYXJlZC10eXBlcyc7XG5pbXBvcnQgZnMgZnJvbSAnZnMtZXh0cmEnO1xuaW1wb3J0IHBhdGggZnJvbSAncGF0aCc7XG5cbmltcG9ydCB7IHJ1bk11dGF0aW5nSG9vayB9IGZyb20gJy4vaG9vayc7XG5cbmV4cG9ydCBjb25zdCByZWFkUmF3UGFja2FnZUpzb24gPSBhc3luYyAoZGlyOiBzdHJpbmcpID0+IGZzLnJlYWRKc29uKHBhdGgucmVzb2x2ZShkaXIsICdwYWNrYWdlLmpzb24nKSk7XG5cbmV4cG9ydCBjb25zdCByZWFkTXV0YXRlZFBhY2thZ2VKc29uID0gYXN5bmMgKGRpcjogc3RyaW5nLCBmb3JnZUNvbmZpZzogRm9yZ2VDb25maWcpID0+IHJ1bk11dGF0aW5nSG9vayhmb3JnZUNvbmZpZywgJ3JlYWRQYWNrYWdlSnNvbicsIGF3YWl0IHJlYWRSYXdQYWNrYWdlSnNvbihkaXIpKTtcbiJdfQ==