"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _crypto = _interopRequireDefault(require("crypto"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const EXTENSION = '.forge.publish';

class PublishState {
  static loadFromDirectory(directory, rootDir) {
    return _asyncToGenerator(function* () {
      if (!(yield _fsExtra.default.pathExists(directory))) {
        throw new Error(`Attempted to load publish state from a missing directory: ${directory}`);
      }

      const publishes = [];
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (yield _fsExtra.default.readdir(directory))[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          const dirName = _step.value;

          const subDir = _path.default.resolve(directory, dirName);

          const states = [];

          if ((yield _fsExtra.default.stat(subDir)).isDirectory()) {
            const filePaths = (yield _fsExtra.default.readdir(subDir)).filter(fileName => fileName.endsWith(EXTENSION)).map(fileName => _path.default.resolve(subDir, fileName));
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;

            try {
              for (var _iterator2 = filePaths[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                const filePath = _step2.value;
                const state = new PublishState(filePath);
                yield state.load(); // eslint-disable-next-line max-len

                state.state.artifacts = state.state.artifacts.map(artifactPath => _path.default.resolve(rootDir, artifactPath));
                states.push(state);
              }
            } catch (err) {
              _didIteratorError2 = true;
              _iteratorError2 = err;
            } finally {
              try {
                if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
                  _iterator2.return();
                }
              } finally {
                if (_didIteratorError2) {
                  throw _iteratorError2;
                }
              }
            }
          }

          publishes.push(states);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return publishes;
    })();
  }

  static saveToDirectory(directory, artifacts, rootDir) {
    return _asyncToGenerator(function* () {
      const id = _crypto.default.createHash('SHA256').update(JSON.stringify(artifacts)).digest('hex');

      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = artifacts[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          const artifact = _step3.value;
          // eslint-disable-next-line max-len
          artifact.artifacts = artifact.artifacts.map(artifactPath => _path.default.relative(rootDir, artifactPath));
          const publishState = new PublishState(_path.default.resolve(directory, id, 'null'), false);
          publishState.state = artifact;
          yield publishState.saveToDisk();
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    })();
  }

  constructor(filePath, hasHash = true) {
    _defineProperty(this, "dir", void 0);

    _defineProperty(this, "path", void 0);

    _defineProperty(this, "hasHash", void 0);

    _defineProperty(this, "state", {});

    this.dir = _path.default.dirname(filePath);
    this.path = filePath;
    this.hasHash = hasHash;
  }

  generateHash() {
    const content = JSON.stringify(this.state || {});
    return _crypto.default.createHash('SHA256').update(content).digest('hex');
  }

  load() {
    var _this = this;

    return _asyncToGenerator(function* () {
      _this.state = yield _fsExtra.default.readJson(_this.path);
    })();
  }

  saveToDisk() {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      if (!_this2.hasHash) {
        _this2.path = _path.default.resolve(_this2.dir, `${_this2.generateHash()}${EXTENSION}`);
        _this2.hasHash = true;
      }

      yield _fsExtra.default.mkdirs(_path.default.dirname(_this2.path));
      yield _fsExtra.default.writeJson(_this2.path, _this2.state);
    })();
  }

}

exports.default = PublishState;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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