"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _pluginBase = _interopRequireDefault(require("@electron-forge/plugin-base"));

var _debug = _interopRequireDefault(require("debug"));

var _requireSearch = _interopRequireDefault(require("./require-search"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const d = (0, _debug.default)('electron-forge:plugins');

class PluginInterface {
  constructor(dir, forgeConfig) {
    _defineProperty(this, "plugins", void 0);

    _defineProperty(this, "config", void 0);

    this.plugins = forgeConfig.plugins.map(plugin => {
      // eslint-disable-next-line no-underscore-dangle
      if (plugin.__isElectronForgePlugin) {
        return plugin;
      }

      if (Array.isArray(plugin)) {
        const _plugin = _slicedToArray(plugin, 2),
              pluginName = _plugin[0],
              _plugin$ = _plugin[1],
              opts = _plugin$ === void 0 ? {} : _plugin$;

        if (typeof pluginName !== 'string') {
          throw new Error(`Expected plugin[0] to be a string but found ${pluginName}`);
        }

        const Plugin = (0, _requireSearch.default)(dir, [pluginName]);

        if (!Plugin) {
          throw new Error(`Could not find module with name: ${plugin[0]}. Make sure it's listed in the devDependencies of your package.json`);
        }

        return new Plugin(opts);
      }

      throw new Error(`Expected plugin to either be a plugin instance or [string, object] but found ${plugin}`);
    }); // Fix linting

    this.config = null;
    Object.defineProperty(this, 'config', {
      value: forgeConfig,
      enumerable: false,
      configurable: false,
      writable: false
    });
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = this.plugins[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const plugin = _step.value;
        plugin.init(dir, forgeConfig);
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }

    this.triggerHook = this.triggerHook.bind(this);
    this.overrideStartLogic = this.overrideStartLogic.bind(this);
  }

  triggerHook(hookName, hookArgs) {
    var _this = this;

    return _asyncToGenerator(function* () {
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = _this.plugins[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          const plugin = _step2.value;

          if (typeof plugin.getHook === 'function') {
            const hook = plugin.getHook(hookName);
            if (hook) yield hook(_this.config, ...hookArgs);
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    })();
  }

  triggerMutatingHook(hookName, item) {
    var _this2 = this;

    return _asyncToGenerator(function* () {
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = _this2.plugins[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          const plugin = _step3.value;

          if (typeof plugin.getHook === 'function') {
            const hook = plugin.getHook(hookName);

            if (hook) {
              item = yield hook(_this2.config, item);
            }
          }
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }

      return item;
    })();
  }

  overrideStartLogic(opts) {
    var _this3 = this;

    return _asyncToGenerator(function* () {
      let newStartFn;
      const claimed = [];
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = _this3.plugins[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          const plugin = _step4.value;

          if (typeof plugin.startLogic === 'function' && plugin.startLogic !== _pluginBase.default.prototype.startLogic) {
            claimed.push(plugin.name);
            newStartFn = plugin.startLogic;
          }
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return != null) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }

      if (claimed.length > 1) {
        throw new Error(`Multiple plugins tried to take control of the start command, please remove one of them\n --> ${claimed.join(', ')}`);
      }

      if (claimed.length === 1 && newStartFn) {
        d(`plugin: "${claimed[0]}" has taken control of the start command`);
        return newStartFn(opts);
      }

      return false;
    })();
  }

}

exports.default = PluginInterface;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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