"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.sudo = void 0;

require("source-map-support/register");

var _util = require("util");

var _child_process = require("child_process");

var _sudoPrompt = _interopRequireDefault(require("sudo-prompt"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const which =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (type, prog, promise) {
    if ((0, _child_process.spawnSync)('which', [prog]).status === 0) {
      yield promise();
    } else {
      throw new Error(`${prog} is required to install ${type} packages`);
    }
  });

  return function which(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();

const sudo = (type, prog, args) => which(type, prog, () => (0, _util.promisify)(_sudoPrompt.default.exec)(`${prog} ${args}`, {
  name: 'Electron Forge'
}));

exports.sudo = sudo;
var _default = which;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL2xpbnV4LWluc3RhbGxlci50cyJdLCJuYW1lcyI6WyJ3aGljaCIsInR5cGUiLCJwcm9nIiwicHJvbWlzZSIsInN0YXR1cyIsIkVycm9yIiwic3VkbyIsImFyZ3MiLCJzdWRvUHJvbXB0IiwiZXhlYyIsIm5hbWUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOzs7Ozs7OztBQUVBLE1BQU1BLEtBQUs7QUFBQTtBQUFBO0FBQUEsK0JBQUcsV0FBT0MsSUFBUCxFQUFxQkMsSUFBckIsRUFBbUNDLE9BQW5DLEVBQW1FO0FBQy9FLFFBQUksOEJBQVUsT0FBVixFQUFtQixDQUFDRCxJQUFELENBQW5CLEVBQTJCRSxNQUEzQixLQUFzQyxDQUExQyxFQUE2QztBQUMzQyxZQUFNRCxPQUFPLEVBQWI7QUFDRCxLQUZELE1BRU87QUFDTCxZQUFNLElBQUlFLEtBQUosQ0FBVyxHQUFFSCxJQUFLLDJCQUEwQkQsSUFBSyxXQUFqRCxDQUFOO0FBQ0Q7QUFDRixHQU5VOztBQUFBLGtCQUFMRCxLQUFLO0FBQUE7QUFBQTtBQUFBLEdBQVg7O0FBUU8sTUFBTU0sSUFBSSxHQUFHLENBQUNMLElBQUQsRUFBZUMsSUFBZixFQUE2QkssSUFBN0IsS0FBOENQLEtBQUssQ0FBQ0MsSUFBRCxFQUFPQyxJQUFQLEVBQWEsTUFBTSxxQkFBVU0sb0JBQVdDLElBQXJCLEVBQTRCLEdBQUVQLElBQUssSUFBR0ssSUFBSyxFQUEzQyxFQUE4QztBQUFFRyxFQUFBQSxJQUFJLEVBQUU7QUFBUixDQUE5QyxDQUFuQixDQUFoRTs7O2VBRVFWLEsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBwcm9taXNpZnkgfSBmcm9tICd1dGlsJztcbmltcG9ydCB7IHNwYXduU3luYyB9IGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuaW1wb3J0IHN1ZG9Qcm9tcHQgZnJvbSAnc3Vkby1wcm9tcHQnO1xuXG5jb25zdCB3aGljaCA9IGFzeW5jICh0eXBlOiBzdHJpbmcsIHByb2c6IHN0cmluZywgcHJvbWlzZTogKCkgPT4gUHJvbWlzZTxhbnk+KSA9PiB7XG4gIGlmIChzcGF3blN5bmMoJ3doaWNoJywgW3Byb2ddKS5zdGF0dXMgPT09IDApIHtcbiAgICBhd2FpdCBwcm9taXNlKCk7XG4gIH0gZWxzZSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGAke3Byb2d9IGlzIHJlcXVpcmVkIHRvIGluc3RhbGwgJHt0eXBlfSBwYWNrYWdlc2ApO1xuICB9XG59O1xuXG5leHBvcnQgY29uc3Qgc3VkbyA9ICh0eXBlOiBzdHJpbmcsIHByb2c6IHN0cmluZywgYXJnczogc3RyaW5nKSA9PiB3aGljaCh0eXBlLCBwcm9nLCAoKSA9PiBwcm9taXNpZnkoc3Vkb1Byb21wdC5leGVjKShgJHtwcm9nfSAke2FyZ3N9YCwgeyBuYW1lOiAnRWxlY3Ryb24gRm9yZ2UnIH0pKTtcblxuZXhwb3J0IGRlZmF1bHQgd2hpY2g7XG4iXX0=