"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DepVersionRestriction = exports.DepType = void 0;

require("source-map-support/register");

var _debug = _interopRequireDefault(require("debug"));

var _yarnOrNpm = require("./yarn-or-npm");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:dependency-installer');
let DepType;
exports.DepType = DepType;

(function (DepType) {
  DepType["PROD"] = "PROD";
  DepType["DEV"] = "DEV";
})(DepType || (exports.DepType = DepType = {}));

let DepVersionRestriction;
exports.DepVersionRestriction = DepVersionRestriction;

(function (DepVersionRestriction) {
  DepVersionRestriction["EXACT"] = "EXACT";
  DepVersionRestriction["RANGE"] = "RANGE";
})(DepVersionRestriction || (exports.DepVersionRestriction = DepVersionRestriction = {}));

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir, deps, depType = DepType.PROD, versionRestriction = DepVersionRestriction.RANGE) {
    // eslint-disable-line consistent-return
    d('installing', JSON.stringify(deps), 'in:', dir, `depType=${depType},versionRestriction=${versionRestriction},withYarn=${(0, _yarnOrNpm.hasYarn)()}`);

    if (deps.length === 0) {
      d('nothing to install, stopping immediately');
      return Promise.resolve();
    }

    let cmd = ['install'].concat(deps);

    if ((0, _yarnOrNpm.hasYarn)()) {
      cmd = ['add'].concat(deps);
      if (depType === DepType.DEV) cmd.push('--dev');
      if (versionRestriction === DepVersionRestriction.EXACT) cmd.push('--exact');
    } else {
      if (versionRestriction === DepVersionRestriction.EXACT) cmd.push('--save-exact');
      if (depType === DepType.DEV) cmd.push('--save-dev');
      if (depType === DepType.PROD) cmd.push('--save');
    }

    d('executing', JSON.stringify(cmd), 'in:', dir);

    try {
      yield (0, _yarnOrNpm.yarnOrNpmSpawn)(cmd, {
        cwd: dir,
        stdio: 'pipe'
      });
    } catch (err) {
      throw new Error(`Failed to install modules: ${JSON.stringify(deps)}\n\nWith output: ${err.message}\n${err.stderr.toString()}`);
    }
  });

  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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