"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runMutatingHook = runMutatingHook;
exports.runHook = void 0;

require("source-map-support/register");

var _debug = _interopRequireDefault(require("debug"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:hook');

const runHook =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (forgeConfig, hookName, ...hookArgs) {
    const hooks = forgeConfig.hooks;

    if (hooks) {
      d(`hook triggered: ${hookName}`);

      if (typeof hooks[hookName] === 'function') {
        d('calling hook:', hookName, 'with args:', hookArgs);
        yield hooks[hookName](forgeConfig, ...hookArgs);
      }
    }

    yield forgeConfig.pluginInterface.triggerHook(hookName, hookArgs);
  });

  return function runHook(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

exports.runHook = runHook;

function runMutatingHook(_x3, _x4, _x5) {
  return _runMutatingHook.apply(this, arguments);
}

function _runMutatingHook() {
  _runMutatingHook = _asyncToGenerator(function* (forgeConfig, hookName, item) {
    const hooks = forgeConfig.hooks;

    if (hooks) {
      d(`hook triggered: ${hookName}`);

      if (typeof hooks[hookName] === 'function') {
        d('calling mutating hook:', hookName, 'with item:', item);
        const result = yield hooks[hookName](forgeConfig, item);

        if (typeof result !== 'undefined') {
          item = result;
        }
      }
    }

    return forgeConfig.pluginInterface.triggerMutatingHook(hookName, item);
  });
  return _runMutatingHook.apply(this, arguments);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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