"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setInitialForgeConfig = setInitialForgeConfig;
exports.fromBuildIdentifier = fromBuildIdentifier;
exports.default = void 0;

require("source-map-support/register");

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _lodash = _interopRequireDefault(require("lodash.template"));

var _readPackageJson = require("./read-package-json");

var _pluginInterface = _interopRequireDefault(require("./plugin-interface"));

var _hook = require("./hook");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const underscoreCase = str => str.replace(/(.)([A-Z][a-z]+)/g, '$1_$2').replace(/([a-z0-9])([A-Z])/g, '$1_$2').toUpperCase(); // eslint-disable-next-line arrow-parens


const proxify = (buildIdentifier, object, envPrefix) => {
  let newObject = {};

  if (Array.isArray(object)) {
    newObject = [];
  }

  Object.keys(object).forEach(key => {
    const val = object[key];

    if (typeof val === 'object' && key !== 'pluginInterface' && !(val instanceof RegExp)) {
      newObject[key] = proxify(buildIdentifier, object[key], `${envPrefix}_${underscoreCase(key)}`);
    } else {
      newObject[key] = object[key];
    }
  });
  return new Proxy(newObject, {
    get(target, name, receiver) {
      // eslint-disable-next-line no-prototype-builtins
      if (!target.hasOwnProperty(name) && typeof name === 'string') {
        const envValue = process.env[`${envPrefix}_${underscoreCase(name)}`];
        if (envValue) return envValue;
      }

      const value = Reflect.get(target, name, receiver); // eslint-disable-next-line no-underscore-dangle

      if (value && typeof value === 'object' && value.__isMagicBuildIdentifierMap) {
        const identifier = typeof buildIdentifier === 'function' ? buildIdentifier() : buildIdentifier;
        return value.map[identifier];
      }

      return value;
    },

    getOwnPropertyDescriptor(target, name) {
      const envValue = process.env[`${envPrefix}_${underscoreCase(name)}`]; // eslint-disable-next-line no-prototype-builtins

      if (target.hasOwnProperty(name)) {
        return Reflect.getOwnPropertyDescriptor(target, name);
      }

      if (envValue) {
        return {
          writable: true,
          enumerable: true,
          configurable: true,
          value: envValue
        };
      }

      return undefined;
    }

  });
};
/**
 * Sets sensible defaults for the `config.forge` object.
 */


function setInitialForgeConfig(packageJSON) {
  const _packageJSON$name = packageJSON.name,
        name = _packageJSON$name === void 0 ? '' : _packageJSON$name;
  packageJSON.config.forge.makers[0].config.name = name.replace(/-/g, '_');
}

function fromBuildIdentifier(map) {
  return {
    map,
    __isMagicBuildIdentifierMap: true
  };
}

function forgeConfigIsValidFilePath(_x, _x2) {
  return _forgeConfigIsValidFilePath.apply(this, arguments);
}

function _forgeConfigIsValidFilePath() {
  _forgeConfigIsValidFilePath = _asyncToGenerator(function* (dir, forgeConfig) {
    return typeof forgeConfig === 'string' && ((yield _fsExtra.default.pathExists(_path.default.resolve(dir, forgeConfig))) || _fsExtra.default.pathExists(_path.default.resolve(dir, `${forgeConfig}.js`)));
  });
  return _forgeConfigIsValidFilePath.apply(this, arguments);
}

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (dir) {
    const packageJSON = yield (0, _readPackageJson.readRawPackageJson)(dir);
    let forgeConfig = packageJSON.config && packageJSON.config.forge ? packageJSON.config.forge : null;

    if (!forgeConfig) {
      if (yield _fsExtra.default.pathExists(_path.default.resolve(dir, 'forge.config.js'))) {
        forgeConfig = 'forge.config.js';
      } else {
        forgeConfig = {};
      }
    }

    if (yield forgeConfigIsValidFilePath(dir, forgeConfig)) {
      try {
        // eslint-disable-next-line global-require, import/no-dynamic-require
        forgeConfig = require(_path.default.resolve(dir, forgeConfig));
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(`Failed to load: ${_path.default.resolve(dir, forgeConfig)}`);
        throw err;
      }
    } else if (typeof forgeConfig !== 'object') {
      throw new Error('Expected packageJSON.config.forge to be an object or point to a requirable JS file');
    }

    forgeConfig = Object.assign({
      packagerConfig: {},
      rebuildConfig: {},
      makers: [],
      publishers: [],
      plugins: []
    }, forgeConfig);
    const templateObj = Object.assign({}, packageJSON, {
      year: new Date().getFullYear()
    });

    const template = obj => {
      Object.keys(obj).forEach(objKey => {
        if (typeof obj[objKey] === 'object' && obj !== null) {
          template(obj[objKey]);
        } else if (typeof obj[objKey] === 'string') {
          obj[objKey] = (0, _lodash.default)(obj[objKey])(templateObj);

          if (obj[objKey].startsWith('require:')) {
            // eslint-disable-next-line global-require, import/no-dynamic-require
            obj[objKey] = require(_path.default.resolve(dir, obj[objKey].substr(8)));
          }
        }
      });
    };

    template(forgeConfig);
    forgeConfig.pluginInterface = new _pluginInterface.default(dir, forgeConfig);
    forgeConfig = yield (0, _hook.runMutatingHook)(forgeConfig, 'resolveForgeConfig', forgeConfig);
    return proxify(forgeConfig.buildIdentifier || '', forgeConfig, 'ELECTRON_FORGE');
  });

  return function (_x3) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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