"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElectronVersion = getElectronVersion;
exports.updateElectronDependency = updateElectronDependency;
exports.PackageNotFoundError = void 0;

require("source-map-support/register");

var _debug = _interopRequireDefault(require("debug"));

var _findUp = _interopRequireDefault(require("find-up"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _semver = _interopRequireDefault(require("semver"));

var _yarnOrNpm = _interopRequireWildcard(require("./yarn-or-npm"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:electron-version');
const electronPackageNames = ['electron-prebuilt-compile', 'electron-prebuilt', 'electron-nightly', 'electron'];

function findElectronDep(dep) {
  return electronPackageNames.includes(dep);
}

function findAncestorNodeModulesPath(_x) {
  return _findAncestorNodeModulesPath.apply(this, arguments);
}

function _findAncestorNodeModulesPath() {
  _findAncestorNodeModulesPath = _asyncToGenerator(function* (dir) {
    if ((0, _yarnOrNpm.hasYarn)()) {
      const yarnLockPath = yield (0, _findUp.default)('yarn.lock', {
        cwd: dir,
        type: 'file'
      });

      if (yarnLockPath) {
        const nodeModulesPath = _path.default.join(_path.default.dirname(yarnLockPath), 'node_modules');

        if (yield _fsExtra.default.pathExists(nodeModulesPath)) {
          return nodeModulesPath;
        }
      }
    }

    return Promise.resolve(undefined);
  });
  return _findAncestorNodeModulesPath.apply(this, arguments);
}

function determineNodeModulesPath(_x2) {
  return _determineNodeModulesPath.apply(this, arguments);
}

function _determineNodeModulesPath() {
  _determineNodeModulesPath = _asyncToGenerator(function* (dir) {
    const nodeModulesPath = _path.default.join(dir, 'node_modules');

    if (yield _fsExtra.default.pathExists(nodeModulesPath)) {
      return nodeModulesPath;
    }

    return findAncestorNodeModulesPath(dir);
  });
  return _determineNodeModulesPath.apply(this, arguments);
}

class PackageNotFoundError extends Error {
  constructor(packageName, dir) {
    super(`Cannot find the package "${packageName}". Perhaps you need to run "${(0, _yarnOrNpm.default)()} install" in "${dir}"?`);
  }

}

exports.PackageNotFoundError = PackageNotFoundError;

function getElectronVersion(_x3, _x4) {
  return _getElectronVersion.apply(this, arguments);
}

function _getElectronVersion() {
  _getElectronVersion = _asyncToGenerator(function* (dir, packageJSON) {
    if (!packageJSON.devDependencies) {
      throw new Error('package.json for app does not have any devDependencies'.red);
    }

    const packageName = electronPackageNames.find(pkg => packageJSON.devDependencies[pkg]);

    if (packageName === undefined) {
      throw new Error('Could not find any Electron packages in devDependencies');
    }

    let version = packageJSON.devDependencies[packageName];

    if (!_semver.default.valid(version)) {
      // It's not an exact version, find it in the actual module
      const nodeModulesPath = yield determineNodeModulesPath(dir);

      if (!nodeModulesPath) {
        throw new PackageNotFoundError(packageName, dir);
      }

      const electronPackageJSONPath = _path.default.join(nodeModulesPath, packageName, 'package.json');

      if (yield _fsExtra.default.pathExists(electronPackageJSONPath)) {
        const electronPackageJSON = yield _fsExtra.default.readJson(electronPackageJSONPath); // eslint-disable-next-line prefer-destructuring

        version = electronPackageJSON.version;
      } else {
        throw new PackageNotFoundError(packageName, dir);
      }
    }

    return version;
  });
  return _getElectronVersion.apply(this, arguments);
}

function updateElectronDependency(packageJSON, dev, exact) {
  const alteredDev = [].concat(dev);
  let alteredExact = [].concat(exact);

  if (Object.keys(packageJSON.devDependencies).find(findElectronDep)) {
    alteredExact = alteredExact.filter(dep => dep !== 'electron');
  } else {
    const electronKey = Object.keys(packageJSON.dependencies).find(findElectronDep);

    if (electronKey) {
      alteredExact = alteredExact.filter(dep => dep !== 'electron');
      d(`Moving ${electronKey} from dependencies to devDependencies`);
      alteredDev.push(`${electronKey}@${packageJSON.dependencies[electronKey]}`);
      delete packageJSON.dependencies[electronKey];
    }
  }

  return [alteredDev, alteredExact];
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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