"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

var _child_process = _interopRequireDefault(require("child_process"));

var _debug = _interopRequireDefault(require("debug"));

var _util = require("util");

var _username = _interopRequireDefault(require("username"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:determine-author');
const exec = (0, _util.promisify)(_child_process.default.exec);

const execAndTrimResult =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* (command, dir) {
    const _ref2 = yield exec(command, {
      cwd: dir
    }),
          stdout = _ref2.stdout;

    return stdout.trim();
  });

  return function execAndTrimResult(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

const getAuthorFromGitConfig =
/*#__PURE__*/
function () {
  var _ref3 = _asyncToGenerator(function* (dir) {
    try {
      const name = yield execAndTrimResult('git config --get user.name', dir);
      const email = yield execAndTrimResult('git config --get user.email', dir);
      return {
        name,
        email
      };
    } catch (err) {
      d('Error when getting git config:', err);
      return undefined;
    }
  });

  return function getAuthorFromGitConfig(_x3) {
    return _ref3.apply(this, arguments);
  };
}();

var _default =
/*#__PURE__*/
function () {
  var _ref4 = _asyncToGenerator(function* (dir) {
    return (yield getAuthorFromGitConfig(dir)) || (0, _username.default)();
  });

  return function (_x4) {
    return _ref4.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlsL2RldGVybWluZS1hdXRob3IudHMiXSwibmFtZXMiOlsiZCIsImV4ZWMiLCJjaGlsZFByb2Nlc3MiLCJleGVjQW5kVHJpbVJlc3VsdCIsImNvbW1hbmQiLCJkaXIiLCJjd2QiLCJzdGRvdXQiLCJ0cmltIiwiZ2V0QXV0aG9yRnJvbUdpdENvbmZpZyIsIm5hbWUiLCJlbWFpbCIsImVyciIsInVuZGVmaW5lZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7O0FBQ0E7O0FBRUE7O0FBQ0E7Ozs7Ozs7O0FBRUEsTUFBTUEsQ0FBQyxHQUFHLG9CQUFNLGlDQUFOLENBQVY7QUFDQSxNQUFNQyxJQUFJLEdBQUcscUJBQVVDLHVCQUFhRCxJQUF2QixDQUFiOztBQUVBLE1BQU1FLGlCQUFpQjtBQUFBO0FBQUE7QUFBQSwrQkFBRyxXQUFPQyxPQUFQLEVBQXdCQyxHQUF4QixFQUF3QztBQUFBLHdCQUN2Q0osSUFBSSxDQUFDRyxPQUFELEVBQVU7QUFBRUUsTUFBQUEsR0FBRyxFQUFFRDtBQUFQLEtBQVYsQ0FEbUM7QUFBQSxVQUN4REUsTUFEd0QsU0FDeERBLE1BRHdEOztBQUVoRSxXQUFPQSxNQUFNLENBQUNDLElBQVAsRUFBUDtBQUNELEdBSHNCOztBQUFBLGtCQUFqQkwsaUJBQWlCO0FBQUE7QUFBQTtBQUFBLEdBQXZCOztBQUtBLE1BQU1NLHNCQUFzQjtBQUFBO0FBQUE7QUFBQSxnQ0FBRyxXQUFPSixHQUFQLEVBQStDO0FBQzVFLFFBQUk7QUFDRixZQUFNSyxJQUFJLFNBQVNQLGlCQUFpQixDQUFDLDRCQUFELEVBQStCRSxHQUEvQixDQUFwQztBQUNBLFlBQU1NLEtBQUssU0FBU1IsaUJBQWlCLENBQUMsNkJBQUQsRUFBZ0NFLEdBQWhDLENBQXJDO0FBQ0EsYUFBTztBQUFFSyxRQUFBQSxJQUFGO0FBQVFDLFFBQUFBO0FBQVIsT0FBUDtBQUNELEtBSkQsQ0FJRSxPQUFPQyxHQUFQLEVBQVk7QUFDWlosTUFBQUEsQ0FBQyxDQUFDLGdDQUFELEVBQW1DWSxHQUFuQyxDQUFEO0FBQ0EsYUFBT0MsU0FBUDtBQUNEO0FBQ0YsR0FUMkI7O0FBQUEsa0JBQXRCSixzQkFBc0I7QUFBQTtBQUFBO0FBQUEsR0FBNUI7Ozs7O2dDQVdlLFdBQU9KLEdBQVA7QUFBQSxXQUF1QixPQUFPSSxzQkFBc0IsQ0FBQ0osR0FBRCxDQUE3QixLQUF1Qyx3QkFBOUQ7QUFBQSxHIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IGNoaWxkUHJvY2VzcyBmcm9tICdjaGlsZF9wcm9jZXNzJztcbmltcG9ydCBkZWJ1ZyBmcm9tICdkZWJ1Zyc7XG5pbXBvcnQgeyBQYWNrYWdlUGVyc29uIH0gZnJvbSAnQGVsZWN0cm9uLWZvcmdlL3NoYXJlZC10eXBlcyc7XG5pbXBvcnQgeyBwcm9taXNpZnkgfSBmcm9tICd1dGlsJztcbmltcG9ydCB1c2VybmFtZSBmcm9tICd1c2VybmFtZSc7XG5cbmNvbnN0IGQgPSBkZWJ1ZygnZWxlY3Ryb24tZm9yZ2U6ZGV0ZXJtaW5lLWF1dGhvcicpO1xuY29uc3QgZXhlYyA9IHByb21pc2lmeShjaGlsZFByb2Nlc3MuZXhlYyk7XG5cbmNvbnN0IGV4ZWNBbmRUcmltUmVzdWx0ID0gYXN5bmMgKGNvbW1hbmQ6IHN0cmluZywgZGlyOiBzdHJpbmcpID0+IHtcbiAgY29uc3QgeyBzdGRvdXQgfSA9IGF3YWl0IGV4ZWMoY29tbWFuZCwgeyBjd2Q6IGRpciB9KTtcbiAgcmV0dXJuIHN0ZG91dC50cmltKCk7XG59O1xuXG5jb25zdCBnZXRBdXRob3JGcm9tR2l0Q29uZmlnID0gYXN5bmMgKGRpcjogc3RyaW5nKTogUHJvbWlzZTxQYWNrYWdlUGVyc29uPiA9PiB7XG4gIHRyeSB7XG4gICAgY29uc3QgbmFtZSA9IGF3YWl0IGV4ZWNBbmRUcmltUmVzdWx0KCdnaXQgY29uZmlnIC0tZ2V0IHVzZXIubmFtZScsIGRpcik7XG4gICAgY29uc3QgZW1haWwgPSBhd2FpdCBleGVjQW5kVHJpbVJlc3VsdCgnZ2l0IGNvbmZpZyAtLWdldCB1c2VyLmVtYWlsJywgZGlyKTtcbiAgICByZXR1cm4geyBuYW1lLCBlbWFpbCB9O1xuICB9IGNhdGNoIChlcnIpIHtcbiAgICBkKCdFcnJvciB3aGVuIGdldHRpbmcgZ2l0IGNvbmZpZzonLCBlcnIpO1xuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cbn07XG5cbmV4cG9ydCBkZWZhdWx0IGFzeW5jIChkaXI6IHN0cmluZykgPT4gKGF3YWl0IGdldEF1dGhvckZyb21HaXRDb25maWcoZGlyKSkgfHwgdXNlcm5hbWUoKTtcbiJdfQ==