"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "StartOptions", {
  enumerable: true,
  get: function get() {
    return _sharedTypes.StartOptions;
  }
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _sharedTypes = require("@electron-forge/shared-types");

var _child_process = require("child_process");

var _path = _interopRequireDefault(require("path"));

var _readPackageJson = require("../util/read-package-json");

var _rebuild = _interopRequireDefault(require("../util/rebuild"));

var _resolveDir = _interopRequireDefault(require("../util/resolve-dir"));

var _forgeConfig = _interopRequireDefault(require("../util/forge-config"));

var _hook = require("../util/hook");

var _electronVersion = require("../util/electron-version");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var _default =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    appPath = '.',
    interactive = false,
    enableLogging = false,
    args = [],
    runAsNode = false,
    inspect = false
  }) {
    _asyncOra.asyncOra.interactive = interactive;
    yield (0, _asyncOra.asyncOra)('Locating Application',
    /*#__PURE__*/
    _asyncToGenerator(function* () {
      const resolvedDir = yield (0, _resolveDir.default)(dir);

      if (!resolvedDir) {
        throw new Error('Failed to locate startable Electron application');
      }

      dir = resolvedDir;
    }));
    const forgeConfig = yield (0, _forgeConfig.default)(dir);
    const packageJSON = yield (0, _readPackageJson.readMutatedPackageJson)(dir, forgeConfig);

    if (!packageJSON.version) {
      throw new Error(`Please set your application's 'version' in '${dir}/package.json'.`);
    }

    yield (0, _rebuild.default)(dir, (yield (0, _electronVersion.getElectronVersion)(dir, packageJSON)), process.platform, process.arch, forgeConfig.electronRebuildConfig);
    yield (0, _hook.runHook)(forgeConfig, 'generateAssets');
    let lastSpawned = null;

    const forgeSpawn =
    /*#__PURE__*/
    function () {
      var _ref3 = _asyncToGenerator(function* () {
        let electronExecPath = null; // If a plugin has taken over the start command let's stop here

        const spawnedPluginChild = yield forgeConfig.pluginInterface.overrideStartLogic({
          dir,
          appPath,
          interactive,
          enableLogging,
          args,
          runAsNode,
          inspect
        });
        let prefixArgs = [];

        if (typeof spawnedPluginChild === 'string') {
          electronExecPath = spawnedPluginChild;
        } else if (Array.isArray(spawnedPluginChild)) {
          var _spawnedPluginChild = _toArray(spawnedPluginChild);

          electronExecPath = _spawnedPluginChild[0];
          prefixArgs = _spawnedPluginChild.slice(1);
        } else if (spawnedPluginChild) {
          yield (0, _hook.runHook)(forgeConfig, 'postStart', spawnedPluginChild);
          return spawnedPluginChild;
        }

        if (!electronExecPath) {
          // eslint-disable-next-line import/no-dynamic-require, global-require
          electronExecPath = require(_path.default.resolve(dir, 'node_modules/electron'));
        }

        const spawnOpts = {
          cwd: dir,
          stdio: 'inherit',
          env: Object.assign({}, process.env, enableLogging ? {
            ELECTRON_ENABLE_LOGGING: 'true',
            ELECTRON_ENABLE_STACK_DUMPING: 'true'
          } : {})
        };

        if (runAsNode) {
          spawnOpts.env.ELECTRON_RUN_AS_NODE = 'true';
        } else {
          delete spawnOpts.env.ELECTRON_RUN_AS_NODE;
        }

        if (inspect) {
          args = ['--inspect'].concat(args);
        }

        let spawned;
        yield (0, _asyncOra.asyncOra)('Launching Application',
        /*#__PURE__*/
        _asyncToGenerator(function* () {
          spawned = (0, _child_process.spawn)(electronExecPath, prefixArgs.concat([appPath]).concat(args), spawnOpts);
        }));
        yield (0, _hook.runHook)(forgeConfig, 'postStart', spawned);
        return spawned;
      });

      return function forgeSpawn() {
        return _ref3.apply(this, arguments);
      };
    }();

    const forgeSpawnWrapper =
    /*#__PURE__*/
    function () {
      var _ref5 = _asyncToGenerator(function* () {
        const spawned = yield forgeSpawn(); // When the child app is closed we should stop listening for stdin

        if (spawned) {
          if (interactive && process.stdin.isPaused()) {
            process.stdin.resume();
          }

          spawned.on('exit', () => {
            if (spawned.restarted) return;
            if (!process.stdin.isPaused()) process.stdin.pause();
          });
        } else if (interactive && !process.stdin.isPaused()) {
          process.stdin.pause();
        }

        lastSpawned = spawned;
        return lastSpawned;
      });

      return function forgeSpawnWrapper() {
        return _ref5.apply(this, arguments);
      };
    }();

    if (interactive) {
      process.stdin.on('data',
      /*#__PURE__*/
      function () {
        var _ref6 = _asyncToGenerator(function* (data) {
          if (data.toString().trim() === 'rs' && lastSpawned) {
            // eslint-disable-next-line no-console
            console.info('\nRestarting App\n'.cyan);
            lastSpawned.restarted = true;
            lastSpawned.kill('SIGTERM');
            lastSpawned.emit('restarted', (yield forgeSpawnWrapper()));
          }
        });

        return function (_x2) {
          return _ref6.apply(this, arguments);
        };
      }());
    }

    return forgeSpawnWrapper();
  });

  return function (_x) {
    return _ref.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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