"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _path = _interopRequireDefault(require("path"));

var _forgeConfig = _interopRequireDefault(require("../util/forge-config"));

var _resolveDir = _interopRequireDefault(require("../util/resolve-dir"));

var _publishState = _interopRequireDefault(require("../util/publish-state"));

var _outDir = _interopRequireDefault(require("../util/out-dir"));

var _make = _interopRequireDefault(require("./make"));

var _requireSearch = _interopRequireDefault(require("../util/require-search"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:publish');

const publish =
/*#__PURE__*/
function () {
  var _ref = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false,
    makeOptions = {},
    publishTargets = undefined,
    dryRun = false,
    dryRunResume = false,
    makeResults = undefined,
    outDir
  }) {
    _asyncOra.asyncOra.interactive = interactive;

    if (dryRun && dryRunResume) {
      throw new Error("Can't dry run and resume a dry run at the same time");
    }

    if (dryRunResume && makeResults) {
      throw new Error("Can't resume a dry run and use the provided makeResults at the same time");
    }

    const forgeConfig = yield (0, _forgeConfig.default)(dir);
    const calculatedOutDir = outDir || (0, _outDir.default)(dir, forgeConfig);

    const dryRunDir = _path.default.resolve(calculatedOutDir, 'publish-dry-run');

    if (dryRunResume) {
      d('attempting to resume from dry run');
      const publishes = yield _publishState.default.loadFromDirectory(dryRunDir, dir);
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = publishes[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          const publishStates = _step.value;
          d('publishing for given state set');
          yield publish({
            dir,
            interactive,
            publishTargets,
            makeOptions,
            dryRun: false,
            dryRunResume: false,
            makeResults: publishStates.map(({
              state
            }) => state)
          });
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return;
    }

    if (!makeResults) {
      d('triggering make');
      makeResults = yield (0, _make.default)(Object.assign({
        dir,
        interactive
      }, makeOptions));
    } else {
      // Restore values from dry run
      d('restoring publish settings from dry run');
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = makeResults[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          const makeResult = _step2.value;
          makeOptions.platform = makeResult.platform;
          makeOptions.arch = makeResult.arch;
          var _iteratorNormalCompletion3 = true;
          var _didIteratorError3 = false;
          var _iteratorError3 = undefined;

          try {
            for (var _iterator3 = makeResult.artifacts[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
              const makePath = _step3.value;

              if (!(yield _fsExtra.default.pathExists(makePath))) {
                throw new Error(`Attempted to resume a dry run but an artifact (${makePath}) could not be found`);
              }
            }
          } catch (err) {
            _didIteratorError3 = true;
            _iteratorError3 = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion3 && _iterator3.return != null) {
                _iterator3.return();
              }
            } finally {
              if (_didIteratorError3) {
                throw _iteratorError3;
              }
            }
          }
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }

    if (dryRun) {
      d('saving results of make in dry run state', makeResults);
      yield _fsExtra.default.remove(dryRunDir);
      yield _publishState.default.saveToDirectory(dryRunDir, makeResults, dir);
      return;
    }

    const resolvedDir = yield (0, _resolveDir.default)(dir);

    if (!resolvedDir) {
      throw new Error('Failed to locate publishable Electron application');
    }

    dir = resolvedDir; // const testPlatform = makeOptions.platform || process.platform as ForgePlatform;

    if (!publishTargets) {
      publishTargets = forgeConfig.publishers || []; // .filter(publisher => (typeof publisher !== 'string' && publisher.platforms)
      //   ? publisher.platforms.indexOf(testPlatform) !== -1 : true);
    }

    publishTargets = publishTargets.map(target => {
      if (typeof target === 'string') {
        return (forgeConfig.publishers || []).find(p => {
          if (typeof p === 'string') return false; // eslint-disable-next-line no-underscore-dangle

          if (p.__isElectronForgePublisher) return false;
          return p.name === target;
        }) || {
          name: target
        };
      }

      return target;
    });
    var _iteratorNormalCompletion4 = true;
    var _didIteratorError4 = false;
    var _iteratorError4 = undefined;

    try {
      for (var _iterator4 = publishTargets[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
        const publishTarget = _step4.value;
        let publisher; // eslint-disable-next-line no-underscore-dangle

        if (publishTarget.__isElectronForgePublisher) {
          publisher = publishTarget;
        } else {
          const resolvablePublishTarget = publishTarget;
          let PublisherClass;
          yield (0, _asyncOra.asyncOra)(`Resolving publish target: ${`${resolvablePublishTarget.name}`.cyan}`,
          /*#__PURE__*/
          _asyncToGenerator(function* () {
            // eslint-disable-line no-loop-func
            PublisherClass = (0, _requireSearch.default)(dir, [resolvablePublishTarget.name]);

            if (!PublisherClass) {
              throw new Error(`Could not find a publish target with the name: ${resolvablePublishTarget.name}. Make sure it's listed in the devDependencies of your package.json`);
            }
          }));
          publisher = new PublisherClass(resolvablePublishTarget.config || {}, resolvablePublishTarget.platforms);
        }

        yield publisher.publish({
          dir,
          makeResults,
          forgeConfig
        });
      }
    } catch (err) {
      _didIteratorError4 = true;
      _iteratorError4 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion4 && _iterator4.return != null) {
          _iterator4.return();
        }
      } finally {
        if (_didIteratorError4) {
          throw _iteratorError4;
        }
      }
    }
  });

  return function publish(_x) {
    return _ref.apply(this, arguments);
  };
}();

var _default = publish;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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