"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("source-map-support/register");

require("colors");

var _asyncOra = require("@electron-forge/async-ora");

var _debug = _interopRequireDefault(require("debug"));

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _get = require("@electron/get");

var _glob = _interopRequireDefault(require("glob"));

var _electronPackager = _interopRequireDefault(require("electron-packager"));

var _path = _interopRequireDefault(require("path"));

var _util = require("util");

var _forgeConfig = _interopRequireDefault(require("../util/forge-config"));

var _hook = require("../util/hook");

var _messages = require("../util/messages");

var _readPackageJson = require("../util/read-package-json");

var _rebuild = _interopRequireDefault(require("../util/rebuild"));

var _requireSearch = _interopRequireDefault(require("../util/require-search"));

var _resolveDir = _interopRequireDefault(require("../util/resolve-dir"));

var _outDir = _interopRequireDefault(require("../util/out-dir"));

var _electronVersion = require("../util/electron-version");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

const d = (0, _debug.default)('electron-forge:packager');

/**
 * Resolves hooks if they are a path to a file (instead of a `Function`).
 */
function resolveHooks(hooks, dir) {
  if (hooks) {
    return hooks.map(hook => typeof hook === 'string' ? (0, _requireSearch.default)(dir, [hook]) : hook);
  }

  return [];
}
/**
 * Runs given hooks sequentially by mapping them to promises and iterating
 * through while awaiting
 */


function sequentialHooks(hooks) {
  return [
  /*#__PURE__*/
  function () {
    var _ref = _asyncToGenerator(function* (...args) {
      const done = args[args.length - 1];
      const passedArgs = args.splice(0, args.length - 1);
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = hooks[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          const hook = _step.value;
          yield (0, _util.promisify)(hook)(...passedArgs);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return != null) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      done();
    });

    return function () {
      return _ref.apply(this, arguments);
    };
  }()];
}

var _default =
/*#__PURE__*/
function () {
  var _ref2 = _asyncToGenerator(function* ({
    dir = process.cwd(),
    interactive = false,
    arch = (0, _get.getHostArch)(),
    platform = process.platform,
    outDir
  }) {
    const ora = interactive ? _asyncOra.ora : _asyncOra.fakeOra;
    let prepareSpinner = ora(`Preparing to Package Application for arch: ${(arch === 'all' ? 'ia32' : arch).cyan}`).start();
    let prepareCounter = 0;
    const resolvedDir = yield (0, _resolveDir.default)(dir);

    if (!resolvedDir) {
      throw new Error('Failed to locate compilable Electron application');
    }

    dir = resolvedDir;
    const forgeConfig = yield (0, _forgeConfig.default)(dir);
    const packageJSON = yield (0, _readPackageJson.readMutatedPackageJson)(dir, forgeConfig);

    if (!packageJSON.main) {
      throw new Error('packageJSON.main must be set to a valid entry point for your Electron app');
    }

    const calculatedOutDir = outDir || (0, _outDir.default)(dir, forgeConfig);
    let packagerSpinner = null;
    const pruneEnabled = !('prune' in forgeConfig.packagerConfig) || forgeConfig.packagerConfig.prune;
    const afterCopyHooks = [
    /*#__PURE__*/
    function () {
      var _ref3 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        if (packagerSpinner) {
          packagerSpinner.succeed();
          prepareCounter += 1;
          prepareSpinner = ora(`Preparing to Package Application for arch: ${(prepareCounter === 2 ? 'armv7l' : 'x64').cyan}`).start();
        }

        const bins = yield (0, _util.promisify)(_glob.default)(_path.default.join(buildPath, '**/.bin/**/*'));
        var _iteratorNormalCompletion2 = true;
        var _didIteratorError2 = false;
        var _iteratorError2 = undefined;

        try {
          for (var _iterator2 = bins[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            const bin = _step2.value;
            yield _fsExtra.default.remove(bin);
          }
        } catch (err) {
          _didIteratorError2 = true;
          _iteratorError2 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
              _iterator2.return();
            }
          } finally {
            if (_didIteratorError2) {
              throw _iteratorError2;
            }
          }
        }

        done();
      });

      return function (_x2, _x3, _x4, _x5, _x6) {
        return _ref3.apply(this, arguments);
      };
    }(),
    /*#__PURE__*/
    function () {
      var _ref4 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        prepareSpinner.succeed();
        yield (0, _hook.runHook)(forgeConfig, 'packageAfterCopy', buildPath, electronVersion, pPlatform, pArch);
        done();
      });

      return function (_x7, _x8, _x9, _x10, _x11) {
        return _ref4.apply(this, arguments);
      };
    }(),
    /*#__PURE__*/
    function () {
      var _ref5 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        yield (0, _rebuild.default)(buildPath, electronVersion, pPlatform, pArch, forgeConfig.electronRebuildConfig);
        packagerSpinner = ora('Packaging Application').start();
        done();
      });

      return function (_x12, _x13, _x14, _x15, _x16) {
        return _ref5.apply(this, arguments);
      };
    }()];
    afterCopyHooks.push(
    /*#__PURE__*/
    function () {
      var _ref6 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        const copiedPackageJSON = yield (0, _readPackageJson.readMutatedPackageJson)(buildPath, forgeConfig);

        if (copiedPackageJSON.config && copiedPackageJSON.config.forge) {
          delete copiedPackageJSON.config.forge;
        }

        yield _fsExtra.default.writeJson(_path.default.resolve(buildPath, 'package.json'), copiedPackageJSON, {
          spaces: 2
        });
        done();
      });

      return function (_x17, _x18, _x19, _x20, _x21) {
        return _ref6.apply(this, arguments);
      };
    }());
    afterCopyHooks.push(...resolveHooks(forgeConfig.packagerConfig.afterCopy, dir));
    const afterPruneHooks = [];

    if (pruneEnabled) {
      afterPruneHooks.push(...resolveHooks(forgeConfig.packagerConfig.afterPrune, dir));
    }

    afterPruneHooks.push(
    /*#__PURE__*/
    function () {
      var _ref7 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        yield (0, _hook.runHook)(forgeConfig, 'packageAfterPrune', buildPath, electronVersion, pPlatform, pArch);
        done();
      });

      return function (_x22, _x23, _x24, _x25, _x26) {
        return _ref7.apply(this, arguments);
      };
    }());
    const afterExtractHooks = [
    /*#__PURE__*/
    function () {
      var _ref8 = _asyncToGenerator(function* (buildPath, electronVersion, pPlatform, pArch, done) {
        yield (0, _hook.runHook)(forgeConfig, 'packageAfterExtract', buildPath, electronVersion, pPlatform, pArch);
        done();
      });

      return function (_x27, _x28, _x29, _x30, _x31) {
        return _ref8.apply(this, arguments);
      };
    }()];
    afterExtractHooks.push(...resolveHooks(forgeConfig.packagerConfig.afterExtract, dir));
    const packageOpts = Object.assign({
      asar: false,
      overwrite: true
    }, forgeConfig.packagerConfig, {
      dir,
      arch,
      platform,
      afterCopy: sequentialHooks(afterCopyHooks),
      afterExtract: sequentialHooks(afterExtractHooks),
      afterPrune: sequentialHooks(afterPruneHooks),
      out: calculatedOutDir,
      electronVersion: yield (0, _electronVersion.getElectronVersion)(dir, packageJSON)
    });
    packageOpts.quiet = true;

    if (packageOpts.all) {
      throw new Error('config.forge.packagerConfig.all is not supported by Electron Forge');
    }

    if (!packageJSON.version && !packageOpts.appVersion) {
      // eslint-disable-next-line max-len
      (0, _messages.warn)(interactive, 'Please set "version" or "config.forge.packagerConfig.appVersion" in your application\'s package.json so auto-updates work properly'.yellow);
    }

    if (packageOpts.prebuiltAsar) {
      throw new Error('config.forge.packagerConfig.prebuiltAsar is not supported by Electron Forge');
    }

    yield (0, _hook.runHook)(forgeConfig, 'generateAssets');
    yield (0, _hook.runHook)(forgeConfig, 'prePackage');
    d('packaging with options', packageOpts);
    yield (0, _electronPackager.default)(packageOpts);
    yield (0, _hook.runHook)(forgeConfig, 'postPackage');
    if (packagerSpinner) packagerSpinner.succeed();
  });

  return function (_x) {
    return _ref2.apply(this, arguments);
  };
}();

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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